/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.alibaba.fastjson.JSONObject;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.portal.entity.PfNews;
import com.gtis.portal.service.LogService;
import com.gtis.portal.service.PfLogService;
import com.gtis.portal.service.PfNewsService;
import com.gtis.web.SessionUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/news"})
public class NewsController {
    @Autowired
    private PfNewsService pfNewsService;
    private static final int PAGE_SIZE = 10;
    private HashMap<String, Object> dateUserFlag = new HashMap();
    @Autowired
    NodeService nodeService;
    @Autowired
    LogService logService;
    @Autowired
    PfLogService pfLogService;

    @RequestMapping(value={"/list"})
    public String list(Model model) throws Exception {
        return "newslist";
    }

    @ResponseBody
    @RequestMapping(value={"/newsListPage"})
    public Object newsListPage(Model model, Pageable page, String dcxc, String beginDate, String endDate) {
        Page newsListPage = null;
        int size = page == null ? 10 : page.getPageSize();
        int pagenum = page == null ? 1 : page.getPageNumber();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date beginTime = null;
        Date endTime = null;
        try {
            if (StringUtils.isNotBlank((String)beginDate)) {
                beginTime = sdf.parse(beginDate);
            }
            if (StringUtils.isNotBlank((String)endDate)) {
                endTime = sdf.parse(endDate);
            }
            page = new PageRequest(pagenum, size, Sort.Direction.DESC, new String[]{"newdate"});
            newsListPage = this.pfNewsService.queryNewsList(dcxc, beginTime, endTime, page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (newsListPage == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("rows", (Object)newsListPage.getContent());
        json.put("total", (Object)newsListPage.getTotalPages());
        json.put("records", (Object)newsListPage.getTotalElements());
        json.put("page", (Object)(newsListPage.getNumber() + 1));
        json.put("pageSize", (Object)newsListPage.getSize());
        return json;
    }

    @ResponseBody
    @RequestMapping(value={"/deleteNews"})
    public Object deleteNews(PfNews pfNews, HttpServletRequest request) {
        boolean result = false;
        if (pfNews != null && StringUtils.isNotBlank((String)pfNews.getNewid())) {
            this.pfNewsService.deleteNews(pfNews);
            this.logService.saveLog(request, SessionUtil.getCurrentUserId(), "\u7528\u6237\u5220\u9664" + pfNews.getNewid(), "\u5220\u9664\u4fe1\u606f\u53d1\u5e03");
            result = true;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/createNews"})
    public Object createNews(PfNews pfNews, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        try {
            if (StringUtils.isBlank((String)pfNews.getNewid())) {
                String newId = UUIDGenerator.generate18();
                Space space = this.nodeService.getWorkSpace("MESSAGE_FILE", true);
                Node msgNode = this.nodeService.getNode(space.getId(), newId, true);
                Integer nodeId = msgNode.getId();
                String token = this.nodeService.getToken(msgNode);
                result.put("newId", newId);
                result.put("nodeId", nodeId);
                result.put("token", token);
            } else {
                this.pfNewsService.saveNews(pfNews);
                this.logService.saveLog(request, SessionUtil.getCurrentUserId(), "\u7528\u6237\u65b0\u589e" + pfNews.getNewid(), "\u65b0\u589e\u4fe1\u606f\u53d1\u5e03");
                result.put("result", true);
            }
        }
        catch (Exception e) {
            result.put("result", false);
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/getModify"})
    @ResponseBody
    public Object getModify(@RequestParam(value="newId", required=true) String newId, String messageType, Model model) {
        Space space = this.nodeService.getWorkSpace("MESSAGE_FILE", true);
        Node msgNode = this.nodeService.getNode(space.getId(), newId, true);
        Integer nodeId = msgNode.getId();
        String token = this.nodeService.getToken(msgNode);
        PfNews pfNews = this.pfNewsService.getById(newId);
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("token", token);
        result.put("nodeId", nodeId);
        result.put("pfNews", pfNews);
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/updateNews"})
    public Object updateNews(PfNews pfNews, HttpServletRequest request) {
        boolean result = false;
        try {
            this.pfNewsService.updateNews(pfNews);
            this.logService.saveLog(request, SessionUtil.getCurrentUserId(), "\u7528\u6237\u4fee\u6539" + pfNews.getNewid(), "\u4fee\u6539\u4fe1\u606f\u53d1\u5e03");
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/getRecentNews"})
    @ResponseBody
    public PfNews getRecentNews() {
        List pfNewsList = this.pfNewsService.getList();
        Date date = new Date();
        PfNews pfNews = null;
        if (pfNewsList.size() > 0 && "1".equals(((PfNews)pfNewsList.get(0)).getIspublish())) {
            for (PfNews pfNews1 : pfNewsList) {
                if (pfNews1.getNewdate().compareTo(date) >= 0) continue;
                pfNews = pfNews1;
                break;
            }
            return pfNews;
        }
        return null;
    }

    @RequestMapping(value={"/getPublicNewsConfirm"})
    @ResponseBody
    public Object getPublicNewsConfirm() {
        Date newdate;
        List pfLogList;
        String userId = SessionUtil.getCurrentUserId();
        boolean result = false;
        PfNews recentNews = this.getRecentNews();
        if (recentNews != null && (pfLogList = this.pfLogService.getRecentLogByTimeAndUser(newdate = recentNews.getNewdate(), userId)) != null && pfLogList.size() <= 2) {
            result = true;
            if (newdate != null && userId != null) {
                if (this.dateUserFlag != null && newdate.equals(this.dateUserFlag.get("date")) && userId.equals(this.dateUserFlag.get("user"))) {
                    result = false;
                }
                this.dateUserFlag.put("date", newdate);
                this.dateUserFlag.put("user", userId);
            }
        }
        return result;
    }
}

