/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.util.ImageUtil;
import com.gtis.portal.util.ReadXmlProps;
import com.gtis.portal.util.WaterMarkBO;
import com.gtis.portal.web.BaseController;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IndexController
extends BaseController {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysDistrictService sysDistrictService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysActivityService sysActivityService;
    private static final String PASSWORD_REG_EXP = "^(?![A-Z]+$)(?![a-z]+$)(?!\\d+$)(?![\\W_]+$)\\S{6,16}$";
    private static final String PASSWORD_REG_EXP2 = "^(?=.*[A-Za-z])(?=.*\\d)(?=.*[$@$!%*#?&])[A-Za-z\\d$@$!%*#?&]{8,}$";

    @RequestMapping(value={"index"})
    public String index(Model model, String systemId, HttpServletRequest request) {
        String bdcjyUrl;
        String oaUrl;
        String xzqdm = request.getParameter("xzqdm");
        UserInfo userInfo = SessionUtil.getCurrentUser();
        model.addAttribute("userName", (Object)SessionUtil.getCurrentUser().getUsername());
        List organList = userInfo.getLstOragn();
        String organ = "";
        if (organList != null && organList.size() > 0) {
            organ = ((PfOrganVo)organList.get(0)).getOrganName();
        }
        model.addAttribute("organName", (Object)organ);
        String defaultDistrictCode = AppConfig.getProperty((String)"district.code");
        List districtList = StringUtils.isNotBlank((String)defaultDistrictCode) ? this.sysDistrictService.querySubDistrictByCode(AppConfig.getProperty((String)"district.code")) : this.sysDistrictService.queryAllDistrict();
        PfUserVo pfUserVo = this.sysUserService.getUserVo(SessionUtil.getCurrentUserId());
        model.addAttribute("districtList", (Object)districtList);
        if (StringUtils.isBlank((String)systemId)) {
            systemId = AppConfig.getProperty((String)"portal.system.default");
        }
        String hideLogoutBtn = "false";
        if (StringUtils.isNotBlank((String)AppConfig.getProperty((String)"hide.logout.btn"))) {
            hideLogoutBtn = AppConfig.getProperty((String)"hide.logout.btn");
        }
        List deployRegionList = ReadXmlProps.getDeployRegionList((String)pfUserVo.getLoginName());
        Map regionMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)deployRegionList)) {
            if (StringUtils.isBlank((String)xzqdm)) {
                regionMap.put("xzqdm", ((Map)deployRegionList.get(0)).get("xzqdm"));
                regionMap.put("xzqmc", ((Map)deployRegionList.get(0)).get("xzqmc"));
                regionMap.put("sysUrl", ((Map)deployRegionList.get(0)).get("sysUrl"));
                regionMap.put("getTaskCountUrl", ((Map)deployRegionList.get(0)).get("getTaskCountUrl"));
            } else {
                for (Map deployRegionMap : deployRegionList) {
                    if (deployRegionMap.get("xzqdm") == null || !StringUtils.equals((String)xzqdm, (String)deployRegionMap.get("xzqdm").toString())) continue;
                    regionMap = deployRegionMap;
                }
            }
        }
        if (StringUtils.isNotBlank((String)(oaUrl = AppConfig.getProperty((String)"oa.href")))) {
            oaUrl = StringUtils.substring((String)oaUrl, (int)0, (int)oaUrl.indexOf("${")) + pfUserVo.getLoginName() + StringUtils.substring((String)oaUrl, (int)(oaUrl.indexOf("}") + 1), (int)oaUrl.length());
        }
        if (StringUtils.isNotBlank((String)(bdcjyUrl = AppConfig.getProperty((String)"bdcjy.href")))) {
            bdcjyUrl = StringUtils.substring((String)bdcjyUrl, (int)0, (int)bdcjyUrl.indexOf("${")) + pfUserVo.getLoginName() + StringUtils.substring((String)bdcjyUrl, (int)(bdcjyUrl.indexOf("}") + 1), (int)bdcjyUrl.length());
        }
        String iframeUrl = AppConfig.getProperty((String)"net.iframe.url");
        boolean iframeEnable = false;
        if (StringUtils.isNotBlank((String)iframeUrl)) {
            iframeUrl = StringUtils.substring((String)iframeUrl, (int)0, (int)iframeUrl.indexOf("{1}")) + pfUserVo.getLoginName() + StringUtils.substring((String)iframeUrl, (int)(iframeUrl.indexOf("{1}") + 3), (int)iframeUrl.indexOf("{2}")) + ClientInfoUtil.getIpAddr((HttpServletRequest)request) + StringUtils.substring((String)iframeUrl, (int)(iframeUrl.indexOf("{2}") + 3));
            iframeEnable = true;
            this.logger.info((Object)("iframe\u7684url\u5730\u5740\uff1a" + iframeUrl));
        }
        model.addAttribute("iframeEnable", (Object)iframeEnable);
        model.addAttribute("iframeUrl", (Object)iframeUrl);
        model.addAttribute("subsystemId", (Object)systemId);
        model.addAttribute("ompUrl", (Object)AppConfig.getProperty((String)"omp.href"));
        model.addAttribute("archiveUrl", (Object)AppConfig.getProperty((String)"archive.url"));
        model.addAttribute("bdcdjUrl", (Object)AppConfig.getProperty((String)"bdcdj.url"));
        model.addAttribute("showLeftMenuMethod", (Object)AppConfig.getProperty((String)"show.left.menu.method"));
        model.addAttribute("hideLogoutBtn", (Object)hideLogoutBtn);
        model.addAttribute("userid", (Object)userInfo.getId());
        model.addAttribute("username", (Object)userInfo.getUsername());
        model.addAttribute("loginname", (Object)pfUserVo.getLoginName());
        model.addAttribute("clientIp", (Object)ClientInfoUtil.getIpAddr((HttpServletRequest)request));
        model.addAttribute("subStyle", (Object)AppConfig.getProperty((String)"portal.subsystem.style"));
        model.addAttribute("deployRegionList", (Object)deployRegionList);
        model.addAttribute("regionMap", regionMap);
        model.addAttribute("oaUrl", (Object)oaUrl);
        model.addAttribute("bdcjyUrl", (Object)bdcjyUrl);
        model.addAttribute("showRegionEnable", (Object)AppConfig.getProperty((String)"change.deploy.region.enable"));
        String zwFrameEnable = AppConfig.getProperty((String)"zw.portal.frame.enable");
        if (StringUtils.equals((String)zwFrameEnable, (String)"true")) {
            return "index/base/index-base";
        }
        return "index";
    }

    @RequestMapping(value={"password"})
    @ResponseBody
    public Object password(Model model, String oldPassword, String newPassword, String confirmNewPassword) throws Exception {
        if (!newPassword.equals(confirmNewPassword)) {
            throw new PortalException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        }
        if (AppConfig.getBooleanProperty((String)"password.complexity.enable", (boolean)false) && !this.checkPasswordComplexity(newPassword).booleanValue()) {
            throw new PortalException(ExceptionCode.PASSWORD_COMPLEXITY);
        }
        if (AppConfig.getBooleanProperty((String)"password.complexity2.enable", (boolean)false) && !this.checkPasswordComplexity2(newPassword).booleanValue()) {
            throw new PortalException(ExceptionCode.PASSWORD_COMPLEXITY2);
        }
        String userId = SessionUtil.getCurrentUserId();
        PfUserVo userObj = this.sysUserService.getUserVo(userId);
        if (userObj == null) {
            throw new PortalException(ExceptionCode.USER_NOT_FOUND);
        }
        String checkpass = oldPassword;
        String md5 = Md5Util.Build((String)checkpass);
        if (md5.equals(userObj.getLoginPassWord())) {
            if (this.sysUserService.savePassWord(userId, newPassword)) {
                return this.handlerSuccessJson();
            }
            throw new PortalException(ExceptionCode.USER_MODIFY_ERROR);
        }
        throw new PortalException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
    }

    @RequestMapping(value={"signPassword"})
    @ResponseBody
    public Object signPassword(Model model, String oldSignPassword, String newSignPassword, String confirmNewSignPassword) throws Exception {
        if (StringUtils.isBlank((String)newSignPassword)) {
            throw new PortalException(ExceptionCode.PASSWORD_BLANK);
        }
        if (!newSignPassword.equals(confirmNewSignPassword)) {
            throw new PortalException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        }
        String userId = SessionUtil.getCurrentUserId();
        PfUserVo userObj = this.sysUserService.getUserVo(userId);
        if (userObj == null) {
            throw new PortalException(ExceptionCode.USER_NOT_FOUND);
        }
        String checkpass = oldSignPassword;
        String md5 = Md5Util.Build((String)checkpass);
        if (md5.equals(userObj.getSignPassword()) || StringUtils.isBlank((String)userObj.getSignPassword())) {
            if (this.sysUserService.saveSignPassword(userId, newSignPassword)) {
                return this.handlerSuccessJson();
            }
            throw new PortalException(ExceptionCode.USER_MODIFY_ERROR);
        }
        throw new PortalException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
    }

    private Boolean checkPasswordComplexity(String password) {
        Pattern pattern = Pattern.compile(PASSWORD_REG_EXP);
        Matcher matcher = pattern.matcher(password);
        return matcher.matches();
    }

    private Boolean checkPasswordComplexity2(String password) {
        Pattern pattern = Pattern.compile(PASSWORD_REG_EXP2);
        Matcher matcher = pattern.matcher(password);
        return matcher.matches();
    }

    @RequestMapping(value={"logout"})
    public String logout(HttpSession httpSession) {
        httpSession.invalidate();
        return "redirect:/logout.action";
    }

    @RequestMapping(value={"two/index"})
    public String twoIndex(Model model, String systemId, @RequestParam(value="subMenuType", required=false) String subMenuType) {
        String subStyle;
        UserInfo userInfo = SessionUtil.getCurrentUser();
        model.addAttribute("userName", (Object)SessionUtil.getCurrentUser().getUsername());
        List organList = userInfo.getLstOragn();
        String organ = "";
        if (organList != null && organList.size() > 0) {
            organ = ((PfOrganVo)organList.get(0)).getOrganName();
        }
        model.addAttribute("organName", (Object)organ);
        String defaultDistrictCode = AppConfig.getProperty((String)"district.code");
        List districtList = StringUtils.isNotBlank((String)defaultDistrictCode) ? this.sysDistrictService.querySubDistrictByCode(AppConfig.getProperty((String)"district.code")) : this.sysDistrictService.queryAllDistrict();
        model.addAttribute("districtList", (Object)districtList);
        if (StringUtils.isBlank((String)systemId)) {
            systemId = AppConfig.getProperty((String)"portal.system.default");
        }
        if (StringUtils.isBlank((String)subMenuType)) {
            subMenuType = "two";
        }
        if (StringUtils.isBlank((String)(subStyle = AppConfig.getProperty((String)"portal.subsystem.style")))) {
            subStyle = "greenStyle";
        }
        model.addAttribute("subStyle", (Object)subStyle);
        model.addAttribute("subsystemId", (Object)systemId);
        model.addAttribute("subMenuType", (Object)subMenuType);
        model.addAttribute("ompUrl", (Object)AppConfig.getProperty((String)"omp.href"));
        model.addAttribute("archiveUrl", (Object)AppConfig.getProperty((String)"archive.url"));
        model.addAttribute("bdcdjUrl", (Object)AppConfig.getProperty((String)"bdcdj.url"));
        return "index/index-two-menu";
    }

    @RequestMapping(value={"/showWatermark"})
    public void showWatermark(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WaterMarkBO waterMarkBO = new WaterMarkBO();
        waterMarkBO.setMarkContent(SessionUtil.getUserName((HttpServletRequest)request));
        waterMarkBO.setFontSize(20);
        waterMarkBO.setFontType("STCAIYUN");
        waterMarkBO.setFontType("STCAIYUN");
        response.setContentType("image/png");
        ServletOutputStream os = response.getOutputStream();
        ImageIO.write((RenderedImage)ImageUtil.createMark((WaterMarkBO)waterMarkBO), "png", (OutputStream)os);
        os.flush();
        os.close();
    }

    @ResponseBody
    @RequestMapping(value={"/test"})
    public Object test(HttpServletRequest request) throws Exception {
        HashMap map = new HashMap();
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/beforeTurnProjectEvent"}, method={RequestMethod.GET})
    public void beforeTurnProjectEvent(@RequestParam(value="proid", required=false) String proid, @RequestParam(value="activityid", required=false) String activityid, @RequestParam(value="userid", required=false) String userid, @RequestParam(value="taskid", required=false) String taskid, HttpServletResponse response) {
        String str = "[{'msg':'\u9a8c\u8bc1\u4fe1\u606f1','checkModel':'confirm'},{'msg':'\u9a8c\u8bc1\u4fe1\u606f2','checkModel':'confirm'}]";
        try {
            response.setContentType("text/xml;charset=GBK");
            PrintWriter out = response.getWriter();
            out.println(str);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    @RequestMapping(value={"getDeployRegionTaskCount"})
    @ResponseBody
    public Object getDeployRegionTaskCount(Model model, String urls, String xzqdms) {
        HashMap taskCountMap = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)urls) && StringUtils.isNotBlank((String)xzqdms) && StringUtils.split((String)urls, (String)",").length == StringUtils.split((String)xzqdms, (String)",").length) {
            String userIds = SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds();
            String[] xzqdmStr = xzqdms.split(",");
            int i = 0;
            for (String url : urls.split(",")) {
                String taskCount = "";
                try {
                    HttpInvokerProxyFactoryBean httpInvokerProxyFactoryBean = new HttpInvokerProxyFactoryBean();
                    httpInvokerProxyFactoryBean.setServiceInterface(SysWorkFlowInstanceService.class);
                    httpInvokerProxyFactoryBean.setServiceUrl(url);
                    httpInvokerProxyFactoryBean.afterPropertiesSet();
                    SysWorkFlowInstanceService workFlowInstanceService = (SysWorkFlowInstanceService)httpInvokerProxyFactoryBean.getObject();
                    HashMap mapParam = Maps.newHashMap();
                    mapParam.put("userIds", userIds);
                    taskCount = workFlowInstanceService.getTaskCount(mapParam);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (StringUtils.isBlank((String)taskCount)) {
                    taskCount = "0";
                }
                taskCountMap.put(xzqdmStr[i], taskCount);
                ++i;
            }
        }
        return taskCountMap;
    }

    @RequestMapping(value={"editPassword"})
    public String editPassword(Model model, String loginName) {
        model.addAttribute("loginName", (Object)loginName);
        return "editPassword";
    }

    @RequestMapping(value={"checkPassword"})
    @ResponseBody
    public Object checkPassword(String password) {
        HashMap msgMap = Maps.newHashMap();
        String msg = "ok";
        if (AppConfig.getBooleanProperty((String)"password.complexity.enable", (boolean)false) && !this.checkPasswordComplexity(password).booleanValue()) {
            msg = new PortalException(ExceptionCode.PASSWORD_COMPLEXITY).getMessage();
        }
        msgMap.put("msg", msg);
        return msgMap;
    }

    @RequestMapping(value={"savePassword"})
    @ResponseBody
    public Object savePassword(Model model, String loginName, String oldPassword, String newPassword, String confirmNewPassword) throws Exception {
        if (!newPassword.equals(confirmNewPassword)) {
            throw new PortalException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        }
        if (AppConfig.getBooleanProperty((String)"password.complexity.enable", (boolean)false) && !this.checkPasswordComplexity(newPassword).booleanValue()) {
            throw new PortalException(ExceptionCode.PASSWORD_COMPLEXITY);
        }
        PfUserVo userObj = this.sysUserService.getUserByloginName(loginName);
        if (userObj == null) {
            throw new PortalException(ExceptionCode.USER_NOT_FOUND);
        }
        String checkpass = oldPassword;
        String md5 = Md5Util.Build((String)checkpass);
        if (md5.equals(userObj.getLoginPassWord())) {
            if (this.sysUserService.savePassWord(userObj.getUserId(), newPassword)) {
                return this.handlerSuccessJson();
            }
            throw new PortalException(ExceptionCode.USER_MODIFY_ERROR);
        }
        throw new PortalException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
    }
}

