/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.service.TaskActionService;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/batchFinishTask"})
public class BatchFinishTaskController
extends BaseController {
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysActivityService sysActivityService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    TaskActionService taskActionService;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public String createAllFileFolder(Model model, @RequestParam(value="taskId", required=false) String taskId) {
        String fileCenterUrl = "fcm";
        String project_fileId = null;
        fileCenterUrl = fileCenterUrl + AppConfig.getFileCenterUrl().substring(4);
        ArrayList<String> proidList = null;
        Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
        PfTaskVo pfTaskVo = this.sysTaskService.getTask(taskId);
        PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
        PfWorkFlowInstanceVo workFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
        if (workFlowInstanceVo != null && StringUtils.isNotBlank((String)workFlowInstanceVo.getProId())) {
            proidList = new ArrayList<String>();
            proidList.add(workFlowInstanceVo.getProId());
        }
        if (CollectionUtils.isNotEmpty(proidList)) {
            try {
                for (String proid : proidList) {
                    Node node = this.nodeService.getNode(space.getId(), proid, true);
                    String nodeName = AppConfig.getProperty((String)"batchUploadFile.name");
                    Node uploadNode = this.nodeService.getNode(node.getId(), nodeName, true);
                    if (uploadNode != null && StringUtils.isBlank(project_fileId)) {
                        project_fileId = uploadNode.getId().toString();
                        continue;
                    }
                    project_fileId = project_fileId + "," + uploadNode.getId().toString();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (workFlowInstanceVo == null) {
            workFlowInstanceVo = new PfWorkFlowInstanceVo();
        }
        model.addAttribute("fileCenterUrl", (Object)fileCenterUrl);
        model.addAttribute("nodeId", project_fileId);
        model.addAttribute("username", (Object)SessionUtil.getCurrentUser().getUsername());
        model.addAttribute("userid", (Object)SessionUtil.getCurrentUser().getId());
        model.addAttribute("uploadTaskId", (Object)taskId);
        model.addAttribute("workFlowInstanceVo", (Object)workFlowInstanceVo);
        return "task-upload-file";
    }

    @RequestMapping(value={"batchFinishTask"})
    @ResponseBody
    public Object batchFinishTask(HttpServletRequest request, @RequestParam(value="uploadTaskId", required=false) String uploadTaskId, @RequestParam(value="uploadNodeId", required=false) String uploadNodeId, @RequestParam(value="taskIds", required=false) String taskIds, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskIds)) {
                for (String taskid : taskIds.split(",")) {
                    PfTaskVo pfTaskVo = this.sysTaskService.getTask(taskid);
                    if (pfTaskVo == null || !StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) continue;
                    PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                        pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    }
                    String wiid = "";
                    String proid = "";
                    if (pfWorkFlowInstanceVo != null) {
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                        proid = pfWorkFlowInstanceVo.getProId();
                    }
                    if (!StringUtils.equals((String)uploadTaskId, (String)taskid)) {
                        Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
                        String nodeName = AppConfig.getProperty((String)"batchUploadFile.name");
                        Node destNode = this.nodeService.getNode(space.getId(), proid, true);
                        Node updateNode = this.nodeService.getNode(destNode.getId(), nodeName, true);
                        this.nodeService.remove(updateNode.getId());
                        Integer[] nodeIdList = new Integer[]{Integer.parseInt(uploadNodeId)};
                        this.nodeService.copy(nodeIdList, destNode.getId(), true);
                    }
                    this.taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "", null);
                }
            }
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"uploadFileCount"})
    @ResponseBody
    public Object uploadFileCount(HttpServletRequest request, @RequestParam(value="uploadNodeId", required=false) String uploadNodeId) {
        HashMap map = Maps.newHashMap();
        int count = this.nodeService.getAllChildFilesCount(Integer.valueOf(Integer.parseInt(uploadNodeId)));
        map.put("count", count);
        return map;
    }
}

