/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.util;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.FileService;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.spring.Container;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtil {
    public static boolean deleteDirectory(String sPath) throws Exception {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = false;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileUtil.deleteFile((String)files[i].getAbsolutePath())) : !(flag = FileUtil.deleteDirectory((String)files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        flag = false;
        if (dirFile.delete()) {
            flag = true;
        }
        return flag;
    }

    public static boolean deleteFile(String sPath) throws Exception {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String oldPath, String newPath) throws IOException {
        boolean isok = false;
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            File file = new File(newPath);
            if (!file.exists()) {
                FileUtil.createFiles((String)newPath);
            }
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                inStream = new FileInputStream(oldfile);
                fs = new FileOutputStream(file);
                byte[] buffer = new byte[1444];
                while ((byteread = inStream.read(buffer)) != -1) {
                    fs.write(buffer, 0, byteread);
                }
                inStream.close();
                isok = true;
            }
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236\u5355\u4e2a\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (fs != null) {
                fs.close();
            }
        }
        return isok;
    }

    public static Boolean createFiles(String path) {
        Boolean flag = false;
        File file = null;
        if (!path.equals("") || path != null) {
            file = new File(path);
            if (!file.exists()) {
                if (file.isDirectory()) {
                    file.mkdirs();
                } else {
                    File fileDir = new File(file.getParent());
                    fileDir.mkdirs();
                    System.out.println("\u4e0a\u5c42\u6587\u4ef6\u5939\uff1a " + fileDir);
                    try {
                        flag = file.createNewFile();
                        System.out.println("\u6587\u4ef6\u540d\u79f0\uff1a" + file);
                    }
                    catch (IOException e) {
                        System.out.println("\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff1a" + e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                System.out.println("\u3010" + path + "\u3011\uff1a" + "\u8be5\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728");
            }
        }
        return flag;
    }

    public static boolean DeleteFolder(String sPath) throws Exception {
        boolean flag = false;
        File file = new File(sPath);
        if (!file.exists()) {
            return flag;
        }
        if (file.isFile()) {
            return FileUtil.deleteFile((String)sPath);
        }
        return FileUtil.deleteDirectory((String)sPath);
    }

    public static Boolean createDirectory(String dirPath, boolean isreplace) throws Exception {
        Boolean flag = false;
        if (StringUtils.isNotBlank((String)dirPath)) {
            File file = new File(dirPath);
            if (file.exists()) {
                if (isreplace) {
                    FileUtil.DeleteFolder((String)dirPath);
                    file.mkdirs();
                }
            } else {
                file.mkdirs();
            }
        }
        return flag;
    }

    public static String findFileByName(String dirName, String fileName) {
        File file = new File(dirName);
        return FileUtil.findFileByName((File)file, (String)fileName);
    }

    public static String findFileByName(File dir, String fileName) {
        File[] files;
        String filePath = "";
        if (dir != null && dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    filePath = FileUtil.findFileByName((File)files[i], (String)fileName);
                } else if (files[i].getName().equalsIgnoreCase(fileName)) {
                    filePath = files[i].getAbsolutePath();
                }
                if (StringUtils.isNotBlank((String)filePath)) break;
            }
        }
        return filePath;
    }

    public static void createFileCenterNodeByFolder(String proID, String dirName, String spacecode) {
        File dirFile;
        if (StringUtils.isNotBlank((String)dirName) && (dirFile = new File(dirName)) != null && dirFile.exists() && dirFile.isDirectory()) {
            NodeService nodeService = (NodeService)Container.getBean((String)"NodeService");
            FileService fileService = (FileService)Container.getBean((String)"FileService");
            Space space = nodeService.getWorkSpace(spacecode, true);
            Node node = nodeService.getNode(space.getId(), proID, true);
            Integer nodeId = node.getId();
            String token = nodeService.getToken(node);
            Node nodeChild = nodeService.getNode(nodeId, dirFile.getName(), false);
            if (nodeChild != null) {
                nodeService.remove(nodeChild.getId());
            }
            FileUtil.createFileCenterNodeByFile((File)dirFile, (Node)node, (NodeService)nodeService, (FileService)fileService);
        }
    }

    public static void createFileCenterNodeByFile(File file, Node node, NodeService nodeService, FileService fileService) {
        if (file != null && file.exists()) {
            try {
                Node fileNode = FileUtil.getOrCreateNode((Integer)node.getId(), (String)file.getName(), (NodeService)nodeService);
                System.out.println(fileNode.getName());
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files != null && files.length > 0) {
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i].isDirectory()) {
                                FileUtil.createFileCenterNodeByFile((File)files[i], (Node)fileNode, (NodeService)nodeService, (FileService)fileService);
                                continue;
                            }
                            if (!files[i].isFile()) continue;
                            fileService.uploadFile(files[i], fileNode.getId(), null, null, true, false);
                        }
                    }
                } else if (file.isFile()) {
                    fileService.uploadFile(file, fileNode.getId(), null, null, true, false);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public static Node getOrCreateNode(Integer nid, String fName, NodeService nodeService) {
        Node nodeChild = null;
        try {
            nodeChild = nodeService.getNode(nid, fName, true);
        }
        catch (Exception e) {
            nodeChild = nodeService.createNode(nid, fName);
            nodeChild.setViewName(fName);
            nodeChild.setName(fName);
            nodeChild.setDescription(fName);
            nodeService.save(nodeChild);
        }
        if (nodeChild == null) {
            nodeChild = nodeService.getNode(nid, fName, true);
            nodeChild.setViewName(fName);
            nodeChild.setName(fName);
            nodeChild.setDescription(fName);
            nodeService.save(nodeChild);
        }
        return nodeChild;
    }

    public static List<String> getFileName(String dirPath, String type, String name) throws Exception {
        ArrayList<String> strList = new ArrayList<String>();
        File dirFile = new File(dirPath);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return null;
        }
        type = type.toLowerCase();
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                String filename = files[i].getAbsolutePath();
                int point = filename.lastIndexOf(".") + 1;
                String filetype = filename.substring(point, filename.length());
                if ((filetype = filetype.toLowerCase()) == null || StringUtils.indexOf((String)type, (String)filetype) <= -1) continue;
                if (StringUtils.isNotBlank((String)name) && filename.indexOf(name) > -1) {
                    strList = new ArrayList();
                    strList.add(filename);
                    break;
                }
                strList.add(filename);
                continue;
            }
            if (!files[i].isDirectory()) continue;
        }
        return strList;
    }

    public static List<HashMap<String, String>> getFileMapList(String dirPath, String type, String name) throws Exception {
        ArrayList<HashMap<String, String>> strList = new ArrayList<HashMap<String, String>>();
        File dirFile = new File(dirPath);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return null;
        }
        type = type.toLowerCase();
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                HashMap<String, String> fileMap = new HashMap<String, String>();
                String filename = files[i].getName();
                String filepath = files[i].getAbsolutePath();
                int point = filename.lastIndexOf(".") + 1;
                String filetype = filename.substring(point, filename.length());
                filename = filename.substring(0, point - 1);
                if ((filetype = filetype.toLowerCase()) == null || StringUtils.indexOf((String)type, (String)filetype) <= -1) continue;
                fileMap.put("filename", filename);
                fileMap.put("filetype", filetype);
                fileMap.put("filepath", filepath);
                if (StringUtils.isNotBlank((String)name) && filename.indexOf(name) > -1) {
                    strList = new ArrayList();
                    strList.add(fileMap);
                    break;
                }
                strList.add(fileMap);
                continue;
            }
            if (!files[i].isDirectory()) continue;
        }
        return strList;
    }

    public static Integer createFileCenterFolder(String proID, String foldName) throws Exception {
        Space space = null;
        Integer nodeId = null;
        try {
            NodeService nodeService = (NodeService)Container.getBean((String)"NodeService");
            space = nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
            Node prjNode = nodeService.getNode(space.getId(), proID, true);
            Integer proNodeid = prjNode.getId();
            Node cityNode = FileUtil.getOrCreateNode((Integer)proNodeid, (String)foldName, (NodeService)nodeService);
            nodeId = cityNode.getId();
        }
        catch (Exception e) {
            System.out.println("\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return nodeId;
    }

    public static String getXmlFileName(String dir, String fileName) {
        String filename = "";
        File dirFile = new File(dir);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return null;
        }
        boolean flag = false;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile() || !StringUtils.equals((String)fileName, (String)(filename = files[i].getName()))) continue;
            flag = true;
            break;
        }
        if (!flag) {
            filename = "";
        }
        return filename;
    }

    public static String getXmlFileName(String dir) {
        String filename = "";
        File dirFile = new File(dir);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return null;
        }
        boolean flag = false;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            int point;
            String filetype;
            if (!files[i].isFile() || (filetype = (filename = files[i].getAbsolutePath()).substring(point = filename.lastIndexOf(".") + 1, filename.length())) == null || !filetype.equalsIgnoreCase("xml")) continue;
            flag = true;
            break;
        }
        if (!flag) {
            filename = "";
        }
        return filename;
    }

    public static String getEgovHomePath(String path) {
        String dirPath = "";
        try {
            dirPath = AppConfig.getConfHome((String[])new String[0]) + "/" + path + "/";
            if (dirPath.startsWith("zip")) {
                dirPath = dirPath.substring(4);
            } else if (dirPath.startsWith("file")) {
                dirPath = dirPath.substring(6);
            } else if (dirPath.startsWith("jar")) {
                dirPath = dirPath.substring(10);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dirPath;
    }

    public static String getTempPath(String type) {
        String path = System.getProperty("user.dir").replace("\\bin", "\\webapps") + "\\approval\\";
        path = path.replace("\\webapps\\approval\\", "\\temp\\");
        path = path + type + "\\";
        GregorianCalendar today = new GregorianCalendar();
        path = path + CalendarUtil.sdf_time.format(today.getTime()) + "\\";
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File f) throws IOException {
        if (f == null) {
            return null;
        }
        FileInputStream stream = null;
        ByteArrayOutputStream out = null;
        try {
            int n;
            stream = new FileInputStream(f);
            out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return null;
    }

    public static String getExtension(String filename, String defExt) {
        int i;
        if (filename != null && filename.length() > 0 && (i = filename.lastIndexOf(46)) > -1 && i < filename.length() - 1) {
            return filename.substring(i + 1);
        }
        return defExt;
    }
}

