/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.util;

import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfStuffConfig;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfStuffConfigService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.web.SessionUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.UrlResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommonUtils {
    public static Map urlMap;
    public static Map indexRightTopMenuMap;
    public static Map defaultWINameMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readJsonFile(String path) throws Exception {
        if (StringUtils.isNotBlank((String)path)) {
            File file = new File(path);
            if (path.startsWith("zip") || path.startsWith("file") || path.startsWith("jar")) {
                UrlResource resource = new UrlResource(path);
                file = resource.getFile();
            } else {
                file = new File(path);
            }
            if (file.exists()) {
                BufferedReader bufferedReader = null;
                StringBuffer config = new StringBuffer();
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    String tmp = null;
                    while ((tmp = bufferedReader.readLine()) != null) {
                        config.append(tmp);
                    }
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                if (StringUtils.isNotBlank((String)config.toString())) {
                    return JSON.parse((String)config.toString());
                }
            } else {
                System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + path);
            }
        }
        return null;
    }

    public static String getEgovhomeConfigFilePath(String project) throws Exception {
        String egovHomePath = AppConfig.getProperty((String)("config.reload." + project + ".path"));
        if (StringUtils.isNotBlank((String)(egovHomePath = RequestUtils.initOptProperties((String)egovHomePath)))) {
            return egovHomePath + "/" + project + "/application.properties";
        }
        String path = AppConfig.getProperty((String)"egov.conf");
        path = URLDecoder.decode(path, "UTF-8");
        String filePath = path = path.replace("file:/", "");
        filePath = StringUtils.equalsIgnoreCase((String)"egov", (String)project) ? filePath + "egov.properties" : (StringUtils.equalsIgnoreCase((String)"gis", (String)project) ? filePath + "gis.properties" : filePath + project + "/application.properties");
        filePath = RequestUtils.initOptProperties((String)filePath);
        return filePath;
    }

    public static File getEgovhomeConfigFile(String project) throws Exception {
        String filePath = CommonUtils.getEgovhomeConfigFilePath((String)project);
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    public static List<String> getEgovhomeConfigFileList() throws Exception {
        ArrayList<String> fileList = new ArrayList<String>();
        String path = AppConfig.getProperty((String)"egov.conf");
        path = URLDecoder.decode(path, "UTF-8");
        File dir = new File(path = path.replace("file:/", ""));
        if (dir.exists()) {
            dir.listFiles();
            if (dir.isDirectory()) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    String fileName = file.getName();
                    if (file.isDirectory()) {
                        if (!fileName.matches("^[A-Za-z]+$")) continue;
                        fileList.add(fileName);
                        continue;
                    }
                    String prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
                    if (!StringUtils.equalsIgnoreCase((String)prefix, (String)"properties") || !(fileName = StringUtils.split((String)fileName, (String)".")[0]).matches("^[A-Za-z]+$")) continue;
                    fileList.add(0, fileName);
                }
            }
        }
        int egovIndex = fileList.indexOf("egov");
        fileList.remove(egovIndex);
        fileList.add(0, "egov");
        return fileList;
    }

    public static void initWorkflowFileCenter(NodeService nodeService, PfStuffConfigService stuffConfigService, String workflowDefinitionId, int fileCenterNodeId) {
        List configList;
        List nodeChiles = nodeService.getChildNodes(Integer.valueOf(fileCenterNodeId));
        if ((nodeChiles == null || nodeChiles.size() <= 0) && (configList = stuffConfigService.getListByWfdId(workflowDefinitionId)) != null && configList.size() > 0) {
            LinkedHashMap<String, Ztree> stuffTreeMap = new LinkedHashMap<String, Ztree>();
            for (int i = 0; i < configList.size(); ++i) {
                PfStuffConfig configTmp = (PfStuffConfig)configList.get(i);
                PfStuffConfig stuff = new PfStuffConfig();
                stuff.setStuffId(configTmp.getStuffId());
                stuff.setProId(configTmp.getProId());
                stuff.setStuffName(configTmp.getStuffName());
                Ztree tree = CommonUtils.toZtree((PfStuffConfig)stuff);
                stuffTreeMap.put(tree.getId(), tree);
            }
            Ztree root = new Ztree();
            root.setId("treeroot");
            root.setName("\u6839\u8282\u70b9");
            root.setKz3(Integer.valueOf(fileCenterNodeId));
            for (Ztree tree : stuffTreeMap.values()) {
                if (tree.getPid() != null) {
                    Ztree ztree = (Ztree)stuffTreeMap.get(tree.getPid());
                    if (ztree != null) {
                        ztree.addChild(tree);
                        continue;
                    }
                    tree.setPid("treeroot");
                    root.addChild(tree);
                    continue;
                }
                tree.setPid("treeroot");
                root.addChild(tree);
            }
            if (root.getChildren() != null && root.getChildren().size() > 0) {
                for (int i = 0; i < root.getChildren().size(); ++i) {
                    CommonUtils.createFileTree((Ztree)root, (NodeService)nodeService);
                }
            }
        }
    }

    private static Ztree toZtree(PfStuffConfig stuff) {
        Ztree tree = new Ztree();
        tree.setId(stuff.getStuffId());
        tree.setName(stuff.getStuffName());
        if (stuff.getProId() == null) {
            tree.setPid("treeroot");
        } else {
            tree.setPid(StringUtils.trimToNull((String)stuff.getProId()));
        }
        return tree;
    }

    public static void createFileTree(Ztree parent, NodeService nodeService) {
        if (parent.getChildren() != null && parent.getChildren().size() > 0) {
            for (int i = 0; i < parent.getChildren().size(); ++i) {
                Ztree tree = (Ztree)parent.getChildren().get(i);
                Node stuffNode = nodeService.getNode(parent.getKz3(), tree.getName(), true);
                tree.setKz3(stuffNode.getId());
                CommonUtils.createFileTree((Ztree)tree, (NodeService)nodeService);
                parent.getChildren().set(i, tree);
            }
        }
    }

    public static boolean checkHasIndexVersion(String version) {
        if (StringUtils.isNotBlank((String)version)) {
            String path = CommonUtils.class.getResource("/").getPath();
            File file = new File((path = path.replace("classes", "views")) + "\\index\\zhsw\\" + version);
            if (file.exists()) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkHasTaskVersion(String version) {
        if (StringUtils.isNotBlank((String)version)) {
            String path = System.getProperty("user.dir");
            File file = new File((path = path.replace("\\bin", "\\webapps") + "\\portal") + "\\WEB-INF\\views\\" + version + "\\task\\");
            if (file.exists()) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkHasTaskCenterVersion(String version) {
        if (StringUtils.isNotBlank((String)version)) {
            String path = System.getProperty("user.dir");
            File file = new File((path = path.replace("\\bin", "\\webapps") + "\\portal") + "\\WEB-INF\\views\\task\\" + version);
            if (file.exists()) {
                return true;
            }
        }
        return false;
    }

    public static String freemarkerProcess(Map input, String templateStr) {
        if (StringUtils.isNotBlank((String)templateStr) && StringUtils.contains((String)templateStr, (String)"$")) {
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            String template = "content";
            stringLoader.putTemplate(template, templateStr);
            Configuration cfg = new Configuration();
            cfg.setTemplateLoader((TemplateLoader)stringLoader);
            try {
                Template templateCon = cfg.getTemplate(template);
                StringWriter writer = new StringWriter();
                templateCon.process((Object)input, (Writer)writer);
                return writer.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TemplateException e) {
                e.printStackTrace();
            }
        }
        return templateStr;
    }

    public static String initUrlParam(String urlParamStr, String url) {
        String[] param;
        String params = urlParamStr;
        if (StringUtils.contains((String)params, (String)"?")) {
            params = StringUtils.substringAfter((String)urlParamStr, (String)"?");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String keyvalue : param = params.split("&")) {
            String[] pair = keyvalue.split("=");
            if (pair.length != 2 || StringUtils.contains((String)pair[1], (String)"$")) continue;
            paramMap.put(pair[0], pair[1]);
        }
        return CommonUtils.freemarkerProcess(paramMap, (String)url);
    }

    public static String initCurUserUrlParam() {
        String curUserParam = "";
        try {
            if (AppConfig.getBooleanProperty((String)"portal.resource.url.addUsername", (boolean)false)) {
                String username = "";
                if (SessionUtil.getCurrentUser() != null) {
                    username = SessionUtil.getCurrentUser().getUsername();
                }
                curUserParam = curUserParam + "&username=" + username;
            }
            if (AppConfig.getBooleanProperty((String)"portal.resource.url.addRole", (boolean)false)) {
                String roleId = "";
                if (SessionUtil.getCurrentUser().getLstRole() != null && !SessionUtil.getCurrentUser().getLstRole().isEmpty()) {
                    roleId = ((PfRoleVo)SessionUtil.getCurrentUser().getLstRole().get(0)).getRoleId();
                }
                curUserParam = curUserParam + "&role=" + roleId;
                curUserParam = curUserParam + "&roles=" + SessionUtil.getCurrentUser().getRoleIds();
            }
            if (AppConfig.getBooleanProperty((String)"portal.resource.url.addXzqdm", (boolean)false)) {
                String xzqdm = "";
                if (SessionUtil.getCurrentUser().getLstOragn() != null && !SessionUtil.getCurrentUser().getLstOragn().isEmpty()) {
                    xzqdm = ((PfOrganVo)SessionUtil.getCurrentUser().getLstOragn().get(0)).getRegionCode();
                }
                curUserParam = curUserParam + "&xzqdm=" + xzqdm;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return curUserParam;
    }

    public static HashMap initCurUserUrlMap(PfUserService pfUserService) {
        HashMap<String, String> curUserParam = new HashMap<String, String>();
        try {
            if (SessionUtil.getCurrentUser() != null) {
                UserInfo userInfo = SessionUtil.getCurrentUser();
                PfUser pfUser = (PfUser)pfUserService.findById((Object)userInfo.getId());
                curUserParam.put("userid", pfUser.getUserId());
                curUserParam.put("username", pfUser.getUserName());
                curUserParam.put("loginname", pfUser.getLoginName());
                curUserParam.put("GT_USER_ID", pfUser.getUserId());
                curUserParam.put("GT_USER_NAME", pfUser.getUserName());
                curUserParam.put("GT_LOGIN_NAME", pfUser.getLoginName());
                if (userInfo.getLstRole() != null && !userInfo.getLstRole().isEmpty()) {
                    curUserParam.put("role", ((PfRoleVo)userInfo.getLstRole().get(0)).getRoleId());
                    curUserParam.put("roles", userInfo.getRoleIds());
                }
                if (userInfo.getLstOragn() != null && !userInfo.getLstOragn().isEmpty()) {
                    curUserParam.put("organ", ((PfOrganVo)userInfo.getLstOragn().get(0)).getOrganId());
                    curUserParam.put("xzqdm", ((PfOrganVo)userInfo.getLstOragn().get(0)).getRegionCode());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return curUserParam;
    }

    public static HashMap initCurUserUrlMap(List<String> activityRoleList, PfUserService pfUserService) {
        HashMap<String, String> curUserParam = new HashMap<String, String>();
        try {
            if (SessionUtil.getCurrentUser() != null) {
                UserInfo userInfo = SessionUtil.getCurrentUser();
                PfUser pfUser = (PfUser)pfUserService.findById((Object)userInfo.getId());
                curUserParam.put("userid", pfUser.getUserId());
                curUserParam.put("username", pfUser.getUserName());
                curUserParam.put("loginname", pfUser.getLoginName());
                curUserParam.put("GT_USER_ID", pfUser.getUserId());
                curUserParam.put("GT_USER_NAME", pfUser.getUserName());
                curUserParam.put("GT_LOGIN_NAME", pfUser.getLoginName());
                if (userInfo.getLstRole() != null && !userInfo.getLstRole().isEmpty()) {
                    List roles = SessionUtil.getCurrentUser().getLstRole();
                    String roleId = ((PfRoleVo)roles.get(0)).getRoleId();
                    if (activityRoleList != null && activityRoleList.size() > 0) {
                        for (PfRoleVo pfRoleVo : roles) {
                            if (!activityRoleList.contains(pfRoleVo.getRoleId())) continue;
                            roleId = pfRoleVo.getRoleId();
                            break;
                        }
                    }
                    curUserParam.put("role", roleId);
                    curUserParam.put("roles", userInfo.getRoleIds());
                }
                if (userInfo.getLstOragn() != null && !userInfo.getLstOragn().isEmpty()) {
                    curUserParam.put("organ", ((PfOrganVo)userInfo.getLstOragn().get(0)).getOrganId());
                    curUserParam.put("xzqdm", ((PfOrganVo)userInfo.getLstOragn().get(0)).getRegionCode());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return curUserParam;
    }

    public static String removeBlankLine(String str) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(str);
        return m.replaceAll("");
    }

    public static String getIntegerStr(String str) {
        String numberRegEx = "[^0-9]";
        Pattern pattern = Pattern.compile(numberRegEx);
        Matcher matcher = pattern.matcher(str);
        String result = matcher.replaceAll("");
        return result;
    }

    public static String getNumberStr(String str) {
        String numberRegEx = "([^(\\d|\\.)])";
        Pattern pattern = Pattern.compile(numberRegEx);
        Matcher matcher = pattern.matcher(str);
        String result = matcher.replaceAll("");
        return result;
    }

    public static String getMACAddress(String ip) throws SocketException, UnknownHostException {
        String macAddress = "";
        macAddress = CommonUtils.getMacInWindows((String)ip).trim();
        if (macAddress == null || "".equals(macAddress)) {
            macAddress = CommonUtils.getMacInLinux((String)ip).trim();
        }
        return macAddress;
    }

    public static String getMacInWindows(String ip) {
        String result = "";
        String[] cmd = new String[]{"cmd", "/c", "ping " + ip};
        String[] another = new String[]{"cmd", "/c", "arp -a"};
        String cmdResult = CommonUtils.callCmd((String[])cmd, (String[])another);
        result = CommonUtils.filterMacAddress((String)ip, (String)cmdResult, (String)"-");
        return result;
    }

    public static String getMacInLinux(String ip) {
        String result = "";
        String[] cmd = new String[]{"/bin/sh", "-c", "ping " + ip + " -c 2 && arp -a"};
        String cmdResult = CommonUtils.callCmd((String[])cmd);
        result = CommonUtils.filterMacAddress((String)ip, (String)cmdResult, (String)":");
        return result;
    }

    public static String callCmd(String[] cmd) {
        String result = "";
        String line = "";
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            InputStreamReader is = new InputStreamReader(proc.getInputStream());
            BufferedReader br = new BufferedReader(is);
            while ((line = br.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String callCmd(String[] cmd, String[] another) {
        String result = "";
        String line = "";
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            proc.waitFor();
            proc = rt.exec(another);
            InputStreamReader is = new InputStreamReader(proc.getInputStream());
            BufferedReader br = new BufferedReader(is);
            while ((line = br.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String filterMacAddress(String ip, String sourceString, String macSeparator) {
        String result = "";
        String regExp = "((([0-9,A-F,a-f]{1,2}" + macSeparator + "){1,5})[0-9,A-F,a-f]{1,2})";
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(sourceString);
        while (matcher.find()) {
            result = matcher.group(1);
            if (sourceString.indexOf(ip) > sourceString.lastIndexOf(matcher.group(1))) continue;
            break;
        }
        return result;
    }
}

