/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.server.impl;

import com.google.common.collect.Lists;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.server.PfWorkFlowEventConfigurationDao;
import com.gtis.portal.entity.PfWorkFlowEvent;
import com.gtis.portal.entity.QPfWorkFlowEvent;
import com.gtis.portal.service.server.PfWorkFlowEventConfigurationService;
import com.gtis.portal.util.QueryCondition;
import com.gtis.util.ThreadPool;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfWorkFlowEventConfigurationServiceImpl
implements PfWorkFlowEventConfigurationService {
    private static final Log log = LogFactory.getLog(PfWorkFlowEventConfigurationServiceImpl.class);
    @Resource(name="serverBaseDaoImpl")
    BaseDao baseDao;
    @Resource(name="baseDaoImpl")
    BaseDao pfBaseDao;
    @Resource
    PfWorkFlowEventConfigurationDao pfWorkFlowEventConfigurationDao;
    @Resource
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;

    public Page<PfWorkFlowEvent> listPfWorkFlowEventPage(String pfWorkFlowDefinitionId, String pfWorkFlowName, @PageableDefault(size=10) Pageable page) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank((String)pfWorkFlowName)) {
            expression = expression == null ? QPfWorkFlowEvent.pfWorkFlowEvent.workFlowName.like("%" + pfWorkFlowName + "%") : expression.and((Predicate)QPfWorkFlowEvent.pfWorkFlowEvent.workFlowName.like("%" + pfWorkFlowName + "%"));
        }
        return this.pfWorkFlowEventConfigurationDao.findAll(expression, page);
    }

    public List<PfWorkFlowEvent> listPfWorkFlowEvent(Map<String, Object> param) {
        if (MapUtils.isEmpty(param)) {
            return Lists.newArrayList();
        }
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            QueryCondition queryCondition = new QueryCondition(entry.getKey(), "=", entry.getValue());
            queryConditions.add(queryCondition);
        }
        if (StringUtils.equals((String)AppConfig.getProperty((String)"workflowEvent.order.enable"), (String)"true")) {
            String orderBy = " order by workflow_event_name,to_number(workflow_event_order)";
            return this.baseDao.get(PfWorkFlowEvent.class, queryConditions, orderBy);
        }
        return this.baseDao.get(PfWorkFlowEvent.class, queryConditions);
    }

    public void addPfWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        pfWorkFlowEvent.setId(UUIDGenerator.generate18());
        this.baseDao.save((Object)pfWorkFlowEvent);
    }

    public void savePfWorkFlowEventList(List<PfWorkFlowEvent> pfWorkFlowEventList) {
        if (CollectionUtils.isNotEmpty(pfWorkFlowEventList)) {
            for (PfWorkFlowEvent pfWorkFlowEvent : pfWorkFlowEventList) {
                this.addPfWorkFlowEvent(pfWorkFlowEvent);
            }
        }
    }

    public void updatePfWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        this.baseDao.update((Object)pfWorkFlowEvent);
    }

    public void deletePfWorkFlowEventById(String[] ids) {
        this.baseDao.delete(PfWorkFlowEvent.class, (Object[])ids);
    }

    public PfWorkFlowEvent getPfWorkFlowEvent(String id) {
        return (PfWorkFlowEvent)this.pfWorkFlowEventConfigurationDao.findOne((Serializable)((Object)id));
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> importPfWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        if (pfWorkFlowEvent == null || StringUtils.isBlank((String)pfWorkFlowEvent.getWorkFlowDefinitionId())) {
            result.put("result", "\u672a\u9009\u62e9\u6d41\u7a0b\u7c7b\u578b");
            return result;
        }
        String wfDefintionId = pfWorkFlowEvent.getWorkFlowDefinitionId();
        if (StringUtils.isNotBlank((String)wfDefintionId)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(wfDefintionId);
            String xmlEvent = this.sysWorkFlowDefineService.getWorkFlowDefineEventXml(pfWorkFlowDefineVo);
            List pfWorkFlowEventList = this.cratePfWorkFlowEventByXml(pfWorkFlowEvent, xmlEvent);
            if (CollectionUtils.isEmpty((Collection)pfWorkFlowEventList)) {
                result.put("result", "\u672a\u67e5\u627e\u5230\u914d\u7f6e\u6570\u636e\u6216\u89e3\u6790xml\u6587\u4ef6\u9519\u8bef");
            }
            this.savePfWorkFlowEventList(pfWorkFlowEventList);
            this.cleanPfWorkFlowDefinitionEvent(wfDefintionId);
        }
        return result;
    }

    public List<PfWorkFlowEvent> cratePfWorkFlowEventByXml(PfWorkFlowEvent pfWorkFlowEvent, String xml) {
        ArrayList<PfWorkFlowEvent> pfWorkFlowEventList = null;
        if (StringUtils.isNotBlank((String)xml)) {
            try {
                String eventName = pfWorkFlowEvent.getWorkFlowEventName();
                String wfDefintionId = pfWorkFlowEvent.getWorkFlowDefinitionId();
                Document doc = DocumentHelper.parseText((String)xml);
                String param = StringUtils.isNotBlank((String)eventName) ? "//Event[@name='" + eventName + "']" : "//Event";
                List eventNodes = doc.selectNodes(param);
                if (CollectionUtils.isNotEmpty((Collection)eventNodes)) {
                    pfWorkFlowEventList = new ArrayList<PfWorkFlowEvent>(eventNodes.size());
                    for (int i = 0; i < eventNodes.size(); ++i) {
                        Node eventNode = (Node)eventNodes.get(i);
                        String activityDefinitionId = eventNode.valueOf("@activityDefinitionId");
                        if (StringUtils.isNotBlank((String)pfWorkFlowEvent.getActivityDefinitionId()) && !StringUtils.equals((String)activityDefinitionId, (String)pfWorkFlowEvent.getActivityDefinitionId())) continue;
                        Element eleNode = (Element)eventNode;
                        String xmlEventName = eleNode.valueOf("@name");
                        List childsElement = eleNode.elements();
                        for (Element ele : childsElement) {
                            if (!ele.getName().equalsIgnoreCase("Url")) continue;
                            String url = ele.getTextTrim();
                            String asyn = "0";
                            if (StringUtils.isNotBlank((String)ele.valueOf("@asyn")) && ele.valueOf("@asyn").equalsIgnoreCase("true")) {
                                asyn = "1";
                            }
                            PfWorkFlowEvent workFlowEvent = new PfWorkFlowEvent();
                            workFlowEvent.setWorkFlowName(pfWorkFlowEvent.getWorkFlowName());
                            workFlowEvent.setWorkFlowDefinitionId(wfDefintionId);
                            workFlowEvent.setActivityDefinitionId(activityDefinitionId);
                            workFlowEvent.setWorkFlowEventName(xmlEventName);
                            workFlowEvent.setWorkFlowEventUrl(url);
                            workFlowEvent.setWorkFlowEventAsyn(asyn);
                            pfWorkFlowEventList.add(workFlowEvent);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return pfWorkFlowEventList;
    }

    public boolean doWfEvent(String wiid, String taskid, String userid, String eventName, String workFlowDefinitionId, String proid, String turnXml) throws Exception {
        String targetActivityId = "";
        log.info((Object)("-------------------------\u5de5\u4f5c\u6d41\u5b9e\u4f8bid:" + wiid));
        if (StringUtils.isNotBlank((String)turnXml)) {
            Document document = DocumentHelper.parseText((String)turnXml);
            Element root = document.getRootElement();
            Iterator iter = root.elementIterator();
            while (iter.hasNext()) {
                Element vals = (Element)iter.next();
                if (!"Activity".equals(vals.getName())) continue;
                targetActivityId = vals.attributeValue("Id");
            }
        }
        WorkFlowInfo infoObj = this.getInfoObj(taskid, userid, workFlowDefinitionId, proid, wiid);
        List pfWorkFlowEventList = null;
        if (StringUtils.isNotBlank((String)eventName)) {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(wiid);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("workFlowEventName", eventName);
            if (pfWorkFlowInstanceVo != null) {
                param.put("workFlowDefinitionId", pfWorkFlowInstanceVo.getWorkflowDefinitionId());
                pfWorkFlowEventList = this.listPfWorkFlowEvent(param);
            } else if (StringUtils.isNotBlank((String)workFlowDefinitionId)) {
                param.put("workFlowDefinitionId", workFlowDefinitionId);
                pfWorkFlowEventList = this.listPfWorkFlowEvent(param);
            } else {
                pfWorkFlowEventList = null;
            }
        }
        if (CollectionUtils.isNotEmpty(pfWorkFlowEventList)) {
            try {
                for (int i = 0; i < pfWorkFlowEventList.size(); ++i) {
                    PfWorkFlowEvent pfWorkFlowEvent = (PfWorkFlowEvent)pfWorkFlowEventList.get(i);
                    String activityDefinitionId = pfWorkFlowEvent.getActivityDefinitionId();
                    String targetActivityDefinitionId = pfWorkFlowEvent.getTargetActivityDefinitionId();
                    PfActivityVo activityVo = infoObj.getSourceActivity();
                    if (StringUtils.isNotBlank((String)targetActivityDefinitionId) && StringUtils.isNotBlank((String)targetActivityId) && targetActivityDefinitionId.equals(targetActivityId)) {
                        log.info((Object)("-------------------------\u4e8b\u4ef6\u540d\u79f0:" + eventName));
                        this.excuteCommand(infoObj, pfWorkFlowEvent);
                        continue;
                    }
                    if (activityVo != null && activityDefinitionId != null && !"".equals(activityDefinitionId.trim()) && !activityDefinitionId.equals(activityVo.getActivityDefinitionId()) || !StringUtils.isBlank((String)targetActivityDefinitionId)) continue;
                    log.info((Object)("-------------------------\u4e8b\u4ef6\u540d\u79f0:" + eventName));
                    this.excuteCommand(infoObj, pfWorkFlowEvent);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
        return true;
    }

    public WorkFlowInfo getInfoObj(String taskid, String userid, String workFlowDefinitionId, String proid, String wiid) {
        WorkFlowInfo info = new WorkFlowInfo();
        info.setUserId(userid);
        PfTaskVo pfTaskVo = this.sysTaskService.getTask(taskid);
        if (pfTaskVo == null) {
            pfTaskVo = this.sysTaskService.getHistoryTask(taskid);
        }
        if (pfTaskVo != null) {
            PfActivityVo pfActivityVo;
            info.setSourceTask(pfTaskVo);
            if (StringUtils.isNotBlank((String)pfTaskVo.getActivityId()) && (pfActivityVo = this.sysTaskService.getActivity(pfTaskVo.getActivityId())) != null) {
                info.setSourceActivity(pfActivityVo);
                if (StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    List targetActivityVoList;
                    PfWorkFlowInstanceVo pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null) {
                        info.setWorkFlowIntanceVo(pfWorkFlowInstanceVo);
                        if (StringUtils.isNotBlank((String)pfWorkFlowInstanceVo.getWorkflowDefinitionId())) {
                            PfWorkFlowDefineVo pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(pfWorkFlowInstanceVo.getWorkflowDefinitionId());
                            info.setWorkFlowDefineVo(pfWorkFlowDefineVo);
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(targetActivityVoList = this.sysTaskService.getWorkFlowInstanceActivityList(pfActivityVo.getWorkflowInstanceId())))) {
                        ArrayList<PfActivityVo> targetActivityList = new ArrayList<PfActivityVo>();
                        for (PfActivityVo activityVo : targetActivityVoList) {
                            if (activityVo.getActivityState() != 1) continue;
                            List targetTaskList = this.sysTaskService.getTaskListByActivity(activityVo.getActivityId());
                            targetActivityList.add(activityVo);
                            info.setTargetTasks(targetTaskList);
                        }
                        info.setTargetActivitys(targetActivityList);
                    }
                }
            }
        } else {
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(wiid);
            workFlowIntanceVo.setProId(proid);
            info.setWorkFlowIntanceVo(workFlowIntanceVo);
            PfWorkFlowDefineVo pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(workFlowDefinitionId);
            info.setWorkFlowDefineVo(pfWorkFlowDefineVo);
        }
        return info;
    }

    private void excuteCommand(WorkFlowInfo infoObj, PfWorkFlowEvent pfWorkFlowEvent) throws UnsupportedEncodingException, WorkFlowException {
        String proId = infoObj.getWorkFlowIntanceVo().getProId();
        Long startExcuteTime = null;
        Long endExcuteTime = null;
        if (StringUtils.isNotEmpty((String)pfWorkFlowEvent.getWorkFlowEventUrl())) {
            String url = AppConfig.getPlaceholderValue((String)pfWorkFlowEvent.getWorkFlowEventUrl());
            boolean asyn = false;
            if (StringUtils.isNotBlank((String)pfWorkFlowEvent.getWorkFlowEventAsyn()) && StringUtils.equals((String)pfWorkFlowEvent.getWorkFlowEventAsyn(), (String)"1")) {
                asyn = true;
            }
            String method = "get";
            if (StringUtils.isNotBlank((String)pfWorkFlowEvent.getWorkFlowEventMethod()) && StringUtils.equals((String)pfWorkFlowEvent.getWorkFlowEventMethod(), (String)"post")) {
                method = "post";
            }
            startExcuteTime = System.currentTimeMillis();
            log.info((Object)("-------------------------\u6267\u884c\u5f00\u59cb\u65f6\u95f4 " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss SSS").format(new Date(startExcuteTime))));
            String result = this.excuteUrl(url, proId, infoObj, asyn, method);
            endExcuteTime = System.currentTimeMillis();
            log.info((Object)("-------------------------\u6267\u884c\u7ed3\u675f\u65f6\u95f4 " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss SSS").format(new Date(endExcuteTime))));
            log.info((Object)("-------------------------\u6267\u884c\u65f6\u957f  " + (endExcuteTime - startExcuteTime) + "ms"));
            if (StringUtils.isNotBlank((String)result)) {
                throw new WorkFlowException(URLDecoder.decode(result, "UTF-8"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String excuteUrl(String urlString, boolean asyn, String method) throws IOException {
        String urlStr = urlString;
        if (asyn) {
            if (StringUtils.equals((String)"get", (String)method)) {
                ThreadPool.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                ThreadPool.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else if (StringUtils.equals((String)"get", (String)method)) {
            URL url = new URL(urlString);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpConnection = (HttpURLConnection)urlConnection;
            httpConnection.setConnectTimeout(50000);
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                InputStream urlStream = null;
                BufferedReader in = null;
                try {
                    String line;
                    urlStream = httpConnection.getInputStream();
                    in = new BufferedReader(new InputStreamReader(urlStream, "GBK"));
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        stringBuilder.append(line);
                    }
                    String string = stringBuilder.toString();
                    return string;
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (urlStream != null) {
                        urlStream.close();
                    }
                }
            }
            httpConnection.disconnect();
        } else {
            HttpClient httpClient = null;
            PostMethod postMethod = null;
            try {
                httpClient = new HttpClient();
                String[] arrurl = urlStr.split("\\?");
                postMethod = new PostMethod(arrurl[0]);
                String[] arrpara = arrurl[1].split("&");
                for (int i = 0; i < arrpara.length; ++i) {
                    String[] temp = arrpara[i].split("=");
                    postMethod.setParameter(temp[0], temp[1]);
                }
                httpClient.executeMethod((HttpMethod)postMethod);
                String string = postMethod.getResponseBodyAsString();
                return string;
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (postMethod != null) {
                    postMethod.releaseConnection();
                }
            }
        }
        return null;
    }

    private String excuteUrl(String urlStr, String proId, WorkFlowInfo infoObj, boolean asyn, String method) throws UnsupportedEncodingException {
        String[] urlStrs = urlStr.split("\\@!SEPARATOR!\\@");
        String workflowParaUrl = this.getWorkFlowInfoUrlFormat(infoObj);
        String platUrl = AppConfig.getProperty((String)"platform.url");
        for (String urlTemp : urlStrs) {
            if (!(urlTemp = urlTemp.trim()).startsWith("http://")) {
                urlTemp = "http://" + platUrl + urlTemp;
            }
            try {
                urlTemp = urlTemp.indexOf("?") > 0 ? urlTemp + "&proid=" + proId + "&" + workflowParaUrl : urlTemp + "?proid=" + proId + "&" + workflowParaUrl;
                if (infoObj.getSourceActivity() != null) {
                    urlTemp = urlTemp + "&adid=" + infoObj.getSourceActivity().getActivityId();
                }
                if (infoObj.getTargetActivitys() != null) {
                    StringBuilder targetActivityDefIds = new StringBuilder();
                    for (PfActivityVo pfActivityVo : infoObj.getTargetActivitys()) {
                        if (pfActivityVo == null) continue;
                        if (StringUtils.isNotBlank((String)targetActivityDefIds.toString())) {
                            targetActivityDefIds.append(",").append(pfActivityVo.getActivityDefinitionId());
                            continue;
                        }
                        targetActivityDefIds.append(pfActivityVo.getActivityDefinitionId());
                    }
                    if (StringUtils.isNotBlank((String)targetActivityDefIds.toString())) {
                        urlTemp = urlTemp + "&targetActivityDefids=" + targetActivityDefIds;
                    }
                }
                if (infoObj.getTargetTasks() != null && !infoObj.getTargetTasks().isEmpty()) {
                    ArrayList targetTaskList = new ArrayList();
                    urlTemp = urlTemp + "&targetTasksInfo=";
                }
                log.info((Object)("-------------------------\u6267\u884curlTemp:" + urlTemp));
                return this.excuteUrl(urlTemp, asyn, method);
            }
            catch (Exception e) {
                log.error((Object)("\u5de5\u4f5c\u6d41\u4e8b\u4ef6\u5b9a\u4e49url\u9519\u8bef,\u8bf7\u68c0\u67e5\uff01" + urlTemp + "\n===\u9519\u8bef\u4fe1\u606f===" + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    private String getWorkFlowInfoUrlFormat(WorkFlowInfo infoObj) throws UnsupportedEncodingException {
        List targetActivitys;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("userid=");
        stringBuilder.append(infoObj.getUserId());
        if (infoObj.getSourceActivity() != null) {
            stringBuilder.append("&activityid=");
            stringBuilder.append(infoObj.getSourceActivity().getActivityId());
        }
        if (infoObj.getSourceTask() != null) {
            stringBuilder.append("&taskid=");
            stringBuilder.append(infoObj.getSourceTask().getTaskId());
        }
        if ((targetActivitys = infoObj.getTargetActivitys()) != null) {
            int index;
            stringBuilder.append("&targetActivityIds=");
            for (index = 0; index < targetActivitys.size(); ++index) {
                if (index != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(((PfActivityVo)targetActivitys.get(index)).getActivityId());
            }
            stringBuilder.append("&targetActivityNames=");
            for (index = 0; index < targetActivitys.size(); ++index) {
                if (index != 0) {
                    stringBuilder.append(",");
                }
                if (!StringUtils.isNotBlank((String)((PfActivityVo)targetActivitys.get(index)).getActivityName())) continue;
                stringBuilder.append(URLEncoder.encode(((PfActivityVo)targetActivitys.get(index)).getActivityName(), "utf-8"));
            }
        }
        return stringBuilder.toString();
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> cleanWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        PfWorkFlowDefineVo pfWorkFlowDefineVo1;
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        List pfWorkFlowDefineVoList = null;
        if (pfWorkFlowEvent == null || StringUtils.isBlank((String)pfWorkFlowEvent.getWorkFlowDefinitionId())) {
            pfWorkFlowDefineVoList = this.sysWorkFlowDefineService.getWorkFlowDefineList();
        }
        if (pfWorkFlowEvent != null && StringUtils.isNotBlank((String)pfWorkFlowEvent.getWorkFlowDefinitionId()) && (pfWorkFlowDefineVo1 = this.sysWorkFlowDefineService.getWorkFlowDefine(pfWorkFlowEvent.getWorkFlowDefinitionId())) != null) {
            pfWorkFlowDefineVoList = Lists.newArrayList();
            pfWorkFlowDefineVoList.add(pfWorkFlowDefineVo1);
        }
        if (CollectionUtils.isNotEmpty((Collection)pfWorkFlowDefineVoList)) {
            for (PfWorkFlowDefineVo pfWorkFlowDefineVo : pfWorkFlowDefineVoList) {
                this.cleanPfWorkFlowDefinitionEvent(pfWorkFlowDefineVo.getWorkflowDefinitionId());
            }
        }
        return result;
    }

    public void cleanPfWorkFlowDefinitionEvent(String workflowDefinitionId) {
        String sql = "update PfWorkFlowDefinition as p set p.workflowDefinitionShell =?0 where p.workflowDefinitionId=?1";
        this.pfBaseDao.executeJpql(sql, new Object[]{"", workflowDefinitionId});
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> batchImportPfWorkFlowEvent() {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        List pfWorkFlowDefineVoList = this.sysWorkFlowDefineService.getWorkFlowDefineList();
        if (CollectionUtils.isNotEmpty((Collection)pfWorkFlowDefineVoList)) {
            for (PfWorkFlowDefineVo pfWorkFlowDefineVo : pfWorkFlowDefineVoList) {
                String xmlEvent = this.sysWorkFlowDefineService.getWorkFlowDefineEventXml(pfWorkFlowDefineVo);
                PfWorkFlowEvent pfWorkFlowEvent = new PfWorkFlowEvent();
                pfWorkFlowEvent.setWorkFlowDefinitionId(pfWorkFlowDefineVo.getWorkflowDefinitionId());
                pfWorkFlowEvent.setWorkFlowName(pfWorkFlowDefineVo.getWorkflowName());
                List pfWorkFlowEventList = this.cratePfWorkFlowEventByXml(pfWorkFlowEvent, xmlEvent);
                this.savePfWorkFlowEventList(pfWorkFlowEventList);
            }
        }
        return result;
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

