/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl.quartz;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SplitDataService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.MessageAcceptDao;
import com.gtis.portal.dao.MessageSendDao;
import com.gtis.portal.entity.PfLog;
import com.gtis.portal.entity.PfMessageAccept;
import com.gtis.portal.entity.PfMessageSend;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.entity.QPfMessageAccept;
import com.gtis.portal.entity.QPfMessageSend;
import com.gtis.portal.service.PfMessageService;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class AutoCheckTaskServcice {
    protected final Logger logger = Logger.getLogger(this.getClass());
    @Autowired
    SplitDataService splitDataService;
    @Autowired
    private MessageSendDao messageSendDao;
    @Autowired
    private PfMessageService pfMessageService;
    @Autowired
    private MessageAcceptDao messageAcceptDao;
    @Autowired
    private SysUserService sysUserService;
    @Resource(name="baseDaoImpl")
    BaseDao baseDao;

    @Scheduled(cron="${autoCheckTask.sendMessage.quartz.config}")
    public void autoSendMessage() {
        String autoCheckTaskSendMessageEnable = AppConfig.getProperty((String)"autoCheckTask.sendMessage.enable");
        Date checkTime = new Date();
        if (StringUtils.equals((CharSequence)autoCheckTaskSendMessageEnable, (CharSequence)"true")) {
            this.logger.info((Object)("\u81ea\u52a8\u68c0\u67e5\u5f85\u529e\u4efb\u52a1\u662f\u5426\u8d85\u671f\u4efb\u52a1\u5f00\u59cb" + CalendarUtil.formatDateTime((Date)checkTime)));
            String autoCheckTaskSendMessageCheckTimeRange = AppConfig.getProperty((String)"autoCheckTask.sendMessage.checkTime.timeRange");
            int checkTimeRange = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{autoCheckTaskSendMessageCheckTimeRange}) ? Integer.valueOf(autoCheckTaskSendMessageCheckTimeRange) : 6;
            HashMap mapParam = Maps.newHashMap();
            mapParam.put("userIds", null);
            int taskListSize = this.splitDataService.getCount("getTaskList", (Object)mapParam);
            com.gtis.common.Page taskListPage = this.splitDataService.query("getTaskList", (Object)mapParam, 0, taskListSize);
            if (taskListPage != null && taskListPage.getItems() != null) {
                List taskList = taskListPage.getItems();
                String slbh = "";
                for (HashMap taskMap : taskList) {
                    String[] slbhArr;
                    if (taskMap == null || !taskMap.containsKey("TASK_OVER_TIME") || taskMap.get("TASK_OVER_TIME") == null || !taskMap.containsKey("USER_ID") || taskMap.get("USER_ID") == null || !taskMap.containsKey("WORKFLOW_INSTANCE_ID") || taskMap.get("WORKFLOW_INSTANCE_ID") == null) continue;
                    String remark = "";
                    if (taskMap.containsKey("REMARK") && taskMap.get("REMARK") != null && (slbhArr = StringUtils.split((String)(remark = taskMap.get("REMARK").toString()), (String)"$")) != null && slbhArr.length > 0) {
                        slbh = slbhArr[0];
                    }
                    int hours = this.getHours(checkTime, (Date)taskMap.get("TASK_OVER_TIME"));
                    String userid = taskMap.get("USER_ID").toString();
                    Date overTime = (Date)taskMap.get("TASK_OVER_TIME");
                    if (hours > checkTimeRange) continue;
                    this.checkTaskHasSendMessage(slbh, userid, hours, overTime);
                }
                this.logger.info((Object)("\u81ea\u52a8\u68c0\u67e5\u5f85\u529e\u4efb\u52a1\u662f\u5426\u8d85\u671f\u4efb\u52a1\u7ed3\u675f" + CalendarUtil.formatDateTime((Date)new Date())));
            }
        }
    }

    private String sendMessage(int overPlusTime, String userId, String slbh, Date taskOverTime, String messagesendId, String messageacceptId, int messageacceptStatus, String userName) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)userId) && StringUtils.isNotBlank((CharSequence)slbh)) {
            HashMap<String, String> messagsendcontentMap = new HashMap<String, String>(4);
            try {
                messagsendcontentMap.put("\u5f85\u529e\u4efb\u52a1\u53d7\u7406\u7f16\u53f7", slbh);
                messagsendcontentMap.put("\u8282\u70b9\u529e\u7406\u4eba", userName);
                messagsendcontentMap.put("\u5f85\u529e\u4efb\u52a1\u622a\u6b62\u65e5\u671f", CalendarUtil.formatDateTime((Date)taskOverTime));
                PfUser pfUser = new PfUser();
                pfUser.setUserId("0");
                PfMessageSend pfMessageSend = new PfMessageSend();
                pfMessageSend.setMessagesendId(messagesendId);
                pfMessageSend.setMessagesendDate(new Date());
                if (overPlusTime > 0) {
                    pfMessageSend.setMessagesendTitle("\u5f85\u529e\u4efb\u52a1\u65f6\u9650\u5373\u5c06\u5230\u671f\u63d0\u9192");
                    messagsendcontentMap.put("\u5269\u4f59\u529e\u7406\u65f6\u957f", overPlusTime + "\u5c0f\u65f6");
                } else {
                    pfMessageSend.setMessagesendTitle("\u5f85\u529e\u4efb\u52a1\u65f6\u9650\u5df2\u8d85\u671f\u63d0\u9192");
                    messagsendcontentMap.put("\u8d85\u671f\u65f6\u957f", Math.abs(overPlusTime) + "\u5c0f\u65f6");
                }
                pfMessageSend.setMessagesendUser(pfUser);
                pfMessageSend.setMessagesendContent(JSON.toJSONString(messagsendcontentMap));
                if (StringUtils.isNotBlank((CharSequence)messagesendId) && messageacceptStatus == 0) {
                    pfMessageSend.setMessagesendId(messagesendId);
                    this.baseDao.update((Object)pfMessageSend);
                } else {
                    pfMessageSend.setMessagesendId(UUIDGenerator.generate18());
                    this.messageSendDao.saveAndFlush((Object)pfMessageSend);
                }
                if (StringUtils.isBlank((CharSequence)messageacceptId) || messageacceptStatus == 1) {
                    this.pfMessageService.addAcceptMessageByUser(userId, pfMessageSend);
                }
                this.savePfLogBySendMessage(pfMessageSend, "0");
                result = "success";
            }
            catch (Exception e) {
                result = "fail";
                this.logger.error((Object)(e.getMessage() + "_" + e.toString()), (Throwable)e);
            }
        }
        return result;
    }

    int getHours(Date checkTime, Date overTime) {
        int hours = 0;
        if (checkTime != null && overTime != null) {
            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            try {
                String checkTimes = simpleFormat.format(checkTime);
                String overTimes = simpleFormat.format(overTime);
                hours = (int)((simpleFormat.parse(overTimes).getTime() - simpleFormat.parse(checkTimes).getTime()) / 3600000L);
            }
            catch (ParseException e) {
                this.logger.info((Object)(e.getMessage() + "_" + e.toString()), (Throwable)e);
            }
        }
        return hours;
    }

    private void savePfLogBySendMessage(PfMessageSend pfMessageSend, String userId) {
        if (pfMessageSend != null) {
            PfLog pfLog = new PfLog();
            pfLog.setId(UUIDGenerator.generate18());
            pfLog.setUserId(userId);
            pfLog.setAction("\u6d88\u606f");
            pfLog.setContent(pfMessageSend.getMessagesendContent());
            pfLog.setIp(null);
            pfLog.setCreateTime(new Date());
            this.pfMessageService.addPfLog(pfLog);
        }
    }

    void checkTaskHasSendMessage(String slbh, String userId, int restTime, Date overTime) {
        String messagesendId = "";
        String messageacceptId = "";
        int messageacceptStatus = 0;
        String userName = "";
        if (StringUtils.isNotBlank((CharSequence)slbh) && StringUtils.isNotBlank((CharSequence)userId)) {
            PageRequest page;
            PfUserVo pfUserVo = this.sysUserService.getUserVo(userId);
            if (pfUserVo != null) {
                userName = pfUserVo.getUserName();
            }
            BooleanExpression expression = QPfMessageSend.pfMessageSend.messagesendUser.userId.eq((Object)"0");
            String messageTitle = restTime > 0 ? "\u5f85\u529e\u4efb\u52a1\u65f6\u9650\u5373\u5c06\u5230\u671f\u63d0\u9192" : "\u5f85\u529e\u4efb\u52a1\u65f6\u9650\u5df2\u8d85\u671f\u63d0\u9192";
            expression = expression == null ? QPfMessageSend.pfMessageSend.messagesendTitle.like("%" + messageTitle + "%") : expression.and((Predicate)QPfMessageSend.pfMessageSend.messagesendTitle.like("%" + messageTitle + "%"));
            expression = expression == null ? QPfMessageSend.pfMessageSend.messagesendContent.like("%" + slbh + "%") : expression.and((Predicate)QPfMessageSend.pfMessageSend.messagesendContent.like("%" + slbh + "%"));
            Page pfMessageSendPage = this.messageSendDao.findAll((Predicate)(expression = expression == null ? QPfMessageSend.pfMessageSend.messagesendContent.like("%" + userName + "%") : expression.and((Predicate)QPfMessageSend.pfMessageSend.messagesendContent.like("%" + userName + "%"))), (Pageable)(page = new PageRequest(0, 10, null)));
            if (pfMessageSendPage != null && pfMessageSendPage.getTotalPages() > 0 && CollectionUtils.isNotEmpty((Collection)pfMessageSendPage.getContent())) {
                for (PfMessageSend pfMessageSend : pfMessageSendPage.getContent()) {
                    PageRequest pageAccept;
                    BooleanExpression expressionAccept;
                    Page pfMessageAcceptPage;
                    Map messagesendcontentMap;
                    if (pfMessageSend == null || (messagesendcontentMap = (Map)JSON.parseObject((String)pfMessageSend.getMessagesendContent(), Map.class)) == null || !messagesendcontentMap.containsKey("\u8282\u70b9\u529e\u7406\u4eba") || !StringUtils.equals((CharSequence)userName, (CharSequence)messagesendcontentMap.get("\u8282\u70b9\u529e\u7406\u4eba").toString()) || (pfMessageAcceptPage = this.messageAcceptDao.findAll((Predicate)(expressionAccept = QPfMessageAccept.pfMessageAccept.messageSend.messagesendId.eq((Object)(messagesendId = pfMessageSend.getMessagesendId()))), (Pageable)(pageAccept = new PageRequest(0, 10, null)))) == null || pfMessageAcceptPage.getTotalPages() <= 0) continue;
                    messageacceptId = ((PfMessageAccept)pfMessageAcceptPage.getContent().get(0)).getMessageacceptId();
                    messageacceptStatus = ((PfMessageAccept)pfMessageAcceptPage.getContent().get(0)).getMessageacceptStatus();
                    if (messageacceptStatus != 0) continue;
                    break;
                }
            }
            this.sendMessage(restTime, userId, slbh, overTime, messagesendId, messageacceptId, messageacceptStatus, userName);
        }
    }
}

