/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.utils.DateUtils;
import com.google.common.collect.Maps;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.TaskBeforeTurnValidationService;
import com.gtis.web.SessionUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YesterdayTaskUnhandledValidationServiceImpl
implements TaskBeforeTurnValidationService {
    @Autowired
    private SysTaskService sysTaskService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;

    public boolean validateTask(String taskId, String userId) throws PortalException {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo;
        PfTaskVo pfTaskVo = this.sysTaskService.getTask(taskId);
        PfActivityVo pfActivityVo = null;
        if (pfTaskVo != null && StringUtils.isNotBlank((CharSequence)pfTaskVo.getActivityId()) && (pfActivityVo = this.sysTaskService.getActivity(pfTaskVo.getActivityId())) != null && StringUtils.isNotBlank((CharSequence)pfActivityVo.getWorkflowInstanceId()) && (StringUtils.equals((CharSequence)(pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId())).getPriority(), (CharSequence)"2") || StringUtils.equals((CharSequence)pfWorkFlowInstanceVo.getPriority(), (CharSequence)"3"))) {
            return true;
        }
        if (DateUtils.isSameDay((Date)Calendar.getInstance().getTime(), (Date)pfTaskVo.getBeginTime())) {
            HashMap param = Maps.newHashMap();
            param.put("userId", SessionUtil.getCurrentUserId());
            param.put("FINISH_TIME", DateUtils.formatTime((Date)DateUtils.addDays((Date)Calendar.getInstance().getTime(), (int)-1), (FastDateFormat)DateUtils.DATE_FORMAT));
            int taskCount = Integer.parseInt(this.sysWorkFlowInstanceService.getTaskCount(param));
            if (taskCount > 0) {
                throw new PortalException(ExceptionCode.YESTERDAY_TASK_UNHANDLED);
            }
        }
        return true;
    }
}

