/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.TaskAfterTurnGeneralService;
import com.gtis.portal.service.TaskBeforeTurnValidationService;
import com.gtis.portal.service.TaskGeneralService;
import com.gtis.portal.service.impl.TaskAfterTurnGeneralServiceContext;
import com.gtis.portal.service.impl.TaskBeforeTurnValidationServiceContext;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskGeneralServiceImpl
implements TaskGeneralService {
    @Autowired
    TaskBeforeTurnValidationServiceContext taskBeforeTurnValidationServiceContext;
    @Autowired
    TaskAfterTurnGeneralServiceContext taskAfterTurnGeneralServiceContext;

    public boolean turnBeforeTaskGeneralWork(String wiid, String taskid, String userid) throws PortalException {
        if (StringUtils.isNotBlank((String)taskid)) {
            String[] taskIds = StringUtils.split((String)taskid, (String)",");
            if (this.taskBeforeTurnValidationServiceContext != null && CollectionUtils.isNotEmpty((Collection)this.taskBeforeTurnValidationServiceContext.getTaskBeforeTurnValidationServices())) {
                for (String value : taskIds) {
                    for (TaskBeforeTurnValidationService taskBeforeTurnValidationService : this.taskBeforeTurnValidationServiceContext.getTaskBeforeTurnValidationServices()) {
                        if (taskBeforeTurnValidationService.validateTask(value, userid)) continue;
                        throw new PortalException(ExceptionCode.TASK_BEFORE_TURN_VALIDATION_ERROR);
                    }
                }
            }
            return true;
        }
        throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u8f6c\u53d1\u7684\u5f85\u529e\u4efb\u52a1\uff01");
    }

    public boolean turnAfterTaskGeneralWork(String wiid, String taskid, String userid) throws PortalException {
        if (this.taskAfterTurnGeneralServiceContext != null && CollectionUtils.isNotEmpty((Collection)this.taskAfterTurnGeneralServiceContext.getTaskAfterTurnGeneralServices())) {
            for (TaskAfterTurnGeneralService taskAfterTurnGeneralService : this.taskAfterTurnGeneralServiceContext.getTaskAfterTurnGeneralServices()) {
                String[] taskids;
                if (!StringUtils.isNotBlank((String)taskid)) continue;
                for (String id : taskids = taskid.split(",")) {
                    WorkFlowInfo info = taskAfterTurnGeneralService.getInfoObj(id, userid);
                    taskAfterTurnGeneralService.doWork(info);
                }
            }
        }
        return false;
    }
}

