/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.service.portal.TaskPerformerFilterService;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysDynamicSignService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.BDCGG;
import com.gtis.portal.entity.BdcXmSd;
import com.gtis.portal.entity.BdcZdpjjl;
import com.gtis.portal.service.PfTaskService;
import com.gtis.portal.service.TaskActionService;
import com.gtis.portal.service.impl.TaskPerformerFilterServiceContext;
import com.gtis.portal.service.server.AutoTurnTaskService;
import com.gtis.portal.service.server.impl.PfWorkFlowEventConfigurationServiceImpl;
import com.gtis.portal.util.QueryCondition;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.spring.Container;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskActionServiceImpl
implements TaskActionService {
    private static final Log log = LogFactory.getLog(PfWorkFlowEventConfigurationServiceImpl.class);
    public static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";
    public static final String ADMIN_USERID = "0";
    @Autowired
    SysUserService sysUserService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysDynamicSignService sysDynamicSignService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    TaskPerformerFilterServiceContext taskPerformerFilterServiceContext;
    @Resource(name="taskPerformerMinWorkloadFilterService")
    TaskPerformerFilterService taskPerformerFilterService;
    @Autowired
    PfTaskService pfTaskServiceImpl;
    @Resource(name="serverBaseDaoImpl")
    BaseDao baseDao;
    @Autowired
    AutoTurnTaskService autoTurnTaskService;

    public String delTask(String wiid, String taskid, String userid, String reason, String proid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String msg;
        block3: {
            msg = "";
            if (StringUtils.isBlank((String)wiid)) {
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            PfTaskVo taskVo = this.sysTaskService.getTask(taskid);
            try {
                this.delProject(wiid, userid, taskid);
                msg = "1";
            }
            catch (Exception e) {
                if (!StringUtils.isBlank((String)msg)) break block3;
                msg = "3";
            }
        }
        return msg;
    }

    public void retrieveTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        try {
            this.workFlowCoreService.retrieveWorkFlow(userid, taskid);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String delProject(String wiid, String userId, String taskid) {
        String msg = "";
        PfWorkFlowInstanceVo workFlowInstanceVo = this.workFlowIntanceService.getWorkflowInstance(wiid);
        try {
            PfWorkFlowInstanceVo intanceVo = this.workFlowIntanceService.getWorkflowInstance(wiid);
            Space space = this.nodeService.getWorkSpace(WORK_FLOW_STUFF);
            Node tempNode = this.nodeService.getNode(space.getId(), intanceVo.getProId());
            this.nodeService.remove(tempNode.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.sysDynamicSignService.deleteUserSignByProId(workFlowInstanceVo.getProId());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            boolean val = this.workFlowCoreService.deleteWorkFlowInstance(userId, wiid);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return msg;
    }

    public int permitDel(PfTaskVo taskVo, String userId) {
        if (StringUtils.equals((String)userId, (String)ADMIN_USERID) || taskVo == null) {
            return 0;
        }
        PfActivityVo activityVo = this.sysTaskService.getActivity(taskVo.getActivityId());
        PfWorkFlowInstanceVo workFlowInstanceVo = this.workFlowIntanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
        WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)workFlowInstanceVo);
        if (workXml.getBeginActivityDefine().equals(activityVo.getActivityDefinitionId())) {
            if (workFlowInstanceVo.getCreateUser().equals(userId)) {
                return 0;
            }
            if (userId.equals(taskVo.getUserVo().getUserId())) {
                return 0;
            }
            return 3;
        }
        return 2;
    }

    public List<BdcXmSd> getBdcxmsdListByCondition(String wiid) {
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        if (StringUtils.isNotBlank((String)wiid)) {
            QueryCondition queryCondition = new QueryCondition("xmid", "=", (Object)wiid);
            queryConditionList.add(queryCondition);
        }
        List list = this.baseDao.get(BdcXmSd.class, queryConditionList);
        return list;
    }

    public void saveXmSdTask(BdcXmSd bdcXmSd) {
        if (StringUtils.isBlank((String)bdcXmSd.getXmtdid())) {
            bdcXmSd.setXmtdid(UUIDGenerator.generate());
        }
        this.baseDao.save((Object)bdcXmSd);
    }

    public void turnTaskByXml(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String turnXml) {
        try {
            this.workFlowCoreService.turnTask(turnXml, taskid, userid);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void turnTaskByWorkFlowInfo(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String turnXml) {
        try {
            WorkFlowInfo info = this.workFlowCoreService.getWorkFlowTurnInfo(userid, taskid);
            List lstActivityModel = info.getTransInfo().getTranActivitys();
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
            ActivityModel activityModel = workXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
            String defaultSelectNextActivityName = activityModel.getDefaultSelectName();
            if (StringUtils.isNotBlank((String)defaultSelectNextActivityName)) {
                Iterator itModel = lstActivityModel.iterator();
                while (itModel.hasNext()) {
                    ActivityModel model = (ActivityModel)itModel.next();
                    if (defaultSelectNextActivityName.equalsIgnoreCase(model.getActivityDefineName())) continue;
                    itModel.remove();
                }
            }
            if (StringUtils.isBlank((String)activityModel.getSplitType()) || activityModel.getSplitType().equalsIgnoreCase("XOR")) {
                int i = 0;
                Iterator it = lstActivityModel.iterator();
                while (it.hasNext()) {
                    if (i > 0) {
                        it.remove();
                    }
                    it.next();
                    ++i;
                }
            }
            this.workFlowCoreService.postWorkFlow(userid, taskid, info);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void turnBackTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String adids, String remark) {
        try {
            if (StringUtils.isNotBlank((String)adids)) {
                String[] backDefineActivitys = adids.split(",");
                this.workFlowCoreService.postBackWorkFlow(userid, taskid, backDefineActivitys, remark);
            } else {
                WorkFlowInfo info = this.workFlowCoreService.getWorkFlowTurnBackInfo(userid, taskid);
                List backActivitys = info.getTargetActivitys();
                if (backActivitys != null && backActivitys.size() > 0) {
                    String[] backDefineActivitys = new String[]{((PfActivityVo)backActivitys.get(0)).getActivityDefinitionId()};
                    this.workFlowCoreService.postBackWorkFlow(userid, taskid, backDefineActivitys, remark);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void endTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String turnXml, WorkFlowInfo info) {
        try {
            if (info == null) {
                if (StringUtils.isBlank((String)turnXml) && StringUtils.indexOf((String)(turnXml = this.inputStream2String((InputStream)request.getInputStream())), (String)"Activitys") < 0) {
                    turnXml = turnXml + "<Activitys><ReMark><text/></ReMark></Activitys>";
                }
                this.workFlowCoreService.turnTask(turnXml, taskid, userid);
            } else {
                this.workFlowCoreService.postWorkFlow(userid, taskid, info);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stopTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
    }

    public void createTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
    }

    public void postTask(String wiid, String taskid, String userid, String remark, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        try {
            PfTaskVo taskVo = this.sysTaskService.getTask(taskid);
            PfActivityVo activityVo = this.sysTaskService.getActivity(taskVo.getActivityId());
            String decode = null;
            if (StringUtils.isNotBlank((String)remark)) {
                decode = URLDecoder.decode(remark, "utf-8");
            }
            this.workFlowCoreService.lockWorkFlowInstance(activityVo.getWorkflowInstanceId(), taskid, decode, userid);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void upPostTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        try {
            SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService;
            List relList;
            PfTaskVo taskVo = this.sysTaskService.getTask(taskid);
            PfActivityVo activityVo = this.sysTaskService.getActivity(taskVo.getActivityId());
            boolean hasFinishSub = true;
            PfWorkFlowInstanceVo instanceVo = this.workFlowIntanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)instanceVo);
            ActivityModel sourceActivityModel = workXml.getActivity(activityVo.getActivityDefinitionId());
            if (sourceActivityModel.getSubProcess() != null && (relList = (sysWorkFlowInstanceRelService = (SysWorkFlowInstanceRelService)Container.getBean((String)"SysWorkFlowInstanceServiceRelImpl")).getWorkFlowRelList(instanceVo.getWorkflowIntanceId())) != null && relList.size() > 0) {
                for (int i = 0; i < relList.size(); ++i) {
                    PfTaskVo subTaskVo;
                    if (((PfWorkFlowInstanceVo)relList.get(i)).getWorkflowState() == 2 || !((PfWorkFlowInstanceVo)relList.get(i)).getWorkflowDefinitionId().equals(sourceActivityModel.getSubProcess().getId()) || (subTaskVo = this.sysTaskService.getTaskAll(((PfWorkFlowInstanceVo)relList.get(i)).getWorkflowIntanceId())) == null || !StringUtils.isNotBlank((String)subTaskVo.getTaskId())) continue;
                    hasFinishSub = false;
                }
            }
            if (hasFinishSub) {
                this.workFlowCoreService.unLockWorkFlowInstance(activityVo.getWorkflowInstanceId());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void priorityTask(String wiid, String taskid, String userid, String priority, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        try {
            this.workFlowIntanceService.updateWorkFlowIntancePriority(wiid, priority);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Document parseTurnInfo(String xmlStr) throws Exception {
        Document doc = null;
        doc = DocumentHelper.parseText((String)xmlStr);
        return doc;
    }

    public void autoTurnTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String turnXml) {
        try {
            WorkFlowInfo info = this.workFlowCoreService.getWorkFlowTurnInfo(userid, taskid);
            List lstActivityModel = info.getTransInfo().getTranActivitys();
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
            ActivityModel activityModel = workXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
            String defaultSelectNextActivityName = activityModel.getDefaultSelectName();
            if (StringUtils.isNotBlank((String)defaultSelectNextActivityName)) {
                Iterator itModel = lstActivityModel.iterator();
                while (itModel.hasNext()) {
                    ActivityModel model = (ActivityModel)itModel.next();
                    if (defaultSelectNextActivityName.equalsIgnoreCase(model.getActivityDefineName())) continue;
                    itModel.remove();
                }
            }
            boolean isTaskBack = info.getSourceTask() != null ? info.getSourceTask().isBackState() : false;
            String autoTurnTaskEnable = AppConfig.getProperty((String)"autoTurnTask.enble");
            for (ActivityModel aModel : lstActivityModel) {
                List performerUsers = new ArrayList();
                String performerStrategy = aModel.getExtendedAttribute("FilterTransferPerformerStrategy");
                List targetTaskVoList = info.getTargetTasks();
                for (PerformerTaskModel userModel : aModel.getPerformerModelList()) {
                    if (isTaskBack && AppConfig.getBooleanProperty((String)"task.turnPerformer.useTurnBack", (boolean)false)) {
                        List bdcZdpjjlList = this.autoTurnTaskService.queryBdcZdpjjlList(info.getWorkFlowDefineVo().getWorkflowDefinitionId(), aModel.getDefineId(), "1");
                        List turnBackList = this.taskPerformerFilterServiceContext.getTaskPerformerFilterServiceByName("turnBack").getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
                        if (CollectionUtils.isNotEmpty((Collection)turnBackList) && CollectionUtils.isNotEmpty((Collection)bdcZdpjjlList)) {
                            for (int i = 0; i < turnBackList.size(); ++i) {
                                for (int j = 0; j < bdcZdpjjlList.size(); ++j) {
                                    if (!((PfUserVo)turnBackList.get(i)).getUserId().equals(((BdcZdpjjl)bdcZdpjjlList.get(j)).getYhid())) continue;
                                    performerUsers = this.taskPerformerFilterServiceContext.getTaskPerformerFilterServiceByName("turnBack").getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
                                }
                            }
                        }
                        if (CollectionUtils.isEmpty(performerUsers)) {
                            performerUsers = this.taskPerformerFilterService.getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
                        }
                    } else {
                        performerUsers = StringUtils.isNotBlank((String)performerStrategy) ? this.taskPerformerFilterServiceContext.getTaskPerformerFilterServiceByName(performerStrategy).getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId()) : (StringUtils.equals((String)autoTurnTaskEnable, (String)"true") ? this.taskPerformerFilterService.getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId()) : userModel.getUserList());
                    }
                    if (!CollectionUtils.isNotEmpty(performerUsers)) continue;
                    userModel.setUserList(performerUsers);
                }
            }
            this.workFlowCoreService.postWorkFlow(userid, taskid, info);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String inputStream2String(InputStream is) throws IOException {
        String result = "";
        try {
            result = IOUtils.toString((InputStream)is, (String)"UTF-8");
            result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + result;
        }
        catch (Exception exception) {
        }
        finally {
            is.close();
        }
        return result;
    }

    public void usedTask(String taskid, String userid) {
        if (StringUtils.isNotBlank((String)taskid)) {
            PfTaskVo pfTaskVoByTaskid = this.sysTaskService.getTask(taskid);
            List pfTaskVoList = null;
            if (pfTaskVoByTaskid != null && StringUtils.isNotBlank((String)pfTaskVoByTaskid.getActivityId())) {
                pfTaskVoList = this.sysTaskService.getTaskListByActivity(pfTaskVoByTaskid.getActivityId());
            }
            if (CollectionUtils.isNotEmpty(pfTaskVoList)) {
                for (PfTaskVo taskVo : pfTaskVoList) {
                    PfUserVo pfUserVo;
                    com.gtis.portal.entity.PfTaskVo pfTaskVoDb = this.pfTaskServiceImpl.queryPfTaskByTaskId(taskVo.getTaskId());
                    if (pfTaskVoDb != null && StringUtils.isNotBlank((String)pfTaskVoDb.getOptUserId()) && !StringUtils.equals((String)pfTaskVoDb.getOptUserId(), (String)userid) && pfTaskVoDb.getTaskStatus() == 1) {
                        throw new RuntimeException("\u8be5\u4efb\u52a1\u5df2\u7ecf\u88ab" + pfTaskVoDb.getOptUser() + "\u5360\u7528\uff01");
                    }
                    com.gtis.portal.entity.PfTaskVo pfTaskVo = new com.gtis.portal.entity.PfTaskVo();
                    pfTaskVo.setTaskStatus(Integer.valueOf(1));
                    pfTaskVo.setOptUserId(userid);
                    if (StringUtils.isNotBlank((String)userid) && (pfUserVo = this.sysUserService.getUserVo(userid)) != null) {
                        pfTaskVo.setOptUser(pfUserVo.getUserName());
                    }
                    pfTaskVo.setAssignmentId(taskVo.getTaskId());
                    this.pfTaskServiceImpl.updateTaskStatusInfo(pfTaskVo);
                }
            }
        }
    }

    public void noUsedTask(String taskid, String userid) {
        if (StringUtils.isNotBlank((String)taskid)) {
            PfTaskVo pfTaskVoByTaskid = this.sysTaskService.getTask(taskid);
            List pfTaskVoList = null;
            if (pfTaskVoByTaskid != null && StringUtils.isNotBlank((String)pfTaskVoByTaskid.getActivityId())) {
                pfTaskVoList = this.sysTaskService.getTaskListByActivity(pfTaskVoByTaskid.getActivityId());
            }
            if (CollectionUtils.isNotEmpty(pfTaskVoList)) {
                for (PfTaskVo taskVo : pfTaskVoList) {
                    com.gtis.portal.entity.PfTaskVo pfTaskVoDb = this.pfTaskServiceImpl.queryPfTaskByTaskId(taskVo.getTaskId());
                    if (pfTaskVoDb != null && StringUtils.isNotBlank((String)pfTaskVoDb.getOptUserId()) && StringUtils.equals((String)pfTaskVoDb.getOptUserId(), (String)userid) && pfTaskVoDb.getTaskStatus() == 1) {
                        PfUserVo pfUserVo;
                        com.gtis.portal.entity.PfTaskVo pfTaskVo = new com.gtis.portal.entity.PfTaskVo();
                        pfTaskVo.setTaskStatus(Integer.valueOf(0));
                        pfTaskVo.setOptUserId(userid);
                        if (StringUtils.isNotBlank((String)userid) && (pfUserVo = this.sysUserService.getUserVo(userid)) != null) {
                            pfTaskVo.setOptUser(pfUserVo.getUserName());
                        }
                        pfTaskVo.setAssignmentId(taskVo.getTaskId());
                        this.pfTaskServiceImpl.updateTaskStatusInfo(pfTaskVo);
                        continue;
                    }
                    if (pfTaskVoDb != null && pfTaskVoDb.getTaskStatus() == 1) {
                        throw new RuntimeException("\u8be5\u4efb\u52a1\u60a8\u4e0d\u5177\u5907\u53d6\u6d88\u5360\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb" + pfTaskVoDb.getOptUser() + "\u53d6\u6d88\u5360\u7528\uff01");
                    }
                    throw new RuntimeException("\u8be5\u4efb\u52a1\u672a\u88ab\u5360\u7528\uff01");
                }
            }
        }
    }

    public void saveBdcgg(BDCGG bdcgg) {
        this.baseDao.save((Object)bdcgg);
    }

    public void update(BDCGG bdcgg) {
        this.baseDao.update((Object)bdcgg);
    }

    public void remove(String id) {
        this.baseDao.delete(BdcXmSd.class, (Object)id);
    }

    public void update(BdcXmSd bdcXmSd) {
        this.baseDao.update((Object)bdcXmSd);
    }

    public List<BDCGG> getbdcggListByCondition(String wiid, String sffb) {
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        if (StringUtils.isNotBlank((String)wiid)) {
            QueryCondition queryCondition1 = new QueryCondition("wiid", "=", (Object)wiid);
            queryConditions.add(queryCondition1);
        }
        if (StringUtils.isNotBlank((String)sffb)) {
            QueryCondition queryCondition2 = new QueryCondition("sffb", "=", (Object)sffb);
            queryConditions.add(queryCondition2);
        }
        List list = this.baseDao.get(BDCGG.class, queryConditions);
        return list;
    }
}

