/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfWorkflowInstance;
import com.gtis.portal.entity.QPfWorkflowInstance;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.service.PfWorkflowInstanceService;
import com.gtis.portal.util.CommonUtils;
import com.gtis.portal.util.QueryCondition;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfWorkflowInstanceServiceImpl
implements PfWorkflowInstanceService {
    @Value(value="${egov.conf}/portal/workflow_default_name.json")
    private String location;
    @Resource(name="baseDaoImpl")
    BaseDao baseDao;
    @Autowired
    public SysWorkFlowInstanceRelService workFlowInstanceRelService;
    @Autowired
    private SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    private PfUserService userService;

    public PfWorkflowInstance findById(String proid) {
        if (StringUtils.isNotBlank((String)proid)) {
            return (PfWorkflowInstance)this.baseDao.getById(PfWorkflowInstance.class, (Object)proid);
        }
        return null;
    }

    public Page queryPageList(String proid, @PageableDefault(size=1) Pageable pageable) {
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QPfWorkflowInstance qPfWorkflowInstance = QPfWorkflowInstance.pfWorkflowInstance;
        Object expression = null;
        List wfList = this.workFlowInstanceRelService.getWorkFlowRelList(proid);
        if (wfList != null) {
            StringBuffer jhlxClause = new StringBuffer();
            jhlxClause.append(" workflowInstanceId in (");
            for (int i = 0; i < wfList.size(); ++i) {
                if (wfList.get(i) == null) continue;
                jhlxClause.append("'" + ((PfWorkFlowInstanceVo)wfList.get(i)).getWorkflowIntanceId() + "',");
            }
            jhlxClause.append("'')");
            queryConditions.add(new QueryCondition(jhlxClause.toString()));
        }
        return this.baseDao.get(PfWorkflowInstance.class, queryConditions, "order by createTime desc", pageable);
    }

    public void initWorkflowInstanceName(boolean reload) {
        try {
            if (reload) {
                CommonUtils.defaultWINameMap = null;
            }
            if (CommonUtils.defaultWINameMap == null || CommonUtils.defaultWINameMap.keySet().size() <= 0) {
                CommonUtils.defaultWINameMap = (Map)CommonUtils.readJsonFile((String)this.location);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getWorkflowInstanceDefaultName(String wdId) {
        try {
            Object obj;
            if (CommonUtils.defaultWINameMap != null && CommonUtils.defaultWINameMap.keySet().size() > 0 && (obj = CommonUtils.defaultWINameMap.get(wdId)) != null) {
                Map valueMap = (Map)obj;
                String wdname = MapUtils.getString((Map)valueMap, (Object)"wdname");
                PfWorkFlowDefineVo workFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(wdId);
                String workflowDefineName = workFlowDefineVo != null ? workFlowDefineVo.getWorkflowName() : "";
                wdname = StringUtils.isBlank((String)wdname) ? workflowDefineName : wdname;
                String custom = MapUtils.getString((Map)valueMap, (Object)"custom");
                String defaultName = MapUtils.getString((Map)valueMap, (Object)"defaultName");
                String split = MapUtils.getString((Map)valueMap, (Object)"split");
                if (StringUtils.isNotBlank((String)defaultName)) {
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("user", SessionUtil.getCurrentUser().getUsername());
                    m.put("date", CalendarUtil.getCurChinaYMDStrDate());
                    m.put("wdname", wdname);
                    m.put("organ", ((PfOrganVo)SessionUtil.getCurrentUser().getLstOragn().get(0)).getOrganName());
                    return CommonUtils.freemarkerProcess(m, (String)defaultName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public List<HashMap> getTaskList(HashMap param, Integer rownum) {
        try {
            String orderfield;
            String sql = "select t.* from ( ";
            String tasksql = " select t1.ASSIGNMENT_ID,t1.BEGIN_TIME,t1.OVER_TIME AS ACTIVITY_OVER_TIME,t3.OVER_TIME AS Workflow_OVER_TIME,t1.USER_ID,t2.ACTIVITY_NAME,t2.ACTIVITY_ID,t3.WORKFLOW_INSTANCE_NAME, t3.CREATE_TIME,t3.WORKFLOW_INSTANCE_ID,t3.WORKFLOW_DEFINITION_ID,t3.create_user,t2.TIME_LIMIT,t3.time_limit as WFD_TIME_LIMIT,t3.priority from PF_ASSIGNMENT t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3 where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id  and t2.ACTIVITY_STATE=1 and (t3.WORKFLOW_STATE=1 or t3.WORKFLOW_STATE=3) ";
            if (param != null) {
                if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank((String)MapUtils.getString((Map)param, (Object)"BEGIN_TIME"))) {
                    tasksql = tasksql + " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '" + MapUtils.getString((Map)param, (Object)"BEGIN_TIME") + "' ";
                }
                if (param.containsKey("userIds") && StringUtils.isNotBlank((String)MapUtils.getString((Map)param, (Object)"userIds"))) {
                    tasksql = tasksql + " and t1.USER_ID in (" + MapUtils.getString((Map)param, (Object)"userIds") + ")";
                }
            }
            tasksql = StringUtils.isNotBlank((String)(orderfield = MapUtils.getString((Map)param, (Object)"_orderfield_"))) ? tasksql + " order by " + orderfield : tasksql + " order by t1.begin_time desc ";
            sql = sql + tasksql + " ) t ";
            sql = rownum != null ? sql + "  where  rownum<= " + rownum : sql + "  where  rownum<= 12";
            List queryResults = this.baseDao.getMapBySql(sql, new Object[0]);
            return queryResults;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<HashMap> getTaskListByConfig(HashMap param) {
        try {
            String sql = "select        t.ASSIGNMENT_ID, t.BEGIN_TIME, t.OVER_TIME AS ACTIVITY_OVER_TIME,t.USER_ID,       t1.ACTIVITY_NAME, t1.ACTIVITY_ID,       t2.WORKFLOW_INSTANCE_NAME,t2.OVER_TIME AS Workflow_OVER_TIME, t2.CREATE_TIME,       t2.WORKFLOW_INSTANCE_ID, t2.WORKFLOW_DEFINITION_ID, t2.create_user,       t2.TIME_LIMIT, t2.time_limit as WFD_TIME_LIMIT  from pf_assignment          t,       pf_activity            t1,       pf_workflow_instance   t2,       pf_workflow_definition t3 where t.activity_id = t1.activity_id   and t1.activity_state = 1   and t1.workflow_instance_id = t2.workflow_instance_id   and (t2.workflow_state = 1 or t2.workflow_state = 3)   and t2.workflow_definition_id = t3.workflow_definition_id";
            if (param.containsKey("userIds") && StringUtils.isNotEmpty((String)MapUtils.getString((Map)param, (Object)"userIds"))) {
                sql = sql + " and t.user_id in (" + MapUtils.getString((Map)param, (Object)"userIds") + ")";
            }
            if (param.containsKey("BEGIN_TIME") && StringUtils.isNotEmpty((String)MapUtils.getString((Map)param, (Object)"BEGIN_TIME"))) {
                sql = sql + " and t.begin_time >=to_date('" + MapUtils.getString((Map)param, (Object)"BEGIN_TIME") + "','yyyy-mm-dd')";
            }
            if (param.containsKey("definitionIds") && StringUtils.isNotEmpty((String)MapUtils.getString((Map)param, (Object)"definitionIds"))) {
                sql = sql + " and t3.workflow_definition_id in (" + MapUtils.getString((Map)param, (Object)"definitionIds") + ")";
            } else if (param.containsKey("businessIds") && StringUtils.isNotEmpty((String)MapUtils.getString((Map)param, (Object)"businessIds"))) {
                sql = sql + " and t3.business_id in(" + MapUtils.getString((Map)param, (Object)"businessIds") + ")";
            }
            sql = sql + "and rownum<=8 order by t1.begin_time desc";
            List queryResults = this.baseDao.getMapBySql(sql, new Object[0]);
            return queryResults;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTaskListByConfigOfCount(HashMap param) {
        try {
            String sql = "select count(*) as TASKSIZE  from pf_assignment t,pf_activity t1, pf_workflow_instance   t2, pf_workflow_definition t3 where t.activity_id = t1.activity_id   and t1.activity_state = 1   and t1.workflow_instance_id = t2.workflow_instance_id   and (t2.workflow_state = 1 or t2.workflow_state = 3)   and t2.workflow_definition_id = t3.workflow_definition_id";
            if (param.containsKey("userIds") && StringUtils.isNotEmpty((String)MapUtils.getString((Map)param, (Object)"userIds"))) {
                sql = sql + " and t.user_id in (" + MapUtils.getString((Map)param, (Object)"userIds") + ")";
            }
            if (param.containsKey("BEGIN_TIME") && StringUtils.isNotEmpty((String)MapUtils.getString((Map)param, (Object)"BEGIN_TIME"))) {
                sql = sql + " and t.begin_time >=to_date('" + MapUtils.getString((Map)param, (Object)"BEGIN_TIME") + "','yyyy-mm-dd')";
            }
            if (param.containsKey("definitionIds") && StringUtils.isNotEmpty((String)MapUtils.getString((Map)param, (Object)"definitionIds"))) {
                sql = sql + " and t3.workflow_definition_id in (" + MapUtils.getString((Map)param, (Object)"definitionIds") + ")";
            } else if (param.containsKey("businessIds") && StringUtils.isNotEmpty((String)MapUtils.getString((Map)param, (Object)"businessIds"))) {
                sql = sql + " and t3.business_id in(" + MapUtils.getString((Map)param, (Object)"businessIds") + ")";
            }
            Object queryObject = this.baseDao.getMapObjBySql(sql, new Object[0]);
            if (queryObject != null) {
                return MapUtils.getString((Map)((HashMap)queryObject), (Object)"TASKSIZE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getTaskCount(HashMap param) {
        try {
            Object queryObject;
            String tasksql = " select count(*) as TASKSIZE from PF_ASSIGNMENT t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3 ,pf_user t6 where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id and t3.create_user=t6.user_id  and t2.ACTIVITY_STATE=1 and (t3.WORKFLOW_STATE=1 or t3.WORKFLOW_STATE=3) ";
            if (param != null) {
                if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank((String)MapUtils.getString((Map)param, (Object)"BEGIN_TIME"))) {
                    tasksql = tasksql + " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '" + MapUtils.getString((Map)param, (Object)"BEGIN_TIME") + "' ";
                }
                if (param.containsKey("userIds") && StringUtils.isNotBlank((String)MapUtils.getString((Map)param, (Object)"userIds"))) {
                    tasksql = tasksql + " and t1.USER_ID in (" + MapUtils.getString((Map)param, (Object)"userIds") + ")";
                }
            }
            if ((queryObject = this.baseDao.getMapObjBySql(tasksql, new Object[0])) != null) {
                return MapUtils.getString((Map)((HashMap)queryObject), (Object)"TASKSIZE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<HashMap> getProjectListByPerformer(String createTime, String userId, Integer rownum) {
        String agrs1 = "";
        if (StringUtils.isNotEmpty((String)createTime)) {
            agrs1 = agrs1 + " and to_char(t3.CREATE_TIME,'yyyy-MM-dd') >='" + createTime + "'";
        }
        String agrs2 = " ";
        if (StringUtils.isNotEmpty((String)userId)) {
            agrs2 = " and t2.user_id='" + userId + "'";
        }
        String sql = "select * from ( select * from (  select  t3.WORKFLOW_INSTANCE_ID,  t3.WORKFLOW_INSTANCE_NAME,  t3.WORKFLOW_DEFINITION_ID,  t3.CREATE_TIME,  t3.FINISH_TIME,  t3.OVER_TIME,  t4.WORKFLOW_NAME,  t4.business_id,  t3.TIME_LIMIT,  t3.PRIORITY,  t3.WORKFLOW_STATE,  t3.REMARK,  t3.MONITOR_ID,  t3.create_user,  t4.TIME_LIMIT as WFD_TIME_LIMIT,  t5.user_name CREATE_USERNAME,  t3.REGION_CODE  from  PF_WORKFLOW_INSTANCE t3,  PF_WORKFLOW_DEFINITION t4,  pf_user t5  where  t3.WORKFLOW_DEFINITION_ID=t4.WORKFLOW_DEFINITION_ID and  t3.create_user=t5.user_id " + agrs1 + " ) t " + " where t.workflow_instance_id in " + " ( " + " Select t1.workflow_instance_id from pf_activity t1, pf_assignmenthistory t2 " + " where t1.activity_id=t2.activity_id " + agrs2 + " ) order by t.CREATE_TIME desc ";
        sql = sql + " ) t ";
        sql = rownum != null ? sql + "  where  rownum<= " + rownum : sql + "  where  rownum<= 12";
        try {
            List queryResults = this.baseDao.getMapBySql(sql, new Object[0]);
            return queryResults;
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<HashMap> getTaskOverList(HashMap param, Integer rownum) {
        try {
            String sql = "select t.* from ( ";
            String tasksql = " select t1.ASSIGNMENT_ID,t1.BEGIN_TIME,t1.USER_ID,t2.ACTIVITY_NAME,t2.ACTIVITY_ID,t3.WORKFLOW_INSTANCE_NAME, t3.CREATE_TIME,t3.WORKFLOW_INSTANCE_ID,t3.WORKFLOW_DEFINITION_ID,t3.create_user,t3.priority from PF_ASSIGNMENTHISTORY t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3  where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id  and t1.isback=0 ";
            if (param != null) {
                if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank((String)MapUtils.getString((Map)param, (Object)"BEGIN_TIME"))) {
                    tasksql = tasksql + " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '" + MapUtils.getString((Map)param, (Object)"BEGIN_TIME") + "' ";
                }
                if (param.containsKey("userIds") && StringUtils.isNotBlank((String)MapUtils.getString((Map)param, (Object)"userIds"))) {
                    tasksql = tasksql + " and t1.USER_ID in (" + MapUtils.getString((Map)param, (Object)"userIds") + ")";
                }
            }
            tasksql = tasksql + " order by t1.finish_time desc ";
            sql = sql + tasksql + " ) t ";
            sql = rownum != null ? sql + "  where  rownum<= " + rownum : sql + "  where  rownum<= 12";
            List queryResults = this.baseDao.getMapBySql(sql, new Object[0]);
            return queryResults;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTaskOverCount(HashMap param) {
        try {
            String tasksql = " select count(*) as TASKSIZE from PF_ASSIGNMENTHISTORY t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3  where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id  and t1.isback=0 ";
            if (param != null) {
                if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank((String)MapUtils.getString((Map)param, (Object)"BEGIN_TIME"))) {
                    tasksql = tasksql + " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '" + MapUtils.getString((Map)param, (Object)"BEGIN_TIME") + "' ";
                }
                if (param.containsKey("userIds") && StringUtils.isNotBlank((String)MapUtils.getString((Map)param, (Object)"userIds"))) {
                    tasksql = tasksql + " and t1.USER_ID in (" + MapUtils.getString((Map)param, (Object)"userIds") + ")";
                }
            }
            Object queryObject = this.baseDao.getMapObjBySql(tasksql, new Object[0]);
            System.out.println(tasksql);
            if (queryObject != null) {
                return MapUtils.getString((Map)((HashMap)queryObject), (Object)"TASKSIZE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void update(PfWorkflowInstance obj) {
        if (obj != null) {
            this.baseDao.update((Object)obj);
        }
    }
}

