/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.portal.entity.PfAuthorize;
import com.gtis.portal.entity.PfSubsystem;
import com.gtis.portal.entity.PfSubsystemMenuRel;
import com.gtis.portal.entity.QPfSubsystem;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfAuthorizeService;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.PfSubsystemService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.util.CommonUtils;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.RequestUtils;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfSubsystemServiceImpl
extends BaseServiceImpl<PfSubsystem, String>
implements PfSubsystemService {
    @Autowired
    PfBusinessService businessService;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfMenuService menuService;
    @Autowired
    PfAuthorizeService authorizeService;
    @Autowired
    PfUserService pfUserService;

    public PfSubsystem findInitUrlById(String systemId) {
        PfSubsystem sub = (PfSubsystem)super.findById((Object)systemId);
        if (sub != null && StringUtils.isNotBlank((String)sub.getSubUrl())) {
            sub.setSubUrl(RequestUtils.initOptProperties((String)sub.getSubUrl()));
        }
        return sub;
    }

    public List<Ztree> getSubsystemTree() {
        List subList = this.getAllSubsystemList(false);
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        if (subList != null && subList.size() > 0) {
            for (int i = 0; i < subList.size(); ++i) {
                Ztree tree = this.toZtreeBySubsystem((PfSubsystem)subList.get(i));
                treeList.add(tree);
            }
        }
        return treeList;
    }

    public PfSubsystem getSubsystemByName(String name) {
        QPfSubsystem qPfSubsystem;
        JPAQuery query;
        List list;
        if (StringUtils.isNotBlank((String)name) && (list = ((JPQLQuery)((JPQLQuery)((JPQLQuery)(query = new JPAQuery(this.em)).from(new EntityPath[]{qPfSubsystem = QPfSubsystem.pfSubsystem})).where(new Predicate[]{qPfSubsystem.subsystemName.eq((Object)name)})).orderBy(new OrderSpecifier[]{qPfSubsystem.subNo.asc()})).list((Expression)qPfSubsystem)) != null && list.size() > 0) {
            if (StringUtils.isNotBlank((String)((PfSubsystem)list.get(0)).getSubUrl())) {
                ((PfSubsystem)list.get(0)).setSubUrl(RequestUtils.initOptProperties((String)((PfSubsystem)list.get(0)).getSubUrl()));
            }
            return (PfSubsystem)list.get(0);
        }
        return null;
    }

    @Transactional
    public void deleteSubAndRelById(String subId) {
        if (StringUtils.isNotBlank((String)subId)) {
            String jpql = "delete from PfSubsystemMenuRel t where t.subsystemId=?0";
            this.baseDao.executeJpql(jpql, new Object[]{subId});
            this.authorizeService.delAuthByObjIdAndType(subId, Constants.AuthorizeObjType.SUB.getBm());
            this.deleteById((Object)subId);
        }
    }

    public List<PfSubsystem> getAllSubsystemList(boolean enable) {
        QPfSubsystem qPfSubsystem = QPfSubsystem.pfSubsystem;
        JPAQuery query = new JPAQuery(this.em);
        if (enable) {
            return ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfSubsystem})).where(new Predicate[]{qPfSubsystem.enabled.eq(Boolean.valueOf(true))})).orderBy(new OrderSpecifier[]{qPfSubsystem.subNo.asc()})).list((Expression)qPfSubsystem);
        }
        return ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfSubsystem})).orderBy(new OrderSpecifier[]{qPfSubsystem.subNo.asc()})).list((Expression)qPfSubsystem);
    }

    public List<PfSubsystem> getSubsystemAuthorList(String userId) {
        if (!StringUtils.equals((String)userId, (String)"0")) {
            ArrayList<PfSubsystem> subList = new ArrayList<PfSubsystem>();
            String sql = "select distinct t.* from pf_subsystem t,pf_authorize t1,pf_user_role_rel t2  where t.subsystem_id=t1.authorize_obj_id and t1.authorize_obj_type=8 and t1.undertaker_id=t2.role_id  and t.enabled=1 and t1.menu_visible=1 and t2.user_id='" + userId + "' " + " order by t.sub_no ";
            List subMapList = this.baseDao.getMapBySql(sql, new Object[0]);
            if (subMapList != null) {
                HashMap userParam = CommonUtils.initCurUserUrlMap((PfUserService)this.pfUserService);
                for (int i = 0; i < subMapList.size(); ++i) {
                    PfSubsystem subsystem = this.toSubsystemByMap((HashMap)subMapList.get(i));
                    if (StringUtils.isNotBlank((String)subsystem.getSubUrl())) {
                        subsystem.setSubUrl(CommonUtils.freemarkerProcess((Map)userParam, (String)subsystem.getSubUrl()));
                    }
                    subList.add(subsystem);
                }
            }
            return subList;
        }
        return this.getAllSubsystemList(true);
    }

    private PfSubsystem toSubsystemByMap(HashMap map) {
        if (map != null && StringUtils.isNotBlank((String)MapUtils.getString((Map)map, (Object)"SUBSYSTEM_ID"))) {
            PfSubsystem sub = new PfSubsystem();
            sub.setSubsystemId(MapUtils.getString((Map)map, (Object)"SUBSYSTEM_ID"));
            sub.setSubsystemName(MapUtils.getString((Map)map, (Object)"SUBSYSTEM_NAME"));
            sub.setSubsystemTitle(MapUtils.getString((Map)map, (Object)"SUBSYSTEM_TITLE"));
            sub.setEnabled(Boolean.valueOf(true));
            sub.setSubType(MapUtils.getInteger((Map)map, (Object)"SUB_TYPE"));
            sub.setSubNo(Integer.valueOf(MapUtils.getIntValue((Map)map, (Object)"SUB_NO")));
            sub.setSubUrl(MapUtils.getString((Map)map, (Object)"SUB_URL"));
            sub.setSubMenuType(MapUtils.getString((Map)map, (Object)"SUB_MENU_TYPE"));
            return sub;
        }
        return null;
    }

    public Integer getMaxSubsystemId() {
        String sql = "select max(to_number(nvl(SUBSYSTEM_ID,0))) as SUBSYSTEM_ID from Pf_Subsystem";
        List mapList = this.baseDao.getMapBySql(sql, new Object[0]);
        if (mapList != null && mapList.size() > 0) {
            Integer max = MapUtils.getInteger((Map)((Map)mapList.get(0)), (Object)"SUBSYSTEM_ID");
            if (max == null) {
                max = 0;
            }
            Integer n = max;
            Integer n2 = max = Integer.valueOf(max + 1);
            return max;
        }
        return 1;
    }

    public PfSubsystemMenuRel getSubMenuRel(String menuId, String subId) {
        List relList = this.getSubMenuRelList(menuId, subId);
        if (relList != null && relList.size() > 0) {
            return (PfSubsystemMenuRel)relList.get(0);
        }
        return null;
    }

    public List<PfSubsystemMenuRel> getSubMenuRelList(String menuId, String subId) {
        return null;
    }

    @Transactional
    public void deleteSubMenuRel(String menuId, String subId) {
        if (!StringUtils.isNotBlank((String)menuId) || StringUtils.isNotBlank((String)subId)) {
            // empty if block
        }
    }

    @Transactional
    public void insertMenuRel(String menuId, String subId) {
        List relList = this.getSubMenuRelList(menuId, subId);
        if (relList == null || relList.size() < 1) {
            PfSubsystemMenuRel rel = new PfSubsystemMenuRel();
            rel.setMenuId(menuId);
            rel.setSubsystemId(subId);
            this.baseDao.save((Object)rel);
        }
    }

    @Transactional
    public void updateSubMenuRel(List<ZtreeChanged> changeList, String subId) {
        if (changeList != null && StringUtils.isNotBlank((String)subId)) {
            for (int i = 0; i < changeList.size(); ++i) {
                ZtreeChanged changed = changeList.get(i);
                if (changed.isChecked()) {
                    this.insertMenuRel(changed.getId(), subId);
                    continue;
                }
                this.deleteSubMenuRel(changed.getId(), subId);
            }
        }
    }

    @Transactional
    public void refreshMenuRel(String menuIds, String subId) {
        if (StringUtils.isNotBlank((String)menuIds) && StringUtils.isNotBlank((String)subId)) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            String[] idAry = StringUtils.split((String)menuIds, (String)",");
            for (int i = 0; i < idAry.length; ++i) {
                if (!StringUtils.isNotBlank((String)idAry[i])) continue;
                idMap.put(idAry[i], idAry[i]);
            }
        }
    }

    private Ztree toZtreeBySubsystem(PfSubsystem sub) {
        Ztree tree = new Ztree();
        tree.setId(sub.getSubsystemId());
        tree.setName(sub.getSubsystemTitle());
        tree.setNocheck(true);
        tree.setKz1(sub.getSubsystemName());
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/40x40icon05.png")));
        return tree;
    }

    @Transactional
    public void updateSubRoleRel(String subId, List<ZtreeChanged> changeList) {
        PfSubsystem subsystem;
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)subId) && (subsystem = (PfSubsystem)this.findById((Object)subId)) != null) {
            for (int i = 0; i < changeList.size(); ++i) {
                ZtreeChanged change = changeList.get(i);
                Integer visible = change.isChecked() ? 1 : 0;
                boolean hasRole = this.authorizeService.checkHasAuth(change.getId(), subsystem.getSubsystemId(), Constants.AuthorizeObjType.SUB.getBm());
                if (!hasRole) {
                    PfAuthorize authorize = new PfAuthorize();
                    authorize.setAuthorizeId(UUIDGenerator.generate18());
                    authorize.setAuthorizeObjType(Constants.AuthorizeObjType.SUB.getBm());
                    authorize.setUndertakerId(change.getId());
                    authorize.setAuthorizeObjId(subsystem.getSubsystemId());
                    authorize.setMenuVisible(visible);
                    this.authorizeService.insert((Object)authorize);
                    continue;
                }
                this.authorizeService.updateRoleMenuVisible(change.getId(), subsystem.getSubsystemId(), visible, Constants.AuthorizeObjType.SUB.getBm());
            }
        }
    }
}

