/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfDistrict;
import com.gtis.portal.entity.PfRole;
import com.gtis.portal.entity.QPfRole;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfDistrictService;
import com.gtis.portal.service.PfInstanceAuthorizeService;
import com.gtis.portal.service.PfRoleService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.service.impl.PfAuthorizeServiceImpl;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.RequestUtils;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfRoleServiceImpl
extends BaseServiceImpl<PfRole, String>
implements PfRoleService {
    @Autowired
    PfUserService userService;
    @Autowired
    PfAuthorizeServiceImpl authorizeService;
    @Autowired
    PfInstanceAuthorizeService instanceAuthorizeService;
    @Autowired
    PfDistrictService districtService;

    public Ztree getRoleRegionTree(String regionCode) {
        List roleList = this.getListByXzqdm(regionCode);
        return this.getRoleRegionTree(regionCode, roleList);
    }

    public Ztree getRoleRegionTree(String regionCode, List<PfRole> roleList) {
        Ztree otherNode;
        List districtList = this.districtService.getDistrictList(regionCode);
        LinkedHashMap<String, PfDistrict> districtVoMap = new LinkedHashMap<String, PfDistrict>();
        for (PfDistrict districtVo : districtList) {
            districtVoMap.put(districtVo.getDistrictId(), districtVo);
        }
        LinkedHashMap<String, Ztree> districtMap = new LinkedHashMap<String, Ztree>();
        for (PfDistrict districtVo : districtList) {
            Ztree tree = this.toZtreeByXzq(districtVo, districtVoMap);
            districtMap.put(tree.getId(), tree);
        }
        LinkedHashMap roleTreeMap = new LinkedHashMap();
        LinkedHashMap<String, ArrayList<Ztree>> otherRoleTreeMap = new LinkedHashMap<String, ArrayList<Ztree>>();
        if (roleList != null && !roleList.isEmpty()) {
            for (int i = 0; i < roleList.size(); ++i) {
                List<Ztree> tmpList;
                Ztree roleTree = this.toRegionZtreeByRole(roleList.get(i));
                String xzqdm = roleTree.getPid();
                if (districtMap.containsKey(xzqdm)) {
                    tmpList = null;
                    if (roleTreeMap.containsKey(xzqdm) && roleTreeMap.get(xzqdm) != null) {
                        tmpList = (List)roleTreeMap.get(xzqdm);
                        tmpList.add(roleTree);
                    } else {
                        tmpList = new ArrayList<Ztree>();
                        tmpList.add(roleTree);
                    }
                    roleTreeMap.put(xzqdm, tmpList);
                    if (!roleTreeMap.containsKey(xzqdm.substring(0, 4) + "00")) {
                        roleTreeMap.put(xzqdm.substring(0, 4) + "00", null);
                    }
                    if (!roleTreeMap.containsKey(xzqdm.substring(0, 2) + "0000")) {
                        roleTreeMap.put(xzqdm.substring(0, 2) + "0000", null);
                    }
                    if (StringUtils.length((String)xzqdm) <= 6 || roleTreeMap.containsKey(xzqdm.substring(0, 6))) continue;
                    roleTreeMap.put(xzqdm.substring(0, 6), null);
                    continue;
                }
                tmpList = (ArrayList<Ztree>)otherRoleTreeMap.get("other");
                if (tmpList == null) {
                    tmpList = new ArrayList();
                }
                tmpList.add(roleTree);
                otherRoleTreeMap.put("other", (ArrayList<Ztree>)tmpList);
            }
        }
        Iterator iterator = districtMap.keySet().iterator();
        while (iterator.hasNext()) {
            String xzqdm = (String)iterator.next();
            if (roleTreeMap.containsKey(xzqdm)) continue;
            iterator.remove();
        }
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        Ztree regionRoleNode = this.getRegionRoleTreeNode(districtMap, roleTreeMap);
        if (regionRoleNode != null) {
            treeList.add(regionRoleNode);
        }
        if ((otherNode = this.getOtherTreeNode(otherRoleTreeMap)) != null) {
            treeList.add(otherNode);
        }
        Ztree root = new Ztree();
        root.setName("\u5168\u5c40\u89d2\u8272");
        root.setId("treeroot");
        root.setNocheck(true);
        root.setNoR(true);
        root.setOpen(true);
        root.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder.gif")));
        if (regionRoleNode != null) {
            root.addChild(regionRoleNode);
        }
        if (otherNode != null) {
            root.addChild(otherNode);
        }
        return root;
    }

    private Ztree getRegionRoleTreeNode(LinkedHashMap<String, Ztree> districtMap, LinkedHashMap<String, List<Ztree>> roleTreeMap) {
        Ztree regionNode = null;
        for (Ztree tree : districtMap.values()) {
            List<Ztree> tmpList = roleTreeMap.get(tree.getKz1());
            if (tmpList != null && tmpList.size() > 0) {
                for (Ztree roleTree : tmpList) {
                    tree.addChild(roleTree);
                }
            }
            if (StringUtils.isBlank((String)tree.getPid())) {
                tree.setOpen(true);
                regionNode = tree;
                continue;
            }
            Ztree ztree = districtMap.get(tree.getPid());
            if (ztree == null) continue;
            ztree.addChild(tree);
        }
        return regionNode;
    }

    private Ztree getOtherTreeNode(LinkedHashMap<String, List<Ztree>> otherRoleTreeMap) {
        Ztree otherNode = null;
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo.isAdmin()) {
            otherNode = new Ztree();
            otherNode.setName("\u5176\u4ed6\u89d2\u8272");
            otherNode.setId("treeother");
            otherNode.setNocheck(true);
            otherNode.setNoR(true);
            otherNode.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder.gif")));
            List<Ztree> tmpList = otherRoleTreeMap.get("other");
            if (tmpList != null && tmpList.size() > 0) {
                for (Ztree roleTree : tmpList) {
                    otherNode.addChild(roleTree);
                }
            }
        }
        return otherNode;
    }

    private Ztree toZtreeByXzq(PfDistrict districtVo, LinkedHashMap<String, PfDistrict> districtVoMap) {
        Ztree tree = new Ztree();
        tree.setId(districtVo.getDistrictCode());
        tree.setName(districtVo.getDistrictName());
        PfDistrict parentDistrict = districtVoMap.get(districtVo.getDistrictParentId());
        if (parentDistrict != null) {
            tree.setPid(parentDistrict.getDistrictCode());
        }
        tree.setKz1(districtVo.getDistrictCode());
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder.gif")));
        tree.setGroup(true);
        return tree;
    }

    private Ztree toRegionZtreeByRole(PfRole role) {
        Ztree tree = new Ztree();
        tree.setId(role.getRoleId());
        tree.setName(role.getRoleName());
        tree.setKz1(role.getRegionCode());
        tree.setKz2(role.getRoleNo());
        tree.setPid(role.getRegionCode());
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/sup.png")));
        tree.setGroup(false);
        return tree;
    }

    public List<PfRole> getRoleByName(String roleName) {
        QPfRole qPfRole = QPfRole.pfRole;
        JPAQuery query = new JPAQuery(this.em);
        List pfRoleList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfRole})).where(new Predicate[]{qPfRole.roleName.eq((Object)roleName)})).list((Expression)qPfRole);
        return pfRoleList;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteById(String roleId) {
        if (StringUtils.isNotBlank((String)roleId)) {
            this.authorizeService.deleteAuthorizeListByRole(roleId);
            this.instanceAuthorizeService.deleteAuthorizeListByRole(roleId);
            String jpql = "delete from PfUserRoleRel t where t.roleId=?0";
            this.baseDao.executeJpql(jpql, new Object[]{roleId});
            super.deleteById((Object)roleId);
        }
    }

    public List<PfRole> getListByXzqdm(String xzqdm) {
        QPfRole qPfRole = QPfRole.pfRole;
        JPAQuery query = new JPAQuery(this.em);
        if (StringUtils.isNotBlank((String)xzqdm)) {
            return ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfRole})).where(new Predicate[]{qPfRole.regionCode.eq((Object)xzqdm)})).orderBy(new OrderSpecifier[]{qPfRole.roleNo.asc()})).list((Expression)qPfRole);
        }
        return ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfRole})).orderBy(new OrderSpecifier[]{qPfRole.roleNo.asc()})).list((Expression)qPfRole);
    }

    public List<Ztree> getTreeByXzqdm(String xzqdm) {
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        List roleList = this.getListByXzqdm(xzqdm);
        if (roleList != null && roleList.size() > 0) {
            for (int i = 0; i < roleList.size(); ++i) {
                treeList.add(this.toZtreeByRole((PfRole)roleList.get(i)));
            }
        }
        return treeList;
    }

    private Ztree toZtreeByRole(PfRole role) {
        Ztree tree = new Ztree();
        tree.setId(role.getRoleId());
        tree.setName(role.getRoleName());
        tree.setKz1(role.getRegionCode());
        tree.setKz2(role.getRoleNo());
        tree.setPid("treeroot");
        return tree;
    }

    public Ztree getRoleTreeBySubId(String subId, String regionCode) {
        List roleList = this.getRoleListBySubId(subId);
        return this.getRoleRegionTree(regionCode, roleList);
    }

    public List<PfRole> getRoleListBySubId(String subId) {
        List<Object> roleList = new ArrayList<PfRole>();
        if (StringUtils.isNotBlank((String)subId)) {
            String jpql = "select distinct t1 from PfRole t1,PfAuthorize t where t1.roleId=t.undertakerId and t.authorizeObjType=?0 and t.authorizeObjId=?1 and t.menuVisible>0";
            roleList = this.baseDao.getByJpql(jpql, new Object[]{Constants.AuthorizeObjType.SUB.getBm(), subId});
        }
        return roleList;
    }

    public List<ZtreeChanged> getRoleRelListBySubId(String subId) {
        List roleList = this.getRoleListBySubId(subId);
        ArrayList<ZtreeChanged> treeList = new ArrayList<ZtreeChanged>();
        if (roleList != null && roleList.size() > 0) {
            for (int i = 0; i < roleList.size(); ++i) {
                ZtreeChanged ztreeChanged = this.toZtreeChangedByRole((PfRole)roleList.get(i));
                treeList.add(ztreeChanged);
            }
        }
        return treeList;
    }

    private ZtreeChanged toZtreeChangedByRole(PfRole role) {
        ZtreeChanged tree = new ZtreeChanged();
        tree.setId(role.getRoleId());
        tree.setName(role.getRoleName());
        return tree;
    }

    private Ztree initCheckZtree(HashMap menuMap, Ztree ztree) {
        if (menuMap.containsKey(ztree.getId())) {
            ztree.setChecked(true);
        }
        this.checkZtree(menuMap, ztree.getChildren());
        return ztree;
    }

    private void checkZtree(HashMap menuMap, List<Ztree> list) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!menuMap.containsKey(list.get(i).getId())) continue;
                menuMap.remove(list.get(i).getId());
                list.get(i).setChecked(true);
                this.checkZtree(menuMap, list.get(i).getChildren());
            }
        }
    }

    public LinkedHashMap<String, PfRole> roleList2RoleMap(List<PfRole> roleList) {
        LinkedHashMap<String, PfRole> roleMap = new LinkedHashMap<String, PfRole>();
        if (roleList != null && roleList.size() > 0) {
            for (int i = 0; i < roleList.size(); ++i) {
                roleMap.put(roleList.get(i).getRoleId(), roleList.get(i));
            }
        }
        return roleMap;
    }
}

