/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfBusiness;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.entity.PfResourceGroup;
import com.gtis.portal.entity.QPfResource;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfAuthorizeService;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfInstanceAuthorizeService;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceGroupService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.util.RequestUtils;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfResourceServiceImpl
extends BaseServiceImpl<PfResource, String>
implements PfResourceService {
    @Resource(name="baseDaoImpl")
    BaseDao baseDao;
    @Autowired
    PfBusinessService businessService;
    @Autowired
    PfMenuService menuService;
    @Autowired
    PfResourceGroupService resourceGroupService;
    @Autowired
    PfAuthorizeService authorizeService;
    @Autowired
    PfInstanceAuthorizeService instanceAuthorizeService;

    public PfResource getResource(String resourceId) {
        return (PfResource)this.baseDao.getById(PfResource.class, (Object)resourceId);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateResource(PfResource resource) {
        this.baseDao.update((Object)resource);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void insertResource(PfResource resource) {
        this.baseDao.save((Object)resource);
    }

    public Ztree getAllResourceTree(String hascheck) {
        boolean nocheck = true;
        if (StringUtils.isNotBlank((String)hascheck) && StringUtils.equalsIgnoreCase((String)hascheck, (String)"true")) {
            nocheck = false;
        }
        ArrayList treeList = new ArrayList();
        LinkedHashMap<String, Ztree> treeMap = new LinkedHashMap<String, Ztree>();
        List businessList = this.businessService.getAll();
        if (businessList != null && businessList.size() > 0) {
            for (PfBusiness business : businessList) {
                Ztree tree = this.toZtreeByBusiness(business);
                treeMap.put(tree.getId(), tree);
            }
            List resourceGroupList = this.resourceGroupService.getAll();
            if (resourceGroupList != null && resourceGroupList.size() > 0) {
                for (PfResourceGroup resourceGroup : resourceGroupList) {
                    Ztree tree = this.toZtreeByResourceGroup(resourceGroup, nocheck);
                    treeMap.put(tree.getId(), tree);
                }
                List resourceList = this.getAll();
                if (resourceList != null && resourceList.size() > 0) {
                    for (PfResource resource : resourceList) {
                        Ztree tree = this.toZtreeByResource(resource);
                        treeMap.put(tree.getId(), tree);
                    }
                }
            }
        }
        Ztree root = new Ztree();
        Ztree firstNode = new Ztree();
        firstNode.setId("treeroot");
        firstNode.setName("\u7cfb\u7edf\u8d44\u6e90");
        firstNode.setNocheck(true);
        firstNode.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder_blank.png")));
        treeMap.put(firstNode.getId(), firstNode);
        for (Ztree tree : ((HashMap)treeMap).values()) {
            if (tree.getPid() != null) {
                Ztree ztree = (Ztree)((HashMap)treeMap).get(tree.getPid());
                if (ztree == null) continue;
                ztree.addChild(tree);
                continue;
            }
            tree.setOpen(true);
            root = tree;
        }
        return root;
    }

    private Ztree toZtreeByBusiness(PfBusiness business) {
        Ztree tree = new Ztree();
        tree.setId(business.getBusinessId());
        tree.setName(business.getBusinessName());
        tree.setPid("treeroot");
        tree.setNocheck(true);
        tree.setGroup(false);
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder_blank.png")));
        return tree;
    }

    private Ztree toZtreeByResourceGroup(PfResourceGroup resourceGroup, boolean nocheck) {
        Ztree tree = new Ztree();
        tree.setId(resourceGroup.getGroupId());
        tree.setName(resourceGroup.getGroupName());
        tree.setPid(resourceGroup.getBusinessId());
        tree.setNocheck(nocheck);
        tree.setGroup(true);
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder.gif")));
        return tree;
    }

    private Ztree toZtreeByResource(PfResource resource) {
        Ztree tree = new Ztree();
        tree.setId(resource.getResourceId());
        tree.setName(resource.getResourceName());
        if (StringUtils.isBlank((String)resource.getGroupId())) {
            tree.setPid(resource.getBusinessId());
        } else {
            tree.setPid(resource.getGroupId());
        }
        tree.setGroup(false);
        return tree;
    }

    public List<PfResource> getAll() {
        QPfResource qPfResource = QPfResource.pfResource;
        JPAQuery query = new JPAQuery(this.em);
        return ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfResource})).orderBy(new OrderSpecifier[]{qPfResource.resourceNo.asc()})).list((Expression)qPfResource);
    }

    public PfResource getResourceHasBs(String resouceId) {
        PfResource resource = (PfResource)this.findById((Object)resouceId);
        if (resource != null) {
            if (StringUtils.isNotBlank((String)resource.getBusinessId())) {
                PfBusiness business = this.businessService.findById(resource.getBusinessId());
                resource.setBusiness(business);
            }
            if (resource.getBusiness() == null) {
                resource.setBusiness(new PfBusiness());
            }
        }
        return resource;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteResourceByGroupId(String groupId) {
        List resourceList;
        if (StringUtils.isNotBlank((String)groupId) && (resourceList = this.getResourceListByGroupId(groupId)) != null && resourceList.size() > 0) {
            for (int i = 0; i < resourceList.size(); ++i) {
                this.deleteResource(((PfResource)resourceList.get(i)).getResourceId());
            }
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void clearResourceByGroupId(String groupId) {
        List resourceList;
        if (StringUtils.isNotBlank((String)groupId) && (resourceList = this.getResourceListByGroupId(groupId)) != null && resourceList.size() > 0) {
            for (int i = 0; i < resourceList.size(); ++i) {
                ((PfResource)resourceList.get(i)).setGroupId(null);
                this.update(resourceList.get(i));
            }
        }
    }

    public List<PfResource> getResourceListByGroupId(String groupId) {
        List resourceList = null;
        if (StringUtils.isNotBlank((String)groupId)) {
            QPfResource qPfResource = QPfResource.pfResource;
            JPAQuery query = new JPAQuery(this.em);
            resourceList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfResource})).where(new Predicate[]{qPfResource.groupId.eq((Object)groupId)})).orderBy(new OrderSpecifier[]{qPfResource.resourceNo.asc()})).list((Expression)qPfResource);
        }
        return resourceList;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteResource(String resourceId) {
        if (StringUtils.isNotBlank((String)resourceId)) {
            this.menuService.resetResouceRel(resourceId);
            this.authorizeService.deleteAuthorizeListByResource(resourceId);
            this.instanceAuthorizeService.deleteAuthorizeListByResource(resourceId);
            this.deleteById((Object)resourceId);
        }
    }
}

