/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.portal.entity.PfBusiness;
import com.gtis.portal.entity.PfResourceGroup;
import com.gtis.portal.entity.QPfResourceGroup;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfResourceGroupService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfResourceGroupServiceImpl
extends BaseServiceImpl<PfResourceGroup, String>
implements PfResourceGroupService {
    @Autowired
    PfBusinessService businessService;
    @Autowired
    PfResourceService resourceService;

    public PfResourceGroup getGroupHasBs(String groupId) {
        PfResourceGroup group = (PfResourceGroup)this.findById((Object)groupId);
        if (group != null) {
            if (StringUtils.isNotBlank((String)group.getBusinessId())) {
                PfBusiness business = this.businessService.findById(group.getBusinessId());
                group.setBusiness(business);
            }
            if (group.getBusiness() == null) {
                group.setBusiness(new PfBusiness());
            }
        }
        return group;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteGroup(String groupId, boolean delResource) {
        if (StringUtils.isNotBlank((String)groupId)) {
            if (delResource) {
                this.resourceService.deleteResourceByGroupId(groupId);
            } else {
                this.resourceService.clearResourceByGroupId(groupId);
            }
            this.deleteById((Object)groupId);
        }
    }

    public List<PfResourceGroup> getAll() {
        QPfResourceGroup qPfResourceGroup = QPfResourceGroup.pfResourceGroup;
        JPAQuery query = new JPAQuery(this.em);
        return ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfResourceGroup})).orderBy(new OrderSpecifier[]{qPfResourceGroup.groupName.asc()})).list((Expression)qPfResourceGroup);
    }
}

