/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.portal.entity.PfOrgan;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.entity.QPfOrgan;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfOrganService;
import com.gtis.portal.service.PfUserOrganService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.util.RequestUtils;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfOrganServiceImpl
extends BaseServiceImpl<PfOrgan, String>
implements PfOrganService {
    @Autowired
    PfUserService userService;
    @Autowired
    private PfUserOrganService userOrganService;

    @Transactional
    public void deleteById(String organId) {
        if (StringUtils.isNotBlank((String)organId)) {
            String jpql = "delete from PfUserOrganRel t where t.organId=?0";
            this.baseDao.executeJpql(jpql, new Object[]{organId});
            super.deleteById((Object)organId);
        }
    }

    @Transactional
    public void deleteOrganAndUserById(String organId) {
        List organIdList = this.findAllOrgan(organId);
        for (String tmpId : organIdList) {
            List organ_userList = this.getUserListByid(tmpId);
            for (PfUser user : organ_userList) {
                this.userService.deleteById(user.getUserId());
            }
            this.deleteById(tmpId);
        }
    }

    public List<PfOrgan> getOrganList(String regionCode) {
        List organList = new ArrayList();
        QPfOrgan qPforgan = QPfOrgan.pfOrgan;
        JPAQuery query = new JPAQuery(this.em);
        if (StringUtils.isNotBlank((String)regionCode)) {
            String xzqdm = regionCode;
            if (StringUtils.length((String)regionCode) == 6) {
                xzqdm = StringUtils.removeEnd((String)regionCode, (String)"0000");
                xzqdm = StringUtils.removeEnd((String)regionCode, (String)"00");
            }
            organList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPforgan})).where(new Predicate[]{qPforgan.regionCode.like(xzqdm + "%")})).orderBy(new OrderSpecifier[]{qPforgan.regionCode.asc()})).orderBy(new OrderSpecifier[]{qPforgan.organNo.asc()})).list((Expression)qPforgan);
        } else {
            organList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPforgan})).orderBy(new OrderSpecifier[]{qPforgan.regionCode.asc()})).orderBy(new OrderSpecifier[]{qPforgan.organNo.asc()})).list((Expression)qPforgan);
        }
        return organList;
    }

    public Ztree getAllOrganTree(String regionCode) {
        List organList = this.getOrganList(regionCode);
        return this.getOrganTreeByOrganList(organList);
    }

    public Ztree getOrganTreeByUserId(String userId) {
        List organList = this.userOrganService.getOrganListByUserId(userId);
        return this.getOrganTreeByOrganList(organList);
    }

    public Ztree getOrganTreeByOrganList(List<PfOrgan> organList) {
        if (organList != null && organList.size() > 0) {
            LinkedHashMap<String, Ztree> organMap = new LinkedHashMap<String, Ztree>();
            Ztree root = null;
            Ztree firstNode = new Ztree();
            firstNode.setId("treeroot");
            firstNode.setName("\u90e8\u95e8\u7528\u6237");
            firstNode.setNocheck(true);
            firstNode.setKz1("");
            organMap.put(firstNode.getId(), firstNode);
            for (PfOrgan organVo : organList) {
                Ztree tree = this.toZtree(organVo);
                organMap.put(tree.getId(), tree);
            }
            for (Ztree tree : organMap.values()) {
                if (tree.getPid() != null) {
                    Ztree ztree = (Ztree)organMap.get(tree.getPid());
                    ztree = (Ztree)organMap.get(tree.getPid());
                    if (ztree != null) {
                        ztree.addChild(tree);
                        continue;
                    }
                    tree.setPid(firstNode.getId());
                    root.addChild(tree);
                    continue;
                }
                tree.setOpen(true);
                root = tree;
            }
            return root;
        }
        return null;
    }

    private Ztree toZtree(PfOrgan organVo) {
        Ztree tree = new Ztree();
        tree.setId(organVo.getOrganId());
        tree.setName(organVo.getOrganName());
        if (organVo.getSuperOrganId() == null) {
            tree.setPid("treeroot");
        } else {
            tree.setPid(StringUtils.trimToNull((String)organVo.getSuperOrganId()));
        }
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder.gif")));
        tree.setKz1(organVo.getRegionCode());
        return tree;
    }

    private Ztree toUserZtree(PfUser user) {
        Ztree tree = new Ztree();
        tree.setId(user.getUserId());
        tree.setName(user.getUserName());
        tree.setPid(user.getOrganId());
        tree.setKz1("userId");
        return tree;
    }

    public Ztree getorganUserTree(String organId, String regionCode) {
        Ztree ztree = this.getAllOrganTree(regionCode);
        HashMap<String, Boolean> userMap = new HashMap<String, Boolean>();
        List userList = this.getUserListByid(organId);
        if (userList != null && userList.size() > 0) {
            for (int i = 0; i < userList.size(); ++i) {
                userMap.put(((PfUser)userList.get(i)).getOrganId(), true);
            }
        }
        return this.initCheckZtree(userMap, ztree);
    }

    private Ztree initCheckZtree(HashMap userMap, Ztree ztree) {
        if (userMap.containsKey(ztree.getId())) {
            ztree.setChecked(true);
        }
        this.checkZtree(userMap, ztree.getChildren());
        return ztree;
    }

    private void checkZtree(HashMap userMap, List<Ztree> list) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!userMap.containsKey(list.get(i).getId())) continue;
                userMap.remove(list.get(i).getId());
                list.get(i).setChecked(true);
                this.checkZtree(userMap, list.get(i).getChildren());
            }
        }
    }

    public List<PfUser> getUserListByid(String oragen_id) {
        ArrayList<PfUser> userList = new ArrayList<PfUser>();
        List userMapList = new ArrayList();
        String sql = "select t.user_id,t.user_name,tr.ORGAN_ID from pf_user t,pf_user_organ_rel tr where t.user_id=tr.user_id   and tr.organ_id='" + oragen_id + "'" + " order by t.user_no";
        userMapList = this.baseDao.getMapBySql(sql, new Object[0]);
        for (HashMap hashMap : userMapList) {
            String userid = (String)hashMap.get("USER_ID");
            String user_name = (String)hashMap.get("USER_NAME");
            String organ_id = (String)hashMap.get("ORGAN_ID");
            PfUser user = new PfUser();
            user.setUserId(userid);
            user.setUserName(user_name);
            user.setOrganId(organ_id);
            userList.add(user);
        }
        return userList;
    }

    public List<String> findAllOrgan(String organId) {
        ArrayList<String> organIdList = new ArrayList<String>();
        String sql = "select  ORGAN_ID from pf_organ m start with m.organ_id='" + organId + "'connect by  m.super_organ_id= prior m.organ_id ";
        List organidMapList = this.baseDao.getMapBySql(sql, new Object[0]);
        for (HashMap tmp : organidMapList) {
            String userid = (String)tmp.get("ORGAN_ID");
            organIdList.add(userid);
        }
        return organIdList;
    }

    public Ztree getOtherTree(int mark) {
        Ztree otherNode = new Ztree();
        otherNode.setId("treeother");
        otherNode.setName("\u5176\u4ed6\u90e8\u95e8");
        otherNode.setNocheck(true);
        otherNode.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder.gif")));
        if (mark == 1) {
            return otherNode;
        }
        if (mark == 2) {
            ArrayList<Ztree> children = new ArrayList<Ztree>();
            List userList = this.findOtherUser();
            for (PfUser user : userList) {
                Ztree treetmp = this.toUserZtree(user);
                children.add(treetmp);
            }
            otherNode.setChildren(children);
        }
        return otherNode;
    }

    public List<PfUser> findOtherUser() {
        ArrayList<PfUser> userList = new ArrayList<PfUser>();
        String sql = "select A.user_id,A.user_name from  pf_user A  where  NOT EXISTS ( SELECT B.USER_ID FROM  pf_user_organ_rel B  where A.user_id=B.user_id)";
        List otherMapList = this.baseDao.getMapBySql(sql, new Object[0]);
        for (HashMap tmp : otherMapList) {
            String userid = (String)tmp.get("USER_ID");
            String user_name = (String)tmp.get("USER_NAME");
            PfUser user = new PfUser();
            user.setUserId(userid);
            user.setUserName(user_name);
            userList.add(user);
        }
        return userList;
    }

    private List<PfUser> findUser() {
        ArrayList<PfUser> userList = new ArrayList<PfUser>();
        String sql = " select B.ORGAN_ID, A.USER_ID, A.USER_NAME from pf_user A, pf_user_organ_rel B where  A.USER_ID=B.USER_ID ";
        List otherMapList = this.baseDao.getMapBySql(sql, new Object[0]);
        for (HashMap tmp : otherMapList) {
            String userid = (String)tmp.get("USER_ID");
            String user_name = (String)tmp.get("USER_NAME");
            String organ_id = (String)tmp.get("ORGAN_ID");
            PfUser user = new PfUser();
            user.setUserId(userid);
            user.setUserName(user_name);
            user.setOrganId(organ_id);
            userList.add(user);
        }
        return userList;
    }

    public Ztree getAllOrganUserTree(String regionCode) {
        List organList = this.getOrganList(regionCode);
        LinkedHashMap<String, Ztree> organMap = new LinkedHashMap<String, Ztree>();
        Ztree root = null;
        Ztree firstNode = new Ztree();
        firstNode.setId("treeroot");
        firstNode.setName("\u90e8\u95e8\u7528\u6237");
        firstNode.setNocheck(true);
        firstNode.setKz1("");
        for (PfOrgan organVo : organList) {
            Ztree tree = this.toZtree(organVo);
            tree.setGroup(true);
            organMap.put(tree.getId(), tree);
        }
        List userList = this.findUser();
        if (userList != null) {
            for (PfUser user : userList) {
                Ztree treetmp = this.toUserZtree(user);
                organMap.put(user.getOrganId() + treetmp.getId(), treetmp);
            }
        }
        organMap.put(firstNode.getId(), firstNode);
        for (Ztree tree : ((HashMap)organMap).values()) {
            if (tree.getPid() != null) {
                Ztree ztree = (Ztree)((HashMap)organMap).get(tree.getPid());
                if (ztree == null) continue;
                ztree.addChild(tree);
                continue;
            }
            tree.setOpen(true);
            root = tree;
        }
        return root;
    }

    public boolean checkValidRegionCode(String regionCode, String superRegionCode) {
        boolean isok = false;
        if (StringUtils.isNotBlank((String)regionCode)) {
            if (StringUtils.equalsIgnoreCase((String)"treeroot", (String)superRegionCode) || StringUtils.isBlank((String)superRegionCode)) {
                isok = true;
            } else {
                String superXzqdm;
                PfOrgan superOrgan = (PfOrgan)this.findById((Object)superRegionCode);
                if (superOrgan != null && StringUtils.isNotBlank((String)superOrgan.getOrganId()) && StringUtils.isNotBlank((String)(superXzqdm = superOrgan.getRegionCode()))) {
                    if (StringUtils.length((String)superXzqdm) == 2 || StringUtils.endsWith((String)superXzqdm, (String)"0000")) {
                        String tmpXzqdm = StringUtils.removeEnd((String)superXzqdm, (String)"0000");
                        if (StringUtils.startsWith((String)regionCode, (String)tmpXzqdm)) {
                            isok = true;
                        }
                    } else if (StringUtils.length((String)superXzqdm) == 4 || StringUtils.endsWith((String)superXzqdm, (String)"00")) {
                        String tmpXzqdm = StringUtils.removeEnd((String)superXzqdm, (String)"00");
                        if (StringUtils.startsWith((String)regionCode, (String)tmpXzqdm)) {
                            isok = true;
                        }
                    } else {
                        String tmpXzqdm = superXzqdm;
                        if (StringUtils.startsWith((String)regionCode, (String)tmpXzqdm)) {
                            isok = true;
                        }
                    }
                }
            }
        }
        return isok;
    }
}

