/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfBusiness;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.entity.QPfAuthorize;
import com.gtis.portal.entity.QPfMenu;
import com.gtis.portal.model.Menu;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfAuthorizeService;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PfMenuServiceImpl
extends BaseServiceImpl<PfMenu, String>
implements PfMenuService {
    @Resource(name="baseDaoImpl")
    BaseDao baseDao;
    @PersistenceContext(unitName="entityManagerFactory")
    EntityManager em;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfBusinessService businessService;
    @Autowired
    PfAuthorizeService authorizeService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public PfMenu getMenu(String menuId) {
        return (PfMenu)this.baseDao.getById(PfMenu.class, (Object)menuId);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateMenu(PfMenu menu) {
        this.baseDao.update((Object)menu);
    }

    public void addMenu(PfMenu menu) {
        this.baseDao.save((Object)menu);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void delMenu(PfMenu menu) {
        JPAQuery query = new JPAQuery(this.em);
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        List menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).where(new Predicate[]{qPfMenu.menuParentId.eq((Object)menu.getMenuId())})).list((Expression)qPfMenu);
        if (menuList == null || menuList.size() == 0) {
            new JPADeleteClause(this.em, (EntityPath)qPfMenu).where(new Predicate[]{qPfMenu.menuId.eq((Object)menu.getMenuId())}).execute();
        } else {
            for (PfMenu menuVo : menuList) {
                this.delMenu(menuVo);
            }
        }
    }

    @Cacheable(value={"menuCache"}, key="#roles+'getMenusByRole'")
    public Menu getMenusByRole(String roles) {
        List menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPAQuery query = new JPAQuery(this.em);
        if (StringUtils.isBlank((String)roles)) {
            menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        } else {
            QPfAuthorize qPfAuthorize = QPfAuthorize.pfAuthorize;
            roles = roles.replace("'", "");
            Object[] roleList = roles.split(",");
            menuList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).where(new Predicate[]{qPfMenu.menuId.in((Collection)((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfAuthorize})).where(new Predicate[]{qPfAuthorize.authorizeObjType.eq((Object)1), qPfAuthorize.menuVisible.gt((Number)0), qPfAuthorize.undertakerId.in(roleList)})).distinct()).list((Expression)qPfAuthorize.authorizeObjId))})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        }
        LinkedHashMap<String, Menu> menuMap = new LinkedHashMap<String, Menu>();
        Menu root = null;
        for (PfMenu menuVo : menuList) {
            Menu menu = PfMenuServiceImpl.toMenu((PfMenu)menuVo);
            menuMap.put(menu.getId(), menu);
        }
        for (Menu menu : ((HashMap)menuMap).values()) {
            if (menu.getPid() != null) {
                Menu pMenu = (Menu)((HashMap)menuMap).get(menu.getPid());
                if (pMenu == null) continue;
                pMenu.addChild(menu);
                continue;
            }
            root = menu;
        }
        return root;
    }

    @Cacheable(value={"menuCache"}, key="#roles+'_'+#subsystem+'getMenusByRole'")
    public Menu getMenusByRole(String roles, String subsystem) {
        List menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPAQuery query = new JPAQuery(this.em);
        if (StringUtils.isBlank((String)roles)) {
            menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        } else {
            QPfAuthorize qPfAuthorize = QPfAuthorize.pfAuthorize;
            roles = roles.replace("'", "");
            Object[] roleList = roles.split(",");
            menuList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).where(new Predicate[]{qPfMenu.menuId.in((Collection)((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfAuthorize})).where(new Predicate[]{qPfAuthorize.authorizeObjType.eq((Object)1), qPfAuthorize.menuVisible.gt((Number)0), qPfAuthorize.undertakerId.in(roleList)})).distinct()).list((Expression)qPfAuthorize.authorizeObjId))})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        }
        LinkedHashMap<String, Menu> menuMap = new LinkedHashMap<String, Menu>();
        Menu root = null;
        for (PfMenu menuVo : menuList) {
            Menu menu = PfMenuServiceImpl.toMenu((PfMenu)menuVo);
            menuMap.put(menu.getId(), menu);
        }
        for (Menu menu : ((HashMap)menuMap).values()) {
            if (menu.getPid() != null) {
                Menu pMenu = (Menu)((HashMap)menuMap).get(menu.getPid());
                if (pMenu == null) continue;
                pMenu.addChild(menu);
                continue;
            }
            root = menu;
        }
        return root;
    }

    private static Menu toMenu(PfMenu menuVo) {
        Menu menu = new Menu();
        menu.setId(menuVo.getMenuId());
        menu.setIcon(menuVo.getMenuCode());
        menu.setText(menuVo.getMenuName());
        menu.setPid(StringUtils.trimToNull((String)menuVo.getMenuParentId()));
        menu.setCls(menuVo.getMenuCss());
        menu.setExpanded(menuVo.isMenuExpanded());
        String rid = menuVo.getResourceId();
        if (rid != null) {
            menu.setLink("r:" + rid);
        }
        menu.setModel(menuVo.getMenuModel());
        return menu;
    }

    private PfMenu toMenuByMap(HashMap map) {
        PfMenu menu = new PfMenu();
        menu.setMenuId(MapUtils.getString((Map)map, (Object)"MENU_ID"));
        menu.setMenuCode(MapUtils.getString((Map)map, (Object)"MENU_CODE"));
        menu.setMenuName(MapUtils.getString((Map)map, (Object)"MENU_NAME"));
        menu.setMenuParentId(MapUtils.getString((Map)map, (Object)"MENU_PARENT_ID"));
        menu.setResourceId(MapUtils.getString((Map)map, (Object)"RESOURCE_ID"));
        menu.setMenuOrder(MapUtils.getIntValue((Map)map, (Object)"MENU_ORDER"));
        menu.setMenuCss(MapUtils.getString((Map)map, (Object)"MENU_CSS"));
        menu.setMenuExpanded(MapUtils.getBooleanValue((Map)map, (Object)"MENU_EXPANDED"));
        menu.setMenuModel(MapUtils.getIntValue((Map)map, (Object)"MENU_MODEL"));
        return menu;
    }

    public List<PfMenu> getAllParentMenuListByMenuId(String menuId) {
        ArrayList<PfMenu> menuList = new ArrayList<PfMenu>();
        String sql = "select m.* from pf_menu m start with m.menu_id='" + menuId + "'connect by prior m.menu_parent_id= m.menu_id " + " order by m.menu_order";
        List mapList = this.baseDao.getMapBySql(sql, new Object[0]);
        for (HashMap tmp : mapList) {
            menuList.add(this.toMenuByMap(tmp));
        }
        return menuList;
    }

    public Ztree getAllMenuTree() {
        List menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPAQuery query = new JPAQuery(this.em);
        menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        return this.initZtreeByMenuList(menuList);
    }

    public Ztree initZtreeByMenuList(List<PfMenu> menuList) {
        Ztree root = null;
        if (menuList != null && menuList.size() > 0) {
            LinkedHashMap<String, Ztree> menuMap = new LinkedHashMap<String, Ztree>();
            for (PfMenu menuVo : menuList) {
                Ztree tree = this.toZtree(menuVo);
                menuMap.put(tree.getId(), tree);
            }
            for (Ztree tree : ((HashMap)menuMap).values()) {
                if (tree.getPid() != null) {
                    Ztree ztree = (Ztree)((HashMap)menuMap).get(tree.getPid());
                    if (ztree == null) continue;
                    ztree.addChild(tree);
                    continue;
                }
                tree.setOpen(true);
                root = tree;
            }
        }
        return root;
    }

    private Ztree toZtree(PfMenu menuVo) {
        Ztree tree = new Ztree();
        tree.setId(menuVo.getMenuId());
        tree.setName(menuVo.getMenuName());
        tree.setPid(StringUtils.trimToNull((String)menuVo.getMenuParentId()));
        return tree;
    }

    public PfMenu getMenuHasResNoSub(String menuId) {
        PfMenu menu = (PfMenu)this.findById((Object)menuId);
        if (menu != null) {
            if (StringUtils.isNotBlank((String)menu.getResourceId())) {
                PfResource resource = (PfResource)this.resourceService.findById((Object)menu.getResourceId());
                menu.setResource(resource);
            }
            if (menu.getResource() == null) {
                menu.setResource(new PfResource());
            }
            if (StringUtils.isNotBlank((String)menu.getResource().getBusinessId())) {
                PfBusiness business = this.businessService.findById(menu.getResource().getBusinessId());
                menu.getResource().setBusiness(business);
            }
            if (menu.getResource().getBusiness() == null) {
                menu.getResource().setBusiness(new PfBusiness());
            }
        }
        return menu;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void refreshMenuResouceRel(String menuId, String resourceId) {
        if (StringUtils.isNotBlank((String)menuId) && StringUtils.isNotBlank((String)resourceId)) {
            String jpql = "update PfMenu t set t.resourceId=?0 where t.menuId=?1 ";
            this.baseDao.executeJpql(jpql, new Object[]{resourceId, menuId});
        }
    }

    public Ztree getMenuTreeByRole(String roleId) {
        List menuList = this.authorizeService.getAuthorizeMenuListByRoleId(roleId);
        return this.initZtreeByMenuList(menuList);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void resetResouceRel(String resourceId) {
        if (StringUtils.isNotBlank((String)resourceId)) {
            String jpql = "update PfMenu t set t.resourceId=?0 where t.resourceId=?1";
            this.baseDao.executeJpql(jpql, new Object[]{null, resourceId});
        }
    }
}

