/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.service.BaseService;
import com.gtis.portal.util.ClassUtils;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseServiceImpl<E, ID>
implements BaseService<E, ID> {
    @Resource(name="baseDaoImpl")
    BaseDao baseDao;
    @PersistenceContext(unitName="entityManagerFactory")
    public EntityManager em;
    private Class<E> entityClass = ClassUtils.getGenericParameter0(this.getClass());

    public E findById(ID id) {
        if (id != null) {
            return (E)this.baseDao.getById(this.entityClass, id);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void insert(E obj) {
        if (obj != null) {
            this.baseDao.save(obj);
        }
    }

    public void save(E obj) {
        this.insert(obj);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void update(E obj) {
        if (obj != null) {
            this.baseDao.update(obj);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void delete(E obj) {
        if (obj != null) {
            this.baseDao.delete(obj);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteById(ID id) {
        if (id != null) {
            Object obj = this.findById(id);
            this.delete(obj);
        }
    }

    @Transactional
    public void deleteByIds(String ids) {
        if (ids != null) {
            String[] id = ids.toString().split(",");
            for (int i = 0; i < id.length; ++i) {
                this.baseDao.delete(this.entityClass, (Object)id[i]);
            }
        }
    }
}

