package com.gtis.portal.web.config;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl;
import com.google.common.collect.Lists;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.entity.BdcSjpjjl;
import com.gtis.portal.service.server.RandomTurnTaskService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @version 1.0 , 2020/4/10
 * @description 随机派件的用户考勤配置
 **/
@Controller
@RequestMapping("randomTurnTask")
public class RandomTurnTaskController {

    @Autowired
    SysUserService sysUserService;
    @Autowired
    RandomTurnTaskService randomTurnTaskService;

    @RequestMapping("")
    public String randomTurnTask(Model model) {
        //获取所有的角色
        List<PfRoleVo> roleList = sysUserService.getRoleList();
        if (CollectionUtils.isNotEmpty(roleList)) {
            PfRoleVo pfRoleVo = new PfRoleVo();
            pfRoleVo.setRoleName("全部");
            pfRoleVo.setRoleId("");
            roleList.add(0, pfRoleVo);
        }

        List<PfUserVo> pfUserVoList = sysUserService.getAllUsers();
        if (CollectionUtils.isNotEmpty(pfUserVoList)) {
            PfUserVo pfUserVo = new PfUserVo();
            pfUserVo.setUserName("全部");
            pfUserVo.setUserId("");
            pfUserVoList.add(0, pfUserVo);
        }

        model.addAttribute("roleList",roleList);
        model.addAttribute("pfUserVoList",pfUserVoList);
        return "config/random-turn-task";
    }

    /**
     *
     * @param pageable
     * @param userId 用户
     * @param kqzt 考勤状态
     * @param number
     * @param currentPage
     * @return
     */
    @ResponseBody
    @RequestMapping("/getRandomTurnTaskPagesJson")
    public Object getAutoTurnTaskPagesJson(Pageable pageable, String roleId, String userId, String kqzt, @RequestParam(value = "number", required = false) String number, @RequestParam(value = "currentPage", required = false) String currentPage) {
        int pageNumber = pageable.getPageNumber();
        if (currentPage != null)
            pageNumber = Integer.parseInt(currentPage) - 1;
        QPageRequest pageable1 = new QPageRequest(pageNumber, 10);

        List<PfUserVo> userListByRole = new ArrayList<PfUserVo>();
        List<String> userIdList = new ArrayList<String>();
        //用户
        if (StringUtils.isNotBlank(roleId)) {
            userListByRole = sysUserService.getUserListByRole(roleId);
        }
        if (CollectionUtils.isNotEmpty(userListByRole)) {
            for (PfUserVo pfUserVo : userListByRole) {
                userIdList.add(pfUserVo.getUserId());
            }
        }

        org.springframework.data.domain.Page<BdcSjpjjl> bdcSjpjjlPage = randomTurnTaskService.queryBdcSjpjjlList(userIdList, userId, kqzt, pageable1);
        Page<BdcSjpjjl> bdcSjpjjlPage1 = null;
        if (bdcSjpjjlPage != null) {
            bdcSjpjjlPage1 = new PageImpl(bdcSjpjjlPage.getContent(), pageNumber + 1, Integer.parseInt(bdcSjpjjlPage.getTotalElements() + ""), 10);
        }
        return bdcSjpjjlPage1;
    }

    @RequestMapping("getUsers")
    @ResponseBody
    public List<PfUserVo> getUsers(String roleId) {
        List<PfUserVo> userList;
        if (StringUtils.isNotBlank(roleId)) {
            userList = sysUserService.getUserListByRole(roleId);
        } else {
            userList = sysUserService.getAllUsers();
        }
        if (CollectionUtils.isNotEmpty(userList)) {
            PfUserVo pfUserVo = new PfUserVo();
            pfUserVo.setUserName("全部");
            pfUserVo.setUserId("");
            userList.add(0, pfUserVo);
        }
        return userList;
    }

    @RequestMapping("getUserByRole")
    @ResponseBody
    public List<PfUserVo> getUserByRole(String roleId) {
        List<PfUserVo> userList = new ArrayList<PfUserVo>();
        if (StringUtils.isNotBlank(roleId)) {
            userList = sysUserService.getUserListByRole(roleId);
        }
        return userList;
    }

    @ResponseBody
    @RequestMapping("/save")
    public Object save(BdcSjpjjl bdcSjpjjl) {
        String msg = "true";
        try {
            BdcSjpjjl bdcSjpjjl1 = randomTurnTaskService.getBdcSjpjjlByYhid(bdcSjpjjl.getYhid());
            if (bdcSjpjjl1 != null && !StringUtils.equals(bdcSjpjjl.getPjjlid(), bdcSjpjjl1.getPjjlid())) {
                msg = "数据库存在该类型数据！";
                return URLEncoder.encode(msg);
            }
            randomTurnTaskService.save(bdcSjpjjl);
        } catch (Exception e) {
            msg = "保存不成功！";
        }

        return URLEncoder.encode(msg);
    }

    @ResponseBody
    @RequestMapping("/getBdcSjpjjl")
    public Object getBdcSjpjjl(String id) {
        BdcSjpjjl bdcSjpjjl = null;
        if (StringUtils.isNotBlank(id))
            bdcSjpjjl = randomTurnTaskService.getBdcSjpjjl(id);
        if (bdcSjpjjl == null)
            bdcSjpjjl = new BdcSjpjjl();

        return bdcSjpjjl;
    }

    @ResponseBody
    @RequestMapping(value = "del")
    public HashMap del(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        randomTurnTaskService.delBdcSjpjjl(id);
                } else
                    randomTurnTaskService.delBdcSjpjjl(ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping("/batSaveKqzt")
    public Object batSaveKqzt(String userid, String kqzt, @RequestParam(value = "batKqzt", required = false) String batKqzt, @RequestParam(value = "ids", required = false) String ids) {
        String msg = "true";
        List<BdcSjpjjl> bdcSjPjjlList = Lists.newArrayList();
        if (StringUtils.isNotBlank(ids)) {
            String[] idStrs = ids.split(",");
            for (String id : idStrs) {
                BdcSjpjjl bdcZdpjjl = randomTurnTaskService.getBdcSjpjjl(id);
                if (bdcZdpjjl != null)
                    bdcSjPjjlList.add(bdcZdpjjl);
            }
        }
        if (CollectionUtils.isNotEmpty(bdcSjPjjlList)) {
            for (BdcSjpjjl bdcSjpjjl : bdcSjPjjlList) {
                bdcSjpjjl.setKqzt(batKqzt);
                randomTurnTaskService.save(bdcSjpjjl);
            }
        }
        return msg;
    }

}
