package com.gtis.portal.web;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.service.server.BdcXmxxService;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.RiskModel;
import com.gtis.portal.entity.BdcJyshxx;
import com.gtis.portal.entity.Bdcdy;
import com.gtis.portal.model.Menu;
import com.gtis.portal.service.LogService;
import com.gtis.portal.service.TaskCenterService;
import com.gtis.portal.service.server.BdcJyhtService;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.service.server.BdcdyService;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 任务办理中心
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/taskHandle")
public class TaskHandleController {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService taskService;
    @Resource(name = "bdcXmxxService")
    BdcXmxxService bdcXmxxService;
    @Autowired
    TaskCenterService taskCenterService;
    @Autowired
    SysAuthorService sysAuthorService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysMenuService sysMenuService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    LogService logService;
    @Autowired
    BdcdyService bdcdyService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcJyhtService bdcJyhtService;
    @Autowired
    SysActivityService sysActivityService;

    @RequestMapping("")
    public String taskHandle(Model model, @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "rid", required = false) String rid, HttpServletRequest request) throws Exception {
        if (StringUtils.isBlank(rid) || StringUtils.equals(rid, "undefined"))
            rid = "";
        if (StringUtils.isNotBlank(rid) && rid.startsWith("r:")) {
            rid = rid.replace("r:", "");
        }
        boolean hasFinish = false;
        String fileTokenId = "";
        int fileCenterNodeId = 0;
        boolean quickTurn = false;
        boolean canTrustTask = false;
        String defaultName = "";
        String kcdjTypeConfig = "";
        String busiType = "";
        String readOnly = "";
        boolean hasDel = false;
        boolean hasPriority = false;
        boolean canDelOthers = false;
        boolean hasTurnBack = false;
        int menuCount = 0;
        PfWorkFlowInstanceVo workFlowInstanceVo = null;
        List<Menu> menuList = null;
        String taskBackRemark = "";
        String taskTurnRemark = "";
        String platformUrl = AppConfig.getPlatFormUrl();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String userid = userInfo.getId();
        boolean backState = false;
        boolean showShzt = false;
        String shyj="";
        if (StringUtils.isNotBlank(taskid)) {
            taskService.updateTaskStadus(taskid);
            PfTaskVo taskVo = taskService.getTask(taskid);
            PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
            //返回当前页面的节点名称gc
            model.addAttribute("activityName",activityVo.getActivityName());
            workFlowInstanceVo = workFlowIntanceService
                    .getWorkflowInstance(activityVo.getWorkflowInstanceId());
            //是否退回过
            if (AppConfig.getBooleanProperty("turnback.opinion.show", true)) {
                //是否始终显示退回意见
                if (StringUtils.isNotBlank(activityVo.getWorkflowInstanceId())) {
                    List<PfActivityVo> activityList = taskService.getWorkFlowInstanceAllActivityList(activityVo.getWorkflowInstanceId());
                    if (CollectionUtils.isNotEmpty(activityList)) {
                        for (int i = activityList.size() - 1; i > -1; i--) {
                            PfActivityVo pfActivityVo = activityList.get(i);
                            if (pfActivityVo.isBackState()) {
                                backState = true;
                                List<PfTaskVo> pfTaskVoList = taskService.getTaskListByActivity(pfActivityVo.getActivityId());
                                if (CollectionUtils.isNotEmpty(pfTaskVoList)) {
                                    for (PfTaskVo pfTaskVo : pfTaskVoList) {
                                        if (StringUtils.isNotBlank(pfTaskVo.getTaskBefore())) {
                                            PfTaskVo pfTask = taskService.getHistoryTask(pfTaskVo.getTaskBefore());
                                            if (pfTask != null) {
                                                taskBackRemark = pfTask.getRemark();
                                                break;
                                            }
                                        }
                                    }
                                } else {
                                    List<PfTaskVo> pfHisTaskVoList = taskService.getHistoryTaskListByActivity(pfActivityVo.getActivityId());
                                    if (CollectionUtils.isNotEmpty(pfHisTaskVoList)) {
                                        for (PfTaskVo pfTaskVo : pfHisTaskVoList) {
                                            if (StringUtils.isNotBlank(pfTaskVo.getTaskBefore())) {
                                                PfTaskVo pfTask = taskService.getHistoryTask(pfTaskVo.getTaskBefore());
                                                if (pfTask != null) {
                                                    taskBackRemark = pfTask.getRemark();
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            } else if (activityVo != null && activityVo.isBackState()) {
                String beforeTaskId = taskVo.getTaskBefore();
                PfTaskVo pfTaskVo = taskService.getHistoryTask(beforeTaskId);
                if (pfTaskVo != null) {
                    taskBackRemark = pfTaskVo.getRemark();
                }
                backState = true;

            }

            //获取当前任务的之前节点任务
            if (taskVo != null && StringUtils.isNotBlank(taskVo.getTaskBefore())) {
                PfTaskVo pfTaskVo = taskService.getHistoryTask(taskVo.getTaskBefore());
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getRemark()))
                    taskTurnRemark = pfTaskVo.getRemark();
            }
            ///////客户端用来获取附件////////////////////////////////////////
            Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF, true);


            try {
                String userId = SessionUtil.getCurrentUserId();
                String userName = "";
                if (StringUtils.isNotBlank(userId))
                    userName = sysUserService.getUserVo(userId).getUserName();
                Node node = nodeService.getNode(space.getId(), activityVo.getWorkflowInstanceId(), true, userName);
                if (node != null) {
                    fileTokenId = nodeService.getToken(node);
                    fileCenterNodeId = node.getId();
                }
            } catch (Exception ex) {

            }
            // 菜单
            WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
            ActivityModel aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
            quickTurn = aModel.isQuickTurn();
            List<RiskModel> riskList = aModel.getRiskModelList();
            defaultName = aModel.getExtendedAttribute("DefaultName");

            if ("true".equals(aModel.getExtendedAttribute("CanEnTrustTask")))
                canTrustTask = true;
            //扩展属性中关于勘测定界管理模块的配置属性获取
            kcdjTypeConfig = aModel.getExtendedAttribute("KcdjTypeConfig") + "";
            if (StringUtils.isBlank(kcdjTypeConfig)) {
                kcdjTypeConfig = xmlModel.getExtendedAttribute("KcdjTypeConfig");
            }
            busiType = xmlModel.getExtendedAttribute("BusiType") + "";
            if (StringUtils.isBlank(busiType)) {
                busiType = xmlModel.getExtendedAttribute("busiType") + "";
            }

            //默认赋予文件中心可编辑权限，只有在工作流扩展属性中增加了“FileCenterReadOnly”属性，且赋值为“true”时，不可编辑
            readOnly = aModel.getExtendedAttribute("FileCenterReadOnly") + "";
            readOnly = readOnly.toLowerCase();
            if (!readOnly.equals("true")) {
                readOnly = "false";
            }
            org.dom4j.Node node = aModel.getResourcesNode();

            if (node != null) {
                List resList = node.selectNodes(".//Resource");
                menuCount = resList.size();
            }
            hasDel = permitDel(taskVo);
            hasPriority = hasPriorityVisible(rid);
            if ("结束活动".equals(aModel.getActivityDescription())) {
                hasFinish = true;
            } else {
                if (aModel.getDefineId().equals(xmlModel.getEndActivityDefine()) && aModel.getTransitionsList().size() == 0)
                    hasFinish = true;
            }
//           办理页面菜单打开真实地址
            String openRealUrl = AppConfig.getProperty("handleTask.openMenu.realUrl.enable");
            canDelOthers = aModel.isCanDelOthers();
            //取办理菜单
            String menuXml = aModel.getResources();
            if (StringUtils.isNotBlank(menuXml)) {
                menuXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + menuXml;
                Document document = DocumentHelper.parseText(menuXml);
                if (document != null) {
                    List resourceNodeList = document.selectNodes("//Resources/Resource");
                    if (resourceNodeList != null) {
                        menuList = new ArrayList<Menu>();
                        for (int i = 0; i < resourceNodeList.size(); i++) {
                            Menu menu = new Menu();
                            Element resourceEl = (Element) resourceNodeList.get(i);
                            menu.setId(resourceEl.attributeValue("Id"));
                            menu.setText(resourceEl.attributeValue("Name"));
                            String firstLink = platformUrl + "/SysResource.action?from=task&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + resourceEl.attributeValue("Id");
                            if (StringUtils.equals(openRealUrl, "true")) {
                                String resourceUrl = null;
                                if (StringUtils.isNotBlank(resourceEl.attributeValue("Id"))) {
                                    PfResourceVo resourceVo = sysMenuService.getResource(resourceEl.attributeValue("Id"));
                                    if (resourceVo != null) {
                                        resourceUrl = resourceVo.getResourceUrl();
                                        if (StringUtils.indexOf(resourceUrl, "?") > -1)
                                            resourceUrl += "&";
                                        else
                                            resourceUrl += "?";
                                        if (StringUtils.indexOf(resourceUrl, "platform") < 0 && StringUtils.indexOf(resourceUrl, ".url") < 0)
                                            resourceUrl = platformUrl + "/" + resourceUrl;
                                    }
                                }
                                firstLink = handleResourceUrl(resourceUrl + "from=task&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + resourceEl.attributeValue("Id"), request);
                            }
                            List childrenNodeList1 = document.getRootElement().selectNodes("//Resources/Resource[@Id='" + resourceEl.attributeValue("Id") + "']/Resource");
                            if (childrenNodeList1 != null && childrenNodeList1.size() > 0) {
                                Element childEl1 = (Element) childrenNodeList1.get(0);
                                firstLink = platformUrl + "/SysResource.action?from=task&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl1.attributeValue("Id");
                                if (StringUtils.equals(openRealUrl, "true")) {
                                    String resourceUrl = null;
                                    if (StringUtils.isNotBlank(childEl1.attributeValue("Id"))) {
                                        PfResourceVo resourceVo = sysMenuService.getResource(childEl1.attributeValue("Id"));
                                        if (resourceVo != null) {
                                            resourceUrl = resourceVo.getResourceUrl();
                                            if (StringUtils.indexOf(resourceUrl, "?") > -1)
                                                resourceUrl += "&";
                                            else
                                                resourceUrl += "?";
                                            if (StringUtils.indexOf(resourceUrl, "platform") < 0 && StringUtils.indexOf(resourceUrl, ".url") < 0)
                                                resourceUrl = platformUrl + "/" + resourceUrl;
                                        }
                                    }
                                    firstLink = handleResourceUrl(resourceUrl + "from=task&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl1.attributeValue("Id"), request);
                                }
                            }
                            menu.setLink(firstLink);
                            List childrenNodeList = resourceEl.selectNodes("//Resources/Resource[@Id='" + resourceEl.attributeValue("Id") + "']/Resource");
                            if (childrenNodeList != null && childrenNodeList.size() > 0) {
                                List<Menu> childMenuList = new ArrayList<Menu>();
                                for (int j = 1; j < childrenNodeList.size(); j++) {
                                    Menu childMenu = new Menu();
                                    Element childEl = (Element) childrenNodeList.get(j);
                                    childMenu.setId(childEl.attributeValue("Id"));
                                    childMenu.setText(childEl.attributeValue("Name"));
                                    String firstChildLink = platformUrl + "/SysResource.action?from=task&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl.attributeValue("Id");
                                    if (StringUtils.equals(openRealUrl, "true")) {
                                        String resourceUrl = null;
                                        if (StringUtils.isNotBlank(childEl.attributeValue("Id"))) {
                                            PfResourceVo resourceVo = sysMenuService.getResource(childEl.attributeValue("Id"));
                                            if (resourceVo != null) {
                                                resourceUrl = resourceVo.getResourceUrl();
                                                if (StringUtils.indexOf(resourceUrl, "?") > -1)
                                                    resourceUrl += "&";
                                                else
                                                    resourceUrl += "?";
                                                if (StringUtils.indexOf(resourceUrl, "platform") < 0 && StringUtils.indexOf(resourceUrl, ".url") < 0)
                                                    resourceUrl = platformUrl + "/" + resourceUrl;
                                            }
                                        }
                                        firstChildLink = handleResourceUrl(resourceUrl + "from=task&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl.attributeValue("Id"), request);
                                    }
                                    List childChildNodeList = resourceEl.selectNodes("//Resources/Resource[@Id='" + resourceEl.attributeValue("Id") + "']/Resource[@Id='" + childEl.attributeValue("Id") + "']/Resource");
                                    if (childChildNodeList != null && childChildNodeList.size() > 0) {
                                        Element childEl1 = (Element) childChildNodeList.get(0);
                                        firstChildLink = platformUrl + "/SysResource.action?from=task&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl1.attributeValue("Id");
                                        if (StringUtils.equals(openRealUrl, "true")) {
                                            String resourceUrl = null;
                                            if (StringUtils.isNotBlank(childEl1.attributeValue("Id"))) {
                                                PfResourceVo resourceVo = sysMenuService.getResource(childEl1.attributeValue("Id"));
                                                if (resourceVo != null) {
                                                    resourceUrl = resourceVo.getResourceUrl();
                                                    if (StringUtils.indexOf(resourceUrl, "?") > -1)
                                                        resourceUrl += "&";
                                                    else
                                                        resourceUrl += "?";
                                                    if (StringUtils.indexOf(resourceUrl, "platform") < 0 && StringUtils.indexOf(resourceUrl, ".url") < 0)
                                                        resourceUrl = platformUrl + "/" + resourceUrl;
                                                }
                                            }
                                            firstChildLink = handleResourceUrl(resourceUrl + "from=task&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl1.attributeValue("Id"), request);
                                        }
                                    }
                                    childMenu.setLink(firstChildLink);


                                    if (childChildNodeList != null && childChildNodeList.size() > 0) {
                                        List<Menu> childChildMenuList = new ArrayList<Menu>();
                                        for (int k = 1; k < childChildNodeList.size(); k++) {
                                            Menu childChildMenu = new Menu();
                                            Element childChildEl = (Element) childChildNodeList.get(k);
                                            childChildMenu.setId(childChildEl.attributeValue("Id"));
                                            childChildMenu.setText(childChildEl.attributeValue("Name"));
                                            childChildMenu.setLink(platformUrl + "/SysResource.action?from=task&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childChildEl.attributeValue("Id"));
                                            if (StringUtils.equals(openRealUrl, "true")) {
                                                String resourceUrl = null;
                                                if (StringUtils.isNotBlank(childChildEl.attributeValue("Id"))) {
                                                    PfResourceVo resourceVo = sysMenuService.getResource(childChildEl.attributeValue("Id"));
                                                    if (resourceVo != null) {
                                                        resourceUrl = resourceVo.getResourceUrl();
                                                        if (StringUtils.indexOf(resourceUrl, "?") > -1)
                                                            resourceUrl += "&";
                                                        else
                                                            resourceUrl += "?";
                                                        if (StringUtils.indexOf(resourceUrl, "platform") < 0 && StringUtils.indexOf(resourceUrl, ".url") < 0)
                                                            resourceUrl = platformUrl + "/" + resourceUrl;
                                                    }
                                                }
                                                String childLink = handleResourceUrl(resourceUrl + "from=task&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childChildEl.attributeValue("Id"), request);
                                                childChildMenu.setLink(childLink);
                                            }
                                            childChildMenuList.add(childChildMenu);
                                        }
                                        childMenu.setChildren(childChildMenuList);
                                    }

                                    childMenuList.add(childMenu);
                                }
                                menu.setChildren(childMenuList);
                                menu.setExpanded(true);
                            }
                            menuList.add(menu);
                        }
                    }
                }
            }
            /**
             * 是否显示交易审核意见
             */

            if(AppConfig.getBooleanProperty("shzt.show.enable",false)) {
                String wiid="";
                PfWorkFlowInstanceVo pfWorkFlowInstanceVo=new PfWorkFlowInstanceVo();
                if (StringUtils.isNotBlank(taskid)) {
                    PfTaskVo pfTaskVo = taskService.getTask(taskid);
                    if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                        PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                        if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                            pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                        if (pfWorkFlowInstanceVo != null)
                            wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                    }
                }
                if (StringUtils.isNotBlank(wiid)) {
                    List<com.gtis.portal.entity.BdcXm> bdcXmList = bdcXmService.getBdcXmList(wiid);
                    if(CollectionUtils.isNotEmpty(bdcXmList)){
                        for (com.gtis.portal.entity.BdcXm bdcXm : bdcXmList) {
                            if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getProid())) {
                                List<BdcJyshxx> bdcJyhts = bdcJyhtService.getJyhtList(bdcXm.getProid());
                                if(CollectionUtils.isNotEmpty(bdcJyhts)){
                                    for (BdcJyshxx jyht : bdcJyhts) {
                                        if(StringUtils.isNotBlank(jyht.getShzt())){
                                            if (StringUtils.equals(jyht.getShzt(),"交易审核不通过")){
                                                showShzt = true;
                                            }
                                            shyj=jyht.getShyj();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

            }
        }
        if (workFlowInstanceVo == null)
            workFlowInstanceVo = new PfWorkFlowInstanceVo();
        if (menuList == null)
            menuList = new ArrayList<Menu>();
        if (SessionUtil.getCurrentUser().isAdmin()) {
            hasTurnBack = true;
        } else {
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List<PfPartitionInfoVo> lstfPartitions = sysAuthorService.getSystemResrouceFunAuthorList(roles, rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("退回")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("resTurnBack")) {
                        hasTurnBack = true;
                        break;
                    }
                }
            }
        }
        boolean deleteOtherTask = AppConfig.getBooleanProperty("task.taskHandle.deleteOtherTask", false);
        if (deleteOtherTask && taskCenterService.handleTaskDeleteOtherTask(SessionUtil.getCurrentUser())) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(taskid)) {
                PfTaskVo selfPfTaskVo = taskService.getTask(taskid);
                List<PfTaskVo> pfTaskVoList = taskService.getTaskListByActivity(selfPfTaskVo.getActivityId());
                for (PfTaskVo pfTaskVo : pfTaskVoList) {
                    if (!pfTaskVo.getTaskId().equals(taskid)) {
                        taskService.deleteTask(pfTaskVo.getTaskId());
                    }
                }
            }
        }
        boolean tabControlEnable = AppConfig.getBooleanProperty("taskhandle.tab.control.enable", false);
        boolean modelWinEnable = AppConfig.getBooleanProperty("view.file.model.window.enable", false);
        String checkFaceUrl = AppConfig.getProperty("face.check.url");
        boolean checkFaceEnable = false;
        if (StringUtils.isNotBlank(checkFaceUrl))
            checkFaceEnable = true;
        model.addAttribute("username", userInfo.getUsername());
        model.addAttribute("userid", userInfo.getId());
        model.addAttribute("taskTurnRemark", taskTurnRemark);
        model.addAttribute("hasFinish", hasFinish);
        model.addAttribute("fileTokenId", fileTokenId);
        model.addAttribute("fileCenterNodeId", fileCenterNodeId);
        model.addAttribute("quickTurn", quickTurn);
        model.addAttribute("canTrustTask", canTrustTask);
        model.addAttribute("defaultName", defaultName);
        model.addAttribute("kcdjTypeConfig", kcdjTypeConfig);
        model.addAttribute("busiType", busiType);
        model.addAttribute("readOnly", readOnly);
        model.addAttribute("hasDel", hasDel);
        model.addAttribute("canDelOthers", canDelOthers);
        model.addAttribute("workFlowInstanceVo", workFlowInstanceVo);
        model.addAttribute("taskid", taskid);
        model.addAttribute("menuCount", menuCount);
        model.addAttribute("menuList", menuList);
        model.addAttribute("bdcdjUrl", AppConfig.getProperty("bdcdj.url"));
        model.addAttribute("version", AppConfig.getProperty("portal.version"));
        model.addAttribute("taskBackRemark", taskBackRemark);
        model.addAttribute("taskBackState", backState);
        model.addAttribute("autoSaveReport", AppConfig.getBooleanProperty("task.taskHandle.autoSaveReport", true));
        model.addAttribute("deleteOtherTask", AppConfig.getBooleanProperty("task.taskHandle.deleteOtherTask", false));
        model.addAttribute("hasFileBrowse", AppConfig.getBooleanProperty("file.browse.enable", false));
        model.addAttribute("showException", AppConfig.getBooleanProperty("show.add.exception.enable", false));
        model.addAttribute("showEvaluateBtn", AppConfig.getBooleanProperty("show.evaluate.button", false));
        model.addAttribute("hasTurnBack", hasTurnBack);
        model.addAttribute("rid", rid);
        model.addAttribute("tabControlEnable", tabControlEnable);
        model.addAttribute("checkFaceUrl", checkFaceUrl);
        model.addAttribute("checkFaceEnable", checkFaceEnable);
        model.addAttribute("hasPriority", hasPriority);
        model.addAttribute("zhijianEnable", AppConfig.getBooleanProperty("zhijian.enable", false));
        model.addAttribute("showJyshzt",showShzt);
        model.addAttribute("jyshyj",shyj);
        model.addAttribute("qualityControlEnable",taskCenterService.handleQualityControlDisplay(SessionUtil.getCurrentUser()));
        if (tabControlEnable)
            return "task-handle-tab-control";
        else if (modelWinEnable)
            return "task-handle";
        else
            return "task-handle";
    }

    private boolean permitDel(PfTaskVo taskVo) {
        //如果配置删除权限按照删除权限控制，如果没有配置按照之前逻辑
        String delTaskBtnDisplayRole = AppConfig.getProperty("task.list.del.role");
        if (StringUtils.isNotBlank(delTaskBtnDisplayRole))
            return taskCenterService.delTaskBtnDisplay(SessionUtil.getCurrentUser());
        else if (!SessionUtil.getCurrentUser().isAdmin()) {
            PfActivityVo activityVo = taskService.getActivity(taskVo
                    .getActivityId());
            PfWorkFlowInstanceVo workFlowInstanceVo = workFlowIntanceService
                    .getWorkflowInstance(activityVo.getWorkflowInstanceId());
            WorkFlowXml workXml = WorkFlowXmlUtil
                    .getInstanceModel(workFlowInstanceVo);
            if (!workXml.getBeginActivityDefine().equals(
                    activityVo.getActivityDefinitionId())) {
                return false;
            }
        }
        return true;
    }

    /**
     * @param rid
     * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @date : 2019/5/22 17:37
     * @return:boolean
     * @Description : 权限控制表单页面的“调整优先级按钮是否显示”
     */
    private boolean hasPriorityVisible(String rid) {
        boolean hasPriority = false;
        if (SessionUtil.getCurrentUser().isAdmin()) {
            hasPriority = true;
        } else {
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List<PfPartitionInfoVo> lstfPartitions = sysAuthorService.getSystemResrouceFunAuthorList(roles, rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("优先")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("priority")) {
                        hasPriority = true;
                        break;
                    }
                }
            }

        }
        return hasPriority;
    }

    /**
     * @param taskid 当前任务ID
     * @return 提示信息
     * @author <a href="mailto:zhaodongdong@gtmap.cn">zdd</a>
     * @description 删除当前流程节点的所有待办任务  除了当前任务  该操作不可逆
     */
    @ResponseBody
    @RequestMapping("/deleteOtherTask")
    public Object deleteOtherTask(String taskid) {
        HashMap map = new HashMap();
        String msg = "取件失败！";
        try {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(taskid)) {
                PfTaskVo selfPfTaskVo = taskService.getTask(taskid);
                List<PfTaskVo> pfTaskVoList = taskService.getTaskListByActivity(selfPfTaskVo.getActivityId());
                for (PfTaskVo pfTaskVo : pfTaskVoList) {
                    if (!pfTaskVo.getTaskId().equals(taskid)) {
                        taskService.deleteTask(pfTaskVo.getTaskId());
                    }
                }
            }
            msg = "取件成功！";
        } catch (Exception e) {
            e.printStackTrace();
        }
        map.put("msg", msg);
        return map;
    }

    /**
     * @param wiid 浏览该项目附件
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description
     */
    @RequestMapping(value = "/browseFile", method = RequestMethod.GET)
    public String createAllFileFolder(Model model, @RequestParam(value = "wiid", required = false) String wiid) {
        String fileCenterUrl = "fcm";
        String project_fileId = null;
        fileCenterUrl = fileCenterUrl + AppConfig.getFileCenterUrl().substring(4);
        List<String> proidList = null;
        Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF, true);
        try {
            List<BdcXm> bdcXmList = bdcXmxxService.getBdcXmListByWiid(wiid);
            if (CollectionUtils.isNotEmpty(bdcXmList)) {
                proidList = new ArrayList<String>();
                int i = 0;
                for (BdcXm bdcXm : bdcXmList) {
                    proidList.add(bdcXm.getProid());
                    i++;
                }
            }
        } catch (Exception e) {
            PfWorkFlowInstanceVo workFlowInstanceVo = workFlowIntanceService
                    .getWorkflowInstance(wiid);
            if (workFlowInstanceVo != null && StringUtils.isNotBlank(workFlowInstanceVo.getProId())) {
                proidList = new ArrayList<String>();
                proidList.add(workFlowInstanceVo.getProId());
            }
        }
        if (CollectionUtils.isNotEmpty(proidList)) {
            try {
                for (String proid : proidList) {
                    Node node = nodeService.getNode(space.getId(), proid, false);

                    if (node != null && StringUtils.isBlank(project_fileId))
                        project_fileId = node.getId().toString();
                    else
                        project_fileId = project_fileId + "," + node.getId().toString();
                }

            } catch (Exception ex) {

            }
        }
        model.addAttribute("fileCenterUrl", fileCenterUrl);
        model.addAttribute("nodeId", project_fileId);
        model.addAttribute("username",SessionUtil.getCurrentUser().getUsername());
        return "file-browse";
    }

    /**
     * @param resourceUrl 资源url
     * @return 处理后的url字符串
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 对资源url进行处理，包括占位符，查询参数和行政区代码
     */
    private String handleResourceUrl(String resourceUrl, HttpServletRequest request) {
        StringBuffer result = new StringBuffer(AppConfig.getPlaceholderValue(resourceUrl));
        result.append("&userid=").append(SessionUtil.getUserInfo(request).getId());
        return result.toString();
    }

    /**
     * @return void
     * @Param [source, wiid, taskid, userid, request]
     * @Author <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @Date 9:04 2019/5/21
     * @Description 前台点击附件查看、附件管理、附件浏览执行此方法，记录日志
     */
    @RequestMapping("/attachOpenLog")
    @ResponseBody
    private void attachOpenLog(String source, String wiid, String taskid, String userid, HttpServletRequest request) {
        String remark = "用户从" + URLDecoder.decode(source) + "点击查看的附件信息";
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户查看附件" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            logService.saveLog(request, userid, remark, wiid, content, "查看附件");
        } catch (Exception e) {
        }
    }
    @RequestMapping("/checkLhcfToCf")
    @ResponseBody
    private HashMap checkLhcfToCf (String wiid,String proid) {
        HashMap hashMap=new HashMap();
        hashMap.put("msg","轮询是否");
        hashMap.put("ok","/bdcCf/turnLhcfToCf");
        hashMap.put("cancel","/bdcCf/cancelLhcfToCf");
        return hashMap;
    }

    @RequestMapping("/hasBdcdyh")
    @ResponseBody
    public Map hasBdcdyh(@RequestParam(value = "wiid", required = false) String wiid) {
        Map map=new HashMap();
        List<com.gtis.portal.entity.BdcXm> bdcXmList = bdcXmService.getBdcXmList(wiid);
        boolean hasBdcdyh=false;
        String bdcdyid=null;
        for (com.gtis.portal.entity.BdcXm bdcXm : bdcXmList) {
            bdcdyid = bdcXm.getBdcdyid();
            if(StringUtils.isNotBlank(bdcdyid)){
               break;
            }
        }
        if(StringUtils.isNotBlank(bdcdyid)){
            List<Bdcdy> bdcdy =  bdcdyService.getBdcdyxxByBdcdyid(bdcdyid);
            if(StringUtils.isNotBlank(bdcdy.get(0).getBdcdyh())){
                hasBdcdyh=true;
            }
        }
        map.put("hasBdcdyh", hasBdcdyh);
        return map;
    }
}
