package com.gtis.portal.web;

import com.google.common.collect.Maps;
import com.gtis.common.Page;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SplitDataService;
import com.gtis.plat.service.SysUserService;
import com.gtis.portal.model.RssContent;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * 任务中心
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/taskCenterRss")
public class TaskCenterRssController {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    @Qualifier("platformSplitDataService")
    private SplitDataService splitDataService;

    @RequestMapping(value="/rss", method = RequestMethod.GET)
    public ModelAndView getFeedInRss() throws Exception {
        String userId=SessionUtil.getCurrentUserId();
        String loginName="";
        if(StringUtils.isNotBlank(userId))
            loginName=sysUserService.getUserVo(userId).getLoginName();
        List<RssContent> items = new ArrayList<RssContent>();
        HashMap mapParam = Maps.newHashMap();
        mapParam.put("userIds", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());
        Page page=splitDataService.query("getTaskList", mapParam, 0, 10);
        if(page!=null && CollectionUtils.isNotEmpty(page.getItems())){
            for(Object obj:page.getItems()){
                Map map1=(Map)obj;
                RssContent rss=new RssContent();
                rss.setDescription("业务名称："+cn.gtmap.estateplat.utils.CommonUtil.formatEmptyValue(map1.get("WORKFLOW_NAME"))+"\n描述："+(cn.gtmap.estateplat.utils.CommonUtil.formatEmptyValue(map1.get("REMARK"))).replaceAll("\\$", "\n"));
                rss.setPubDate((Date) map1.get("CREATE_TIME"));
                rss.setTitle(cn.gtmap.estateplat.utils.CommonUtil.formatEmptyValue(map1.get("WORKFLOW_INSTANCE_NAME")));
                rss.setUrl(AppConfig.getProperty("cas.url")+"/calogin?username="+loginName+"&url="+AppConfig.getProperty("portal.url")+"/taskHandle%3Ftaskid="+cn.gtmap.estateplat.utils.CommonUtil.formatEmptyValue(map1.get("ASSIGNMENT_ID")));
                items.add(rss);
            }
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("rssViewer");
        mav.addObject("feedContent", items);

        return mav;

    }
}
