package com.gtis.portal.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.ByteObjectAccess;
import com.gtis.common.util.CommonUtil;
import com.gtis.config.AppConfig;
import com.gtis.dao.ibatis.IbatisDataAccess;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.util.Constants;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * 剩余天数提醒超期任务中心
 *
 * @author <a href="mailto:zx@gtmap.cn">zx</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/overTimeTask")
public class OverTimeTaskController {
    @Autowired
    private SplitDataService splitDataService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysUserService sysUserService;
    @ResponseBody
    @RequestMapping("getOverTaskCount/{userId}")
    public String taskCenter(@PathVariable String userId) throws Exception {
        String workflowNames=AppConfig.getProperty("overTime.task.workflowNames");
        String queryStr="";
        if(StringUtils.isNotBlank(workflowNames)){
            for(String workflowName:workflowNames.split(",")){
                if(StringUtils.isBlank(queryStr))
                    queryStr="'"+workflowName+"'";
                else
                    queryStr=queryStr+",'"+workflowName+"'";
            }
        }

        String warningDay = AppConfig.getProperty("task.warning.day");
        if (StringUtils.isBlank(warningDay))
            warningDay = "0";
        //显示超期任务
        HashMap mapParam2 = Maps.newHashMap();
        mapParam2.put("userId", userId);
//        mapParam2.put("TASK_STATE", "1");
        mapParam2.put("workflowNames",queryStr);
        mapParam2.put("warningDay",warningDay);
        //不计算超期的节点
        String noComputeActivityNames = AppConfig.getProperty("overTime.noCompute.activityNames");
        if (StringUtils.isNotBlank(noComputeActivityNames)) {
            String[] activityNameArray = noComputeActivityNames.split(",");
            String activityNames = null;
            for (String activityName : activityNameArray) {
                if (StringUtils.isBlank(activityNames))
                    activityNames = "'" + activityName + "'";
                else
                    activityNames += ",'" + activityName + "'";
            }
            mapParam2.put("NOT_IN_ACTIVITY_NAMES", activityNames);
        }
        int totalCount = splitDataService.getCount("getTaskList",mapParam2);

        return totalCount+"";
    }

    @RequestMapping("getOverTaskList")
    public String getOverTaskList(Model model, @RequestParam(value = "userId", required = false) String userId) throws Exception {
        List<PfBusinessVo> businessVoList = sysWorkFlowDefineService.getBusinessList();
        List<PfOrganVo> pfOrganVoList = sysUserService.getAllOrganList();
        List<PfUserVo> pfUserVoList = sysUserService.getAllUsers();
        //显示超期任务
        SplitParamImpl splitParam3 = new SplitParamImpl();
        splitParam3.setQueryString("getTaskList");
        HashMap mapParam2 = Maps.newHashMap();
        mapParam2.put("userId", userId);
//        mapParam2.put("TASK_STATE", "1");
        String workflowNames=AppConfig.getProperty("overTime.task.workflowNames");
        String queryStr="";
        if(StringUtils.isNotBlank(workflowNames)){
            for(String workflowName:workflowNames.split(",")){
                if(StringUtils.isBlank(queryStr))
                    queryStr="'"+workflowName+"'";
                else
                    queryStr=queryStr+",'"+workflowName+"'";
            }
        }
        mapParam2.put("workflowNames",queryStr);
        String warningDay = AppConfig.getProperty("task.warning.day");
        if (StringUtils.isBlank(warningDay))
            warningDay = "0";
        mapParam2.put("warningDay",warningDay);
        //不计算超期的节点
        String noComputeActivityNames = AppConfig.getProperty("overTime.noCompute.activityNames");
        if (StringUtils.isNotBlank(noComputeActivityNames)) {
            String[] activityNameArray = noComputeActivityNames.split(",");
            String activityNames = null;
            for (String activityName : activityNameArray) {
                if (StringUtils.isBlank(activityNames))
                    activityNames = "'" + activityName + "'";
                else
                    activityNames += ",'" + activityName + "'";
            }
            mapParam2.put("NOT_IN_ACTIVITY_NAMES", activityNames);
        }

        splitParam3.setQueryParam(mapParam2);
        model.addAttribute("overTimeTaskList", ByteObjectAccess.objectToString(splitParam3));
        model.addAttribute("noComputeActivityNames", noComputeActivityNames);
        model.addAttribute("currentDate", CommonUtil.getCurrStrDate());
        model.addAttribute("businessList", businessVoList != null ? businessVoList : Lists.newArrayList());
        model.addAttribute("wrapEnable", AppConfig.getBooleanProperty("task.list.wrap.enable", true));
        model.addAttribute("pfOrganVoList", pfOrganVoList);
        model.addAttribute("pfUserVoList", pfUserVoList);
        model.addAttribute("splitStr", Constants.SPLIT_STR);
        model.addAttribute("userid", SessionUtil.getCurrentUserId());
        model.addAttribute("stateShowBegin", AppConfig.getBooleanProperty("task.state.showBegin.enable", false));
        model.addAttribute("overTimeEnble", AppConfig.getProperty("task.overTime.enable"));
        model.addAttribute("showBusinessName", AppConfig.getBooleanProperty("workflowName.show.businessName", false));
        model.addAttribute("showUploadFile", AppConfig.getBooleanProperty("task.taskList.showUploadFile", true));
        return "task-over-time";
    }
}
