package com.gtis.portal.web;

import cn.gtmap.estateplat.model.examine.BdcExamineParam;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.util.ImageUtil;
import com.gtis.portal.util.ReadXmlProps;
import com.gtis.portal.util.WaterMarkBO;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


@Controller
public class IndexController extends BaseController {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysDistrictService sysDistrictService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysActivityService sysActivityService;
    //密码包含大小写字母、数字，且6位以上
    private final static String PASSWORD_REG_EXP = "^(?![A-Z]+$)(?![a-z]+$)(?!\\d+$)(?![\\W_]+$)\\S{6,16}$";


    @RequestMapping("index")
    public String index(Model model, String systemId, HttpServletRequest request) {
        String xzqdm = request.getParameter("xzqdm");
        UserInfo userInfo = SessionUtil.getCurrentUser();
        model.addAttribute("userName", SessionUtil.getCurrentUser().getUsername());
        List<PfOrganVo> organList = userInfo.getLstOragn();
        String organ = "";
        if (organList != null && organList.size() > 0)
            organ = organList.get(0).getOrganName();
        model.addAttribute("organName", organ);

        String defaultDistrictCode = AppConfig.getProperty("district.code");
        List districtList;
        if (StringUtils.isNotBlank(defaultDistrictCode))
            districtList = sysDistrictService.querySubDistrictByCode(AppConfig.getProperty("district.code"));
        else
            districtList = sysDistrictService.queryAllDistrict();
        PfUserVo pfUserVo = sysUserService.getUserVo(SessionUtil.getCurrentUserId());
        model.addAttribute("districtList", districtList);
        if (StringUtils.isBlank(systemId))
            systemId = AppConfig.getProperty("portal.system.default");
        String hideLogoutBtn = "false";
        if (StringUtils.isNotBlank(AppConfig.getProperty("hide.logout.btn")))
            hideLogoutBtn = AppConfig.getProperty("hide.logout.btn");
        List<Map> deployRegionList = ReadXmlProps.getDeployRegionList(pfUserVo.getLoginName());
        Map regionMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(deployRegionList)) {
            if (StringUtils.isBlank(xzqdm)) {
                regionMap.put("xzqdm", deployRegionList.get(0).get("xzqdm"));
                regionMap.put("xzqmc", deployRegionList.get(0).get("xzqmc"));
                regionMap.put("sysUrl", deployRegionList.get(0).get("sysUrl"));
                regionMap.put("getTaskCountUrl", deployRegionList.get(0).get("getTaskCountUrl"));
            } else {
                for (Map deployRegionMap : deployRegionList) {
                    if (deployRegionMap.get("xzqdm") != null && StringUtils.equals(xzqdm, deployRegionMap.get("xzqdm").toString()))
                        regionMap = deployRegionMap;
                }
            }

        }
        String oaUrl = AppConfig.getProperty("oa.href");
        if (StringUtils.isNotBlank(oaUrl))
            oaUrl = StringUtils.substring(oaUrl, 0, oaUrl.indexOf("${")) + pfUserVo.getLoginName() + StringUtils.substring(oaUrl, oaUrl.indexOf("}") + 1, oaUrl.length());
        String bdcjyUrl = AppConfig.getProperty("bdcjy.href");
        if (StringUtils.isNotBlank(bdcjyUrl))
            bdcjyUrl = StringUtils.substring(bdcjyUrl, 0, bdcjyUrl.indexOf("${")) + pfUserVo.getLoginName() + StringUtils.substring(bdcjyUrl, bdcjyUrl.indexOf("}") + 1, bdcjyUrl.length());
        String iframeUrl = AppConfig.getProperty("net.iframe.url");
        boolean iframeEnable = false;
        if (StringUtils.isNotBlank(iframeUrl)) {
            iframeUrl = StringUtils.substring(iframeUrl,0,iframeUrl.indexOf("{1}")) + pfUserVo.getLoginName() + StringUtils.substring(iframeUrl,iframeUrl.indexOf("{1}")+3,iframeUrl.indexOf("{2}"))
                 +  ClientInfoUtil.getIpAddr(request) + StringUtils.substring(iframeUrl,iframeUrl.indexOf("{2}")+3);
            iframeEnable = true;
            logger.info("iframe的url地址："+iframeUrl);
        }
        model.addAttribute("iframeEnable",iframeEnable);
        model.addAttribute("iframeUrl",iframeUrl);
        model.addAttribute("subsystemId", systemId);
        model.addAttribute("ompUrl", AppConfig.getProperty("omp.href"));
        model.addAttribute("archiveUrl", AppConfig.getProperty("archive.url"));
        model.addAttribute("bdcdjUrl", AppConfig.getProperty("bdcdj.url"));
        model.addAttribute("showLeftMenuMethod", AppConfig.getProperty("show.left.menu.method"));
        model.addAttribute("hideLogoutBtn", hideLogoutBtn);
        model.addAttribute("userid", userInfo.getId());
        model.addAttribute("username", userInfo.getUsername());
        model.addAttribute("loginname", pfUserVo.getLoginName());
        model.addAttribute("clientIp", ClientInfoUtil.getIpAddr(request));
        model.addAttribute("subStyle", AppConfig.getProperty("portal.subsystem.style"));
        model.addAttribute("deployRegionList", deployRegionList);
        model.addAttribute("regionMap", regionMap);
        model.addAttribute("oaUrl", oaUrl);
        model.addAttribute("bdcjyUrl", bdcjyUrl);
        model.addAttribute("showRegionEnable", AppConfig.getProperty("change.deploy.region.enable"));
        //System.out.println(bdcjyUrl);
        String zwFrameEnable = AppConfig.getProperty("zw.portal.frame.enable");
        if (StringUtils.equals(zwFrameEnable, "true"))
            return "index/base/index-base";
        else
            return "index";
    }

    @RequestMapping("password")
    @ResponseBody
    public Object password(Model model, String oldPassword, String newPassword, String confirmNewPassword) throws Exception {
//        if(StringUtils.isBlank(newPassword))
//            throw new PortalException(ExceptionCode.PASSWORD_BLANK);
        if (!newPassword.equals(confirmNewPassword))
            throw new PortalException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        if (AppConfig.getBooleanProperty("password.complexity.enable", false) && !checkPasswordComplexity(newPassword))
            throw new PortalException(ExceptionCode.PASSWORD_COMPLEXITY);
        else {
            String userId = SessionUtil.getCurrentUserId();
            PfUserVo userObj = sysUserService.getUserVo(userId);
            if (userObj == null) {
                throw new PortalException(ExceptionCode.USER_NOT_FOUND);
            } else {
                String checkpass = oldPassword;
                String md5 = Md5Util.Build(checkpass);
                if (md5.equals(userObj.getLoginPassWord())) {
                    if (sysUserService.savePassWord(userId, newPassword)) {
                        return handlerSuccessJson();
                    } else
                        throw new PortalException(ExceptionCode.USER_MODIFY_ERROR);
                } else
                    throw new PortalException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
            }
        }
    }

    @RequestMapping("signPassword")
    @ResponseBody
    public Object signPassword(Model model, String oldSignPassword, String newSignPassword, String confirmNewSignPassword) throws Exception {
        if (StringUtils.isBlank(newSignPassword))
            throw new PortalException(ExceptionCode.PASSWORD_BLANK);
        if (!newSignPassword.equals(confirmNewSignPassword))
            throw new PortalException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        else {
            String userId = SessionUtil.getCurrentUserId();
            PfUserVo userObj = sysUserService.getUserVo(userId);
            if (userObj == null) {
                throw new PortalException(ExceptionCode.USER_NOT_FOUND);
            } else {
                String checkpass = oldSignPassword;
                String md5 = Md5Util.Build(checkpass);
                if (md5.equals(userObj.getSignPassword()) || StringUtils.isBlank(userObj.getSignPassword())) {
                    if (sysUserService.saveSignPassword(userId, newSignPassword)) {
                        return handlerSuccessJson();
                    } else
                        throw new PortalException(ExceptionCode.USER_MODIFY_ERROR);
                } else {
                    throw new PortalException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
                }

            }
        }
    }

    /**
     * @param password 待验证的密码
     * @return 是否符合复杂度要求
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/12/6
     * @description 是否包含大小写字母、数字，特殊且长度不少于6，不大于16
     */
    private Boolean checkPasswordComplexity(String password) {
        Pattern pattern = Pattern.compile(PASSWORD_REG_EXP);
        Matcher matcher = pattern.matcher(password);
        return matcher.matches();
    }


    @RequestMapping("logout")
    public String logout(HttpSession httpSession) {
        httpSession.invalidate();
        return "redirect:/logout.action";
    }

    @RequestMapping("two/index")
    public String twoIndex(Model model, String systemId, @RequestParam(value = "subMenuType", required = false) String subMenuType) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        model.addAttribute("userName", SessionUtil.getCurrentUser().getUsername());
        List<PfOrganVo> organList = userInfo.getLstOragn();
        String organ = "";
        if (organList != null && organList.size() > 0)
            organ = organList.get(0).getOrganName();
        model.addAttribute("organName", organ);

        String defaultDistrictCode = AppConfig.getProperty("district.code");
        List districtList;
        if (StringUtils.isNotBlank(defaultDistrictCode))
            districtList = sysDistrictService.querySubDistrictByCode(AppConfig.getProperty("district.code"));
        else
            districtList = sysDistrictService.queryAllDistrict();
        model.addAttribute("districtList", districtList);
        if (StringUtils.isBlank(systemId))
            systemId = AppConfig.getProperty("portal.system.default");
        if (StringUtils.isBlank(subMenuType))
            subMenuType = "two";
        //主题颜色样式
        String subStyle = AppConfig.getProperty("portal.subsystem.style");
        if (StringUtils.isBlank(subStyle)) {
            subStyle = "greenStyle";
        }
        model.addAttribute("subStyle", subStyle);
        model.addAttribute("subsystemId", systemId);
        model.addAttribute("subMenuType", subMenuType);
        model.addAttribute("ompUrl", AppConfig.getProperty("omp.href"));
        model.addAttribute("archiveUrl", AppConfig.getProperty("archive.url"));
        model.addAttribute("bdcdjUrl", AppConfig.getProperty("bdcdj.url"));
        return "index/index-two-menu";
    }


    //生成水印图片
    @RequestMapping("/showWatermark")
    public void showWatermark(HttpServletRequest request, HttpServletResponse response) throws Exception {
        //水印配置类
        WaterMarkBO waterMarkBO = new WaterMarkBO();
        waterMarkBO.setMarkContent(SessionUtil.getUserName(request));
        waterMarkBO.setFontSize(20);
        waterMarkBO.setFontType("STCAIYUN");
        waterMarkBO.setFontType("STCAIYUN");
        response.setContentType("image/png");
        OutputStream os = response.getOutputStream();
        ImageIO.write(ImageUtil.createMark(waterMarkBO), "png", os);
        os.flush();
        os.close();
    }
    @ResponseBody
    @RequestMapping("/test")
    public Object test(HttpServletRequest request) throws Exception {
        List<HashMap> mapList=new ArrayList<HashMap>();
        HashMap map=new HashMap();
        map.put("wszt","01");
        map.put("wsztmc","已完税");
        mapList.add(map);
//        HashMap map1=new HashMap();
//        map1.put("msg","信息");
//        map1.put("checkModel","confirm");
//        String userId = "0";
//        String wiid = "46BK1011766HV301";
//        PfTaskVo pfTaskVo = null;
//        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
//        List<PfTaskVo> pfTaskVoList = sysTaskService.getTaskListByInstance(pfWorkFlowInstanceVo.getWorkflowIntanceId());
//        if (CollectionUtils.isNotEmpty(pfTaskVoList)) {
//            pfTaskVo = pfTaskVoList.get(0);
//        }
//        WorkFlowInfo workFlowInfo = workFlowCoreService.getWorkFlowTurnInfo(userId, pfTaskVo.getTaskId());
//        workFlowInfo.getTransInfo().getTranActivitys().remove(0);
//        //开始转发
//        workFlowCoreService.postWorkFlow(userId, pfTaskVo.getTaskId(), workFlowInfo);
//        mapList.add(map1);

        return map;
//        WorkFlowInfo info = workFlowCoreService.getWorkFlowTurnInfo("A57A3A5F809A463183753676070236F4", "2B4L4035HQ08E70T");
//        workFlowCoreService.finishWorkFlow(info);
//        ReadXmlProps.getTasklistFilterList();
//
//        String fileUrl="http://127.0.0.1/fileCenter/file/upload.do?token=whosyourdaddy&nid=77769";
//        List<NameValuePair> parameters = Lists.newArrayList();
//        parameters.add(new BasicNameValuePair("client", ""));
//        parameters.add(new BasicNameValuePair("path", "d:/a.txt"));
//        parameters.add(new BasicNameValuePair("userId", "系统管理员"));
//
//        CloseableHttpResponse response = null;
//        HttpPost post = new HttpPost(fileUrl);
//        post.setEntity(new UrlEncodedFormEntity(parameters, Charsets.UTF_8));
//        try {
//            response = ((CloseableHttpClient) httpClient).execute(post);
//            System.out.println(response);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
    }
    @ResponseBody
    @RequestMapping(value = "/beforeTurnProjectEvent", method = RequestMethod.GET)
    public void beforeTurnProjectEvent(@RequestParam(value = "proid", required = false) String proid,
                                       @RequestParam(value = "activityid", required = false) String activityid,
                                       @RequestParam(value = "userid", required = false) String userid,
                                       @RequestParam(value = "taskid", required = false) String taskid, HttpServletResponse response) {
        //   long stat = System.currentTimeMillis();
        String str = "[{'msg':'验证信息1','checkModel':'confirm'},{'msg':'验证信息2','checkModel':'confirm'}]";
        //   System.out.println("beforeTurnProjectEvent" + stat);

        try {
            response.setContentType("text/xml;charset=GBK");
            PrintWriter out = response.getWriter();
            out.println(str);
            out.flush();
            out.close();
        } catch (Exception e) {
            logger.error(e.getMessage());
        }

    }
    @RequestMapping("getDeployRegionTaskCount")
    @ResponseBody
    public Object getDeployRegionTaskCount(Model model, String urls, String xzqdms) {
        Map taskCountMap = Maps.newHashMap();
        if (StringUtils.isNotBlank(urls) && StringUtils.isNotBlank(xzqdms) && StringUtils.split(urls, ",").length == StringUtils.split(xzqdms, ",").length) {
            String userIds = SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds();
            String[] xzqdmStr = xzqdms.split(",");
            int i = 0;
            for (String url : urls.split(",")) {
                String taskCount = "";
                try {
                    HttpInvokerProxyFactoryBean httpInvokerProxyFactoryBean = new HttpInvokerProxyFactoryBean();
                    httpInvokerProxyFactoryBean.setServiceInterface(SysWorkFlowInstanceService.class);
                    httpInvokerProxyFactoryBean.setServiceUrl(url);
                    httpInvokerProxyFactoryBean.afterPropertiesSet();
                    SysWorkFlowInstanceService workFlowInstanceService = (SysWorkFlowInstanceService) httpInvokerProxyFactoryBean.getObject();
                    HashMap mapParam = Maps.newHashMap();
                    mapParam.put("userIds", userIds);
                    taskCount = workFlowInstanceService.getTaskCount(mapParam);
                } catch (Exception e) {
                }
                if (StringUtils.isBlank(taskCount))
                    taskCount = "0";
                taskCountMap.put(xzqdmStr[i], taskCount);
                i++;
            }

        }
        return taskCountMap;
    }

}