package com.gtis.portal.service.server;


import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.entity.BdcZdpjjl;
import com.gtis.portal.entity.BdcZdpjjlAll;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

public interface AutoTurnTaskService {
    /**
     * 根据用户id、节点id、工作流id、考勤状态获取自动派件的信息
     * @param wdid
     * @param jdid
     * @param yhid
     * @param kqzt
     * @return
     */
    public BdcZdpjjl getBdcZdpjjlByWdidAndJdidAndYhid(String wdid, String jdid, String yhid, String kqzt);
    /**
     * 根据用户id获取自动派件的信息
     * @param yhid
     * @return
     */
    public BdcZdpjjl getBdcZdpjjlByYhid(String yhid);
    /**
     * 根据用户id获取自动派件的信息
     * @param wdid
     * @param jdid
     * @param userVoList
     * @return
     */
    public String getZdpjYhid(String wdid, String jdid, List<PfUserVo> userVoList);
    /**
     * 获取自动派件信息
     * @param id
     * @return
     */
    public BdcZdpjjl getBdcZdpjjl(String id);

    /**
     * 更新自动派件信息
     * @param bdcZdpjjl
     */
    public void updateBdcZdpjjl(BdcZdpjjl bdcZdpjjl);
    /**
     * 新增自动派件信息
     * @param bdcZdpjjl
     */
    public void addBdcZdpjjl(BdcZdpjjl bdcZdpjjl);
    /**
     * 删除自动派件信息
     * @param id
     */
    public void delBdcZdpjjl(String id);

    /**
     * 获取自动排挤分页信息
     * @param wdid
     * @param jdmc
     * @param userid
     * @param page
     * @param kqzt
     * @return
     */
    public Page<BdcZdpjjl> queryBdcZdpjjlList(List<String> pfUserVoList,String wdid, String jdmc,String userid, String kqzt,  Pageable page);

    /**
     * 保存自动派件信息
     * @param bdcZdpjjl
     */
    public void save(BdcZdpjjl bdcZdpjjl);

    /**
     * 查询用户id、节点id、工作流id、考勤状态自动派件的信息
     * @param wdid
     * @param jdmc
     * @param userid
     * @param kqzt
     * @return
     */
    public List<BdcZdpjjl> queryBdcZdpjjlList(String wdid, String jdmc, String userid, String kqzt);
    /**
     * 查询当前流程节点可转发的所有人员
     * @param gzlid
     * @param jdid
     * @param kqzt
     * @return
     */
    public List<BdcZdpjjl> queryBdcZdpjjlList(String gzlid, String jdid, String kqzt);
    /**
     * 查询当前流程节点可转发的所有人员（全流程）
     * @param kqzt
     * @return
     */
    public List<BdcZdpjjlAll> queryBdcZdpjjlAllList(String kqzt);

    /**
     * 获取只按照派件顺序进行派件的自动全局派件人员
     * @return getLoopBdcZdpjjlAllId
     */
    String getLoopBdcZdpjjlAllYhId(List<PfUserVo> userVoList);

    /**
     * 获取只按照派件顺序进行派件的自动派件人员
     * @param wdid
     * @param jdid
     * @param userVoList
     * @return
     */
    String getLoopBdcZdpjjlYhId(String wdid, String jdid, List<PfUserVo> userVoList);
}
