package com.gtis.portal.service.impl.quartz;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.common.Page;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SplitDataService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.MessageAcceptDao;
import com.gtis.portal.dao.MessageSendDao;
import com.gtis.portal.entity.PfLog;
import com.gtis.portal.entity.PfMessageAccept;
import com.gtis.portal.entity.PfMessageSend;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.service.PfMessageService;
import com.gtis.portal.util.Constants;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.gtis.portal.entity.QPfMessageAccept.pfMessageAccept;
import static com.gtis.portal.entity.QPfMessageSend.pfMessageSend;

/**
 * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
 * @version 1.0 2018/12/14
 * @description 根据配置自动检查 办理时限即将到期的业务 发送消息给办理人员
 */
@Service
public class AutoCheckTaskServcice {

    protected final Logger logger = Logger.getLogger(getClass());

    @Autowired
    SplitDataService splitDataService;
    @Autowired
    private MessageSendDao messageSendDao;
    @Autowired
    private PfMessageService pfMessageService;
    @Autowired
    private MessageAcceptDao messageAcceptDao;
    @Autowired
    private SysUserService sysUserService;
    @Resource(name = "baseDaoImpl")
    BaseDao baseDao;


    @Scheduled(cron = "${autoCheckTask.sendMessage.quartz.config}")
    public void autoSendMessage() {
        String autoCheckTaskSendMessageEnable = AppConfig.getProperty("autoCheckTask.sendMessage.enable");
        Date checkTime = new Date();
        if (StringUtils.equals(autoCheckTaskSendMessageEnable, "true")) {
            logger.info("自动检查待办任务是否超期任务开始" + CalendarUtil.formatDateTime(checkTime));
            String autoCheckTaskSendMessageCheckTimeRange = AppConfig.getProperty("autoCheckTask.sendMessage.checkTime.timeRange");
            int checkTimeRange = StringUtils.isNoneBlank(autoCheckTaskSendMessageCheckTimeRange) ? Integer.valueOf(autoCheckTaskSendMessageCheckTimeRange) : 6;
            HashMap mapParam = Maps.newHashMap();
            mapParam.put("userIds", null);
            int taskListSize = splitDataService.getCount("getTaskList", mapParam);
            Page<HashMap> taskListPage = splitDataService.query("getTaskList", mapParam, 0, taskListSize);
            if (taskListPage != null && taskListPage.getItems() != null) {
                List<HashMap> taskList = taskListPage.getItems();
                // 节点办理人员 用户名
                String userid;
                // 业务超期时间
                Date overTime;
                // 业务超期时间与当前时间的时间差
                int hours;
                String slbh="";
                String[] slbhArr;
                 for (HashMap taskMap : taskList) {
                    if (taskMap != null && taskMap.containsKey("TASK_OVER_TIME") && taskMap.get("TASK_OVER_TIME") != null
                            && taskMap.containsKey("USER_ID") && taskMap.get("USER_ID") != null
                            && taskMap.containsKey("WORKFLOW_INSTANCE_ID") && taskMap.get("WORKFLOW_INSTANCE_ID") != null) {
                        String remark = "";
                        if (taskMap.containsKey("REMARK") && taskMap.get("REMARK") != null) {
                            remark = taskMap.get("REMARK").toString();
                            slbhArr = StringUtils.split(remark,"$");
                            if (slbhArr != null && slbhArr.length>0) {
                                slbh = slbhArr[0];
                            }
                        }
                        hours = getHours(checkTime, (Date) taskMap.get("TASK_OVER_TIME"));
                        userid = taskMap.get("USER_ID").toString();
                        overTime = (Date) taskMap.get("TASK_OVER_TIME");
                        if (hours <= checkTimeRange) {
                            checkTaskHasSendMessage(slbh,userid,hours,overTime);
                        }
                    }
                }
                logger.info("自动检查待办任务是否超期任务结束" + CalendarUtil.formatDateTime(new Date()));
            }
        }
    }


    /**
     * @param overPlusTime 剩余办理时间 小时
     *@param userId 节点办理人员id
     * @param messageacceptId 接收消息主键
     * @param messagesendId  发送消息主键
     * @param slbh 业务受理编号
     * @param taskOverTime 任务超期时间
     * @param userName  节点办理人员用户名
     * @return
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @description 获取即将到期的待办任务 给办理人员发消息
     */
    private String sendMessage(int overPlusTime, String userId, String slbh, Date taskOverTime, String messagesendId,String messageacceptId, int messageacceptStatus, String userName) {
        String result = "";
        if ( StringUtils.isNotBlank(userId) && StringUtils.isNotBlank(slbh)) {
            Map<String,Object> messagsendcontentMap = new HashMap<String, Object>(4);
            try {
                messagsendcontentMap.put("待办任务受理编号",slbh);
                messagsendcontentMap.put("节点办理人",userName);
                messagsendcontentMap.put("待办任务截止日期",CalendarUtil.formatDateTime(taskOverTime));
                PfUser pfUser = new PfUser();
                pfUser.setUserId("0");
                PfMessageSend pfMessageSend = new PfMessageSend();
                pfMessageSend.setMessagesendId(messagesendId);
                pfMessageSend.setMessagesendDate(new Date());
                if (overPlusTime > 0) {
                    pfMessageSend.setMessagesendTitle("待办任务时限即将到期提醒");
                    messagsendcontentMap.put("剩余办理时长",overPlusTime+"小时");
                } else {
                    pfMessageSend.setMessagesendTitle("待办任务时限已超期提醒");
                    messagsendcontentMap.put("超期时长",Math.abs(overPlusTime)+"小时");
                }
                pfMessageSend.setMessagesendUser(pfUser);
                pfMessageSend.setMessagesendContent(JSON.toJSONString(messagsendcontentMap));
                if (StringUtils.isNotBlank(messagesendId) && messageacceptStatus == 0) {
                    pfMessageSend.setMessagesendId(messagesendId);
                    baseDao.update(pfMessageSend);
                } else {
                    pfMessageSend.setMessagesendId(UUIDGenerator.generate18());
                    messageSendDao.saveAndFlush(pfMessageSend);
                }
                if (StringUtils.isBlank(messageacceptId) || messageacceptStatus == 1) {
                    pfMessageService.addAcceptMessageByUser(userId, pfMessageSend);
                }
                //保存日志
                savePfLogBySendMessage(pfMessageSend, "0");
                result = "success";
            } catch (Exception e) {
                result = "fail";
                logger.error(e.getMessage() + "_" + e.toString(), e);
            }
        }
        return result;
    }


    /**
     * @param checkTime 检查时间
     * @param overTime  超期时间
     * @return
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @description 获取检查时间和超期时间之间的时间差的小时
     */
    int getHours(Date checkTime, Date overTime) {
        int hours = 0;
        if (checkTime != null && overTime != null) {
            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            try {
                String checkTimes = simpleFormat.format(checkTime);
                String overTimes = simpleFormat.format(overTime);
                hours = (int) ((simpleFormat.parse(overTimes).getTime() - simpleFormat.parse(checkTimes).getTime()) / (1000 * 60 * 60));
            } catch (ParseException e) {
                logger.info(e.getMessage() + "_" + e.toString(), e);
            }
        }
        return hours;
    }


    /**
     * @param userId 发送消息的用户id
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @description 保存日志
     */
    private void savePfLogBySendMessage(PfMessageSend pfMessageSend, String userId) {
        if (pfMessageSend != null) {
            PfLog pfLog = new PfLog();
            pfLog.setId(UUIDGenerator.generate18());
            pfLog.setUserId(userId);
            pfLog.setAction(Constants.MESSAGE_ACTION);
            pfLog.setContent(pfMessageSend.getMessagesendContent());
            pfLog.setIp(null);
            pfLog.setCreateTime(new Date());
            pfMessageService.addPfLog(pfLog);
        }
    }


    /**
    *@author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
    *@param slbh 业务受理编号
    *@param restTime 任务结束时间和当前时间之间的时间差
    *@param userId 节点办理人员的用户id
    * @param overTime  节点任务超期时间
    @description  验证即将超期的待办任务是否发送过消息 没有发送则发送消息 否则更新消息
    */
    void checkTaskHasSendMessage(String slbh, String userId, int restTime,Date overTime){
        String messageTitle;
        String messagesendId = "";
        String messageacceptId = "";
        int messageacceptStatus = 0;
        String userName = "";
        if (StringUtils.isNotBlank(slbh) && StringUtils.isNotBlank(userId)) {
            PfUserVo pfUserVo = sysUserService.getUserVo(userId);
            if (pfUserVo != null) {
                userName = pfUserVo.getUserName();
            }
            BooleanExpression expression = pfMessageSend.messagesendUser.userId.eq("0");
            if (restTime > 0) {
                messageTitle = "待办任务时限即将到期提醒";
            } else {
                messageTitle = "待办任务时限已超期提醒";
            }
            expression = expression == null ? pfMessageSend.messagesendTitle.like("%" + messageTitle + "%")
                    : expression.and(pfMessageSend.messagesendTitle.like("%" + messageTitle + "%"));
            expression = expression == null ? pfMessageSend.messagesendContent.like("%" + slbh + "%")
                    : expression.and(pfMessageSend.messagesendContent.like("%" + slbh + "%"));
            expression = expression == null ? pfMessageSend.messagesendContent.like("%" + userName + "%")
                    : expression.and(pfMessageSend.messagesendContent.like("%" + userName + "%"));
            Pageable page = new PageRequest(0, 10,null);
            org.springframework.data.domain.Page<PfMessageSend> pfMessageSendPage = messageSendDao.findAll(expression,page);
            if (pfMessageSendPage != null && pfMessageSendPage.getTotalPages() >0 && CollectionUtils.isNotEmpty(pfMessageSendPage.getContent())) {
                Map messagesendcontentMap;
                for (PfMessageSend pfMessageSend : pfMessageSendPage.getContent()) {
                    if (pfMessageSend != null) {
                          messagesendcontentMap = JSON.parseObject(pfMessageSend.getMessagesendContent(),Map.class);
                          if (messagesendcontentMap != null && messagesendcontentMap.containsKey("节点办理人") && StringUtils.equals(userName,messagesendcontentMap.get("节点办理人").toString())) {
                              messagesendId = pfMessageSend.getMessagesendId();
                              BooleanExpression expressionAccept = pfMessageAccept.messageSend.messagesendId.eq(messagesendId);
                              Pageable pageAccept = new PageRequest(0, 10,null);
                              org.springframework.data.domain.Page<PfMessageAccept> pfMessageAcceptPage = messageAcceptDao.findAll(expressionAccept, pageAccept);
                              if (pfMessageAcceptPage != null && pfMessageAcceptPage.getTotalPages()>0 ) {
                                  messageacceptId = pfMessageAcceptPage.getContent().get(0).getMessageacceptId();
                                  messageacceptStatus = pfMessageAcceptPage.getContent().get(0).getMessageacceptStatus();
                                  if (messageacceptStatus == 0) {
                                      break;
                                  }
                              }
                          }
                    }
                }
            }
            sendMessage(restTime, userId, slbh, overTime,messagesendId,messageacceptId,messageacceptStatus,userName);
        }
    }
}
