package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.service.portal.TaskPerformerFilterService;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfTaskVo;
import com.gtis.portal.service.PfTaskService;
import com.gtis.portal.service.TaskActionService;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2016/9/30
 * @description 任务信息接口方法（包含任务状态信息）
 */
@Service
public class PfTaskServiceImpl implements PfTaskService {
    @Resource(name = "baseDaoImpl")
    BaseDao baseDao;

    @Override
    public PfTaskVo queryPfTaskByTaskId(String taskid) {
        if (StringUtils.isNotBlank(taskid))
            return baseDao.getById(PfTaskVo.class, taskid);
        return null;
    }

    @Override
    public void updateTaskStatusInfo(PfTaskVo pfTaskVo) {
        if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getAssignmentId())) {
            PfTaskVo pfTaskVoDb = queryPfTaskByTaskId(pfTaskVo.getAssignmentId());
            pfTaskVoDb.setOptUser(pfTaskVo.getOptUser());
            pfTaskVoDb.setOptUserId(pfTaskVo.getOptUserId());
            pfTaskVoDb.setTaskStatus(pfTaskVo.getTaskStatus());
            baseDao.update(pfTaskVoDb);
        }
    }

    @Override
    public void deleteTaskStatusInfo(String taskid) {
        if (StringUtils.isNotBlank(taskid)) {
            PfTaskVo pfTaskVoDb = queryPfTaskByTaskId(taskid);
            pfTaskVoDb.setOptUser(null);
            pfTaskVoDb.setOptUserId(null);
            pfTaskVoDb.setTaskStatus(null);
            baseDao.update(pfTaskVoDb);
        }
    }


}
