package com.gtis.portal.service;

import com.gtis.portal.entity.PfMessageSend;
import com.gtis.portal.entity.PfNews;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * @author: <a href="mailto:shenfei@gtmap.cn">sf</a>
 * @version: 1.0
 * @Date: 2019-05-31 15:01
 * @Description:
 */
public interface PfNewsService {

    /**
     * 查询信息发布列表
     *
     * @param content
     * @param beginDate
     * @param endDate
     * @param page
     * @return
     */
    public Page<PfNews> queryNewsList(String content, Date beginDate, Date endDate, Pageable page);

    /**
     * 删除信息发布
     *
     * @param pfNews
     */
    public void deleteNews(PfNews pfNews);

    /**
     * 删除保存信息发布
     *
     * @param pfNews
     */
    public void saveNews(PfNews pfNews);

    /**
     * 修改信息发布
     *
     * @param pfNews
     */
    public void updateNews(PfNews pfNews);

    /**
     * 根据id查找信息发布数据
     *
     * @param newId
     */
    public PfNews getById(String newId);

    public List<PfNews> getList();

}
