package com.gtis.portal.entity;

import com.google.common.collect.Sets;

import javax.persistence.*;
import java.util.Set;

/**
 * 子系统
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/3/9
 */
@Entity
@Table(name = "PF_SUBSYSTEM")
public class PfSubsystem {
    @Id
    @Column
    private String subsystemId;
    @Column
    private String subsystemName;
    @Column
    private String subsystemTitle;
    @Column
    private boolean enabled;

    @ManyToMany(mappedBy = "subsystems")
    private Set<PfMenu> menus = Sets.newHashSet();

    public String getSubsystemId() {
        return subsystemId;
    }

    public void setSubsystemId(String subsystemId) {
        this.subsystemId = subsystemId;
    }

    public String getSubsystemName() {
        return subsystemName;
    }

    public void setSubsystemName(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    public String getSubsystemTitle() {
        return subsystemTitle;
    }

    public void setSubsystemTitle(String subsystemTitle) {
        this.subsystemTitle = subsystemTitle;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Set<PfMenu> getMenus() {
        return menus;
    }

    public void setMenus(Set<PfMenu> menus) {
        this.menus = menus;
    }
}
