package com.gtis.portal.web.config;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.*;
import com.gtis.portal.entity.BdcGzlsx;
import com.gtis.portal.entity.BdcZdpjjl;
import com.gtis.portal.service.server.WorkFlowTimeLimitService;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 工作流时限配置
 *
 * @author <a href="mailto:liangxichang@gtmap.cn">liangxichang</a>
 * @description: 修改受理单办件时限逻辑，根据单位代码控制各登记流程办理时限
 */
@Controller
@RequestMapping("/workFlowTimeLimit")
public class WorkFlowTimeLimitController extends BaseController {

    private static final Log log = LogFactory.getLog(WorkFlowTimeLimitController.class);

    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    WorkFlowTimeLimitService workFlowTimeLimitService;

    @RequestMapping("")
    public String workFlowTimeLimitController(Model model) throws Exception {

        List<PfWorkFlowDefineVo> pfWorkFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();

        if (CollectionUtils.isNotEmpty(pfWorkFlowDefineVoList)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = new PfWorkFlowDefineVo();
            pfWorkFlowDefineVo.setWorkflowName("全部");
            pfWorkFlowDefineVo.setWorkflowDefinitionId("");
            pfWorkFlowDefineVoList.add(0, pfWorkFlowDefineVo);
        }

        model.addAttribute("pfWorkFlowDefineVoList", pfWorkFlowDefineVoList);

       return "config/workFlowTimeLimit";
    }

    @RequestMapping("/getWorkFlowTimeLimitPagesJson")
    @ResponseBody
    public  Object getWorkFlowTimeLimitPagesJson(Pageable pageable, String wdid,  String jdmc,  @RequestParam(value = "number", required = false) String number, @RequestParam(value = "currentPage", required = false) String currentPage) {
        int pageNumber = pageable.getPageNumber();
        if (currentPage != null)
            pageNumber = Integer.parseInt(currentPage) - 1;
        QPageRequest pageable1 = new QPageRequest(pageNumber, 10);

        org.springframework.data.domain.Page<BdcGzlsx> bdcGzlsxPage = workFlowTimeLimitService.queryGzlsxList( wdid, jdmc, pageable1);
        Page<BdcGzlsx> bdcGzlsxPage1 = null;
        if (bdcGzlsxPage != null) {
            bdcGzlsxPage1 = new PageImpl(bdcGzlsxPage.getContent(), pageNumber + 1, Integer.parseInt(bdcGzlsxPage.getTotalElements() + ""), 10);
        }
        return bdcGzlsxPage1;

    }

    @ResponseBody
    @RequestMapping("/save")
    public Object save(BdcGzlsx bdcGzlsx){
        String msg = "true";
        try {
            BdcGzlsx bdcGzlsx2 = workFlowTimeLimitService.getBdcGzlsxByWdidAndJdidAndDwdm(bdcGzlsx.getWorkflow_id(), bdcGzlsx.getActivity_id() ,bdcGzlsx.getDwdm());
            if (bdcGzlsx2 != null && !StringUtils.equals(bdcGzlsx2.getWorkflow_time_id(),bdcGzlsx.getWorkflow_time_id())) {
                msg = "工作流时限配置重复,请重新填写！";
                return URLEncoder.encode(msg);
            }
            workFlowTimeLimitService.save(bdcGzlsx);
        } catch (Exception e) {
            msg = "保存不成功！";
        }

        return URLEncoder.encode(msg);

    }

    @ResponseBody
    @RequestMapping("/getBdcGzlsxjl")
    public Object getBdcGzlsxjl(String id){
        BdcGzlsx bdcGzlsx = null;
        if (StringUtils.isNotBlank(id))
            bdcGzlsx = workFlowTimeLimitService.getBdcGzlsxjl(id);
        if (bdcGzlsx == null)
            bdcGzlsx = new BdcGzlsx();

        return bdcGzlsx;
    }

    @ResponseBody
    @RequestMapping(value = "del")
    public HashMap del(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        workFlowTimeLimitService.delBdcGzlsxjl(id);
                } else
                    workFlowTimeLimitService.delBdcGzlsxjl(ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping("/batSaveJdsx")
    public Object batSaveJdsx(String wdid, String jdmc, @RequestParam(value = "activity_time_limit", required = false) Integer activity_time_limit, @RequestParam(value = "ids", required = false) String ids) {
        String msg = "true";
        List<BdcGzlsx> bdcGzlsxes = Lists.newArrayList();
        if (StringUtils.isNotBlank(ids)) {
            String[] idStrs = ids.split(",");
            for (String id : idStrs) {
                BdcGzlsx bdcGzlsx = workFlowTimeLimitService.getBdcGzlsxjl(id);
                if (bdcGzlsx != null)
                    bdcGzlsxes.add(bdcGzlsx);
            }
        } else
            bdcGzlsxes = workFlowTimeLimitService.queryGzlsxList(wdid,jdmc);
        if (CollectionUtils.isNotEmpty(bdcGzlsxes)) {
            for (BdcGzlsx bdcGzlsx : bdcGzlsxes) {
                bdcGzlsx.setActivity_time_limit(activity_time_limit);
                workFlowTimeLimitService.save(bdcGzlsx);
            }
        }
        return msg;
    }
}


