package com.gtis.portal.web.config;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.portal.entity.WorkFlowCommission;
import com.gtis.portal.service.server.WorkFlowCommissionService;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.net.URLEncoder;
import java.util.*;

/**
 * @author <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @version 1.0 , 2019/12/25
 * @description 任务代办功能配置
 **/
@Controller
@RequestMapping("/workFlowCommission")
public class WorkFlowCommissionController {

    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    WorkFlowCommissionService workFlowCommissionService;

    /**
     * 进入任务待办配置界面
     * @param model model
     * @return "config/workflow-commission"
     */
    @RequestMapping("")
    public String autoTurnTask(Model model){
        List<PfWorkFlowDefineVo> pfWorkFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();
        List<PfUserVo> pfUserVoList = new ArrayList<PfUserVo>();
        pfUserVoList = sysUserService.getAllUsers();

        if (CollectionUtils.isNotEmpty(pfWorkFlowDefineVoList)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = new PfWorkFlowDefineVo();
            pfWorkFlowDefineVo.setWorkflowName("全部");
            pfWorkFlowDefineVo.setWorkflowDefinitionId("");
            pfWorkFlowDefineVoList.add(0, pfWorkFlowDefineVo);
        }
        if (CollectionUtils.isNotEmpty(pfUserVoList)) {
            PfUserVo pfUserVo = new PfUserVo();
            pfUserVo.setUserName("全部");
            pfUserVo.setUserId("");
            pfUserVoList.add(0, pfUserVo);
        }
        model.addAttribute("pfWorkFlowDefineVoList", pfWorkFlowDefineVoList);
        model.addAttribute("pfUserVoList", pfUserVoList);
        return "config/workflow-commission";
    }

    /**
     * 获取任务待办分页数据
     * @param pageable pageable
     * @param workFlowId 流程名称
     * @param principalId 委托人id
     * @param agentId  代办人id
     * @param number number
     * @param currentPage currentPage
     * @return
     */
    @ResponseBody
    @RequestMapping("/getWorkFlowCommissionPagesJson")
    public Object getWorkFlowCommissionPagesJson(Pageable pageable, String workFlowId, String principalId, String agentId, @RequestParam(value = "number", required = false) String number, @RequestParam(value = "currentPage", required = false) String currentPage) {
        int pageNumber = pageable.getPageNumber();
        if (currentPage != null)
            pageNumber = Integer.parseInt(currentPage) - 1;
        QPageRequest pageable1 = new QPageRequest(pageNumber, 10);

        org.springframework.data.domain.Page<WorkFlowCommission> workFlowCommissionPage = workFlowCommissionService.queryWorkFlowCommissionList( workFlowId, principalId, agentId, pageable1);
        Page<WorkFlowCommission> workFlowCommissionPage1 = null;
        if (workFlowCommissionPage != null) {
            workFlowCommissionPage1 = new PageImpl(workFlowCommissionPage.getContent(), pageNumber + 1, Integer.parseInt(workFlowCommissionPage.getTotalElements() + ""), 10);
        }
        return workFlowCommissionPage1;
    }

    /**
     * 获取委托人和代办人
     * @param workFlowId 流程id
     * @param principalId 委托人id
     * @return
     */
    @RequestMapping("getPrincipalAndAgent")
    @ResponseBody
    public Object getPrincipalAndAgent(String workFlowId, String principalId) {
        Map map = Maps.newHashMap();
        List<PfUserVo> pfUserVoList = Lists.newArrayList();
        List<PfUserVo> pfUserVoList1 = null;
        if(StringUtils.isNotBlank(workFlowId)) {
            pfUserVoList = sysUserService.getAllUsers();
            if(StringUtils.isNotBlank(principalId)){
                pfUserVoList1 = Lists.newArrayList(pfUserVoList);
                if(CollectionUtils.isNotEmpty(pfUserVoList1)) {
                    Iterator<PfUserVo> it = pfUserVoList1.iterator();
                    while(it.hasNext()){
                        PfUserVo pfUserVo = (PfUserVo)it.next();
                        if(principalId.equals(pfUserVo.getUserId())){
                            it.remove();
                        }
                    }
                }
            }
        }
        map.put("principalList", pfUserVoList);
        map.put("agentList", pfUserVoList1);
        return map;
    }

    /**
     * 保存记录
     * @param workFlowCommission 实体
     * @return msg
     */
    @ResponseBody
    @RequestMapping("/save")
    public Object save(WorkFlowCommission workFlowCommission) {
        String msg = "true";
        try {
            WorkFlowCommission workFlowCommission1 = workFlowCommissionService.getWorkFlowCommissionByWdidAndYhid(workFlowCommission.getWorkFlowId(), workFlowCommission.getPrincipalId(), workFlowCommission.getAgentId());
            if (workFlowCommission1 != null && !StringUtils.equals(workFlowCommission1.getWorkFlowCommissionId(), workFlowCommission.getWorkFlowCommissionId())) {
                msg = "数据库存在该类型数据！";
                return URLEncoder.encode(msg);
            }
            workFlowCommissionService.save(workFlowCommission);
        } catch (Exception e) {
            msg = "保存不成功！";
        }

        return URLEncoder.encode(msg);
    }

    /**
     * 通过id获取记录
     * @param workFlowCommissionId id
     * @return workFlowCommission
     */
    @ResponseBody
    @RequestMapping("/getWorkFlowCommission")
    public Object getWorkFlowCommission(String workFlowCommissionId) {
        WorkFlowCommission workFlowCommission = new WorkFlowCommission();
        if (StringUtils.isNotBlank(workFlowCommissionId))
            workFlowCommission = workFlowCommissionService.getWorkFlowCommission(workFlowCommissionId);
        return workFlowCommission;
    }

    /**
     * 根据id进行删除
     * @param ids 记录id
     * @return map
     */
    @ResponseBody
    @RequestMapping(value = "del")
    public HashMap del(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        workFlowCommissionService.delWorkFlowCommission(id);
                } else
                    workFlowCommissionService.delWorkFlowCommission(ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }


}
