package com.gtis.portal.web;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.service.server.BdcSlbhService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.Page;
import com.gtis.common.util.ByteObjectAccess;
import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.entity.*;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.FcNodeService;
import com.gtis.portal.service.LogService;
import com.gtis.portal.service.TaskBeforeTurnValidationService;
import com.gtis.portal.service.TaskCenterService;
import com.gtis.portal.service.impl.EnabledTurnStatusServiceContext;
import com.gtis.portal.service.server.*;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.ReadXmlProps;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.*;

/**
 * 任务中心
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/taskCenter")
public class TaskCenterController {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysAuthorService sysAuthorService;
    @Autowired
    SysMenuService sysMenuService;
    @Autowired
    SysWorkFlowPostService sysWorkFlowPostService;
    @Autowired
    NodeService nodeService;
    @Autowired
    BdcSlbhService bdcSlbhService;
    @Autowired
    TaskCenterService taskCenterService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    FcNodeService fcNodeService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    LogService logService;
    @Autowired
    GjsqlxService gjsqlxService;
    @Autowired
    EnabledTurnStatusServiceContext enabledTurnStatusServiceContext;
    @Autowired
    BdcJyhtService bdcJyhtService;
    @Autowired
    WorkFlowCommissionService workFlowCommissionService;

    @RequestMapping("index")
    public String taskCenter(Model model, @RequestParam(value = "rid", required = false) String rid) throws Exception {
        String controlOrgan = AppConfig.getProperty("control.organ.list");
        if (StringUtils.isBlank(rid))
            rid = "";
        model.addAttribute("rid", rid);
        if (StringUtils.isNotBlank(rid) && rid.startsWith("r:")) {
            rid = rid.replace("r:", "");
        }
        UserInfo userInfo = SessionUtil.getCurrentUser();

        List<PfWorkFlowDefineVo> lstWorkFlowDefine;

        if (userInfo.isAdmin() || StringUtils.isBlank(rid))
            lstWorkFlowDefine = sysWorkFlowDefineService.getWorkFlowDefineList();
        else
            lstWorkFlowDefine = sysWorkFlowDefineService.getWorkFlowDefineListByRole(userInfo.getRoleIds(), rid, null);
        Map<String, List<PfWorkFlowDefineVo>> mapWorkFlowDefine = Maps.newLinkedHashMap();
        for (PfWorkFlowDefineVo wfd : lstWorkFlowDefine) {
            String businessName = wfd.getBusinessVo().getBusinessName();
            String groupId = wfd.getGroupId();
            String categoryName = businessName;
            String createUrl = wfd.getCreateUrl() == null ? "" : wfd.getCreateUrl();
            wfd.setCreateUrl(AppConfig.getPlaceholderValue(createUrl));
            if (StringUtils.isNotBlank(groupId))
                categoryName = wfd.getResourceGroupVo().getGroupName();
            if (mapWorkFlowDefine.get(categoryName) != null) {
                mapWorkFlowDefine.get(categoryName).add(wfd);
            } else {
                List<PfWorkFlowDefineVo> wfdList = Lists.newArrayList();
                wfdList.add(wfd);
                mapWorkFlowDefine.put(categoryName, wfdList);
            }
        }
        model.addAttribute("workFlowDefineMap", mapWorkFlowDefine);
        model.addAttribute("workFlowDefineJson", JSON.toJSONString(lstWorkFlowDefine));
        SplitParamImpl splitParam1 = new SplitParamImpl();
        splitParam1.setQueryString("getTaskList");
        HashMap mapParam = Maps.newHashMap();
        mapParam.put("userIds", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());
        if (StringUtils.isNotBlank(controlOrgan)) {
            //获取当前人员所在部门
            List<PfOrganVo> currentOrganList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
            if (CollectionUtils.isNotEmpty(currentOrganList)) {
                for (PfOrganVo pfOrganVo : currentOrganList) {
                    if (controlOrgan.contains(pfOrganVo.getOrganId())) {
                        mapParam.put("ORGAN", pfOrganVo.getOrganId());
                        mapParam.put("CREATE_ORGAN", pfOrganVo.getOrganId());//创建人也要为当前人员所在的部门
                    }
                }
            }
        }
        //持件配置，按持件时间增序排列待办任务
        if (AppConfig.getBooleanProperty("cj.setting.confirm")) {
            mapParam.put("CYSJ_ORDER","asc");
            //mapParam.put("ORDER_CYR",SessionUtil.getCurrentUser().getUsername());
            //为判断待办任务中该任务是否为当前用户的第一个持件项目，获取待办任务中当前用户持件人的任务
            HashMap cjMapParam = Maps.newHashMap(mapParam);
            cjMapParam.put("CYR",SessionUtil.getCurrentUser().getUsername());
            SplitParamImpl cjSplitParam = splitParam1;
            cjSplitParam.setQueryParam(cjMapParam);
            model.addAttribute("cjrTaskList",ByteObjectAccess.objectToString(cjSplitParam));
        }

        //某个用户名下的件按照登记类型区分由不同的用户代办功能
        if (AppConfig.getBooleanProperty("taskList.commission.enable")) {
            List<WorkFlowCommission> commissionList = workFlowCommissionService.getWorkFlowCommissionByAgentId(SessionUtil.getCurrentUserId());
            if(CollectionUtils.isNotEmpty(commissionList)) {
                List commissionQueryList = Lists.newArrayList();
                for (WorkFlowCommission commission : commissionList) {
                    String principalId = commission.getPrincipalId();
                    String workFlowDefinitionId = commission.getWorkFlowId();
                    Map map = Maps.newHashMap();
                    map.put("principalId",principalId);
                    map.put("workFlowDefinitionId",workFlowDefinitionId);
                    commissionQueryList.add(map);
                }
                mapParam.put("commissionQueryList",commissionQueryList);
            }
        }

        splitParam1.setQueryParam(mapParam);
        model.addAttribute("taskList", ByteObjectAccess.objectToString(splitParam1));
        //提醒铃声
        boolean remindSupport = false;
        String remindSupportUserId = AppConfig.getProperty("remindBell.support.userId");
        if (StringUtils.isNotBlank(remindSupportUserId)) {
            String[] userIds = remindSupportUserId.split(",");
            for (int i = 0; i < userIds.length; i++) {
                if (StringUtils.equals(SessionUtil.getCurrentUserId(), userIds[i])) {
                    remindSupport = true;
                }
            }
        }

        splitParam1.setQueryString("getTaskOverList");
        model.addAttribute("taskOverList", ByteObjectAccess.objectToString(splitParam1));
        SplitParamImpl splitParam2 = new SplitParamImpl();
        HashMap mapParam1 = Maps.newHashMap();
//        mapParam1.put("USER_ID", SessionUtil.getCurrentUserId());
        //是否显示按照个人显示项目列表
        boolean personalProjectDisplay = taskCenterService.handleProjectListFilterUserid(SessionUtil.getCurrentUser());
/*
        if (StringUtils.isNotBlank(controlOrgan)) {
            //获取当前人员所在部门
            List<PfOrganVo> currentOrganList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
            if (CollectionUtils.isNotEmpty(currentOrganList)) {
                for (PfOrganVo pfOrganVo : currentOrganList) {
                    if (controlOrgan.contains(pfOrganVo.getOrganId())) {
                        mapParam1.put("ORGAN", pfOrganVo.getOrganId());

                    }
                }
            }
        }
*/
        if (personalProjectDisplay)
            mapParam1.put("userIds", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());

        splitParam2.setQueryString("getProjectList");
        //行政代码过滤
        if (AppConfig.getBooleanProperty("projectlist.filter.xzqdm", true)) {
            String userDwdm = sysUserService.getRegionCodeByUserId(SessionUtil.getCurrentUserId());
            if (StringUtils.isNotBlank(userDwdm)) {
                while (StringUtils.isNotBlank(userDwdm) && userDwdm.endsWith("0")) {
                    userDwdm = userDwdm.substring(0, userDwdm.length() - 1);
                }
                mapParam1.put("regionCode", userDwdm + "%");
            }
        }
        splitParam2.setQueryParam(mapParam1);
        model.addAttribute("projectList", ByteObjectAccess.objectToString(splitParam2));


        model.addAttribute("currentDate", CommonUtil.getCurrStrDate());
        List<PfBusinessVo> businessVoList = sysWorkFlowDefineService.getBusinessList();
        model.addAttribute("businessList", businessVoList != null ? businessVoList : Lists.newArrayList());
        //显示超期任务
        SplitParamImpl splitParam3 = new SplitParamImpl();
        splitParam3.setQueryString("getTaskList");
        HashMap mapParam2 = Maps.newHashMap();
        mapParam2.put("userIds", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());
        mapParam2.put("TASK_STATE", "1");
        //不计算超期的节点
        String noComputeActivityNames = AppConfig.getProperty("overTime.noCompute.activityNames");
        if (StringUtils.isNotBlank(noComputeActivityNames)) {
            String[] activityNameArray = noComputeActivityNames.split(",");
            String activityNames = null;
            for (String activityName : activityNameArray) {
                if (StringUtils.isBlank(activityNames))
                    activityNames = "'" + activityName + "'";
                else
                    activityNames += ",'" + activityName + "'";
            }
            mapParam2.put("NOT_IN_ACTIVITY_NAMES", activityNames);
        }
        if (StringUtils.isNotBlank(controlOrgan)) {
            //获取当前人员所在部门
            List<PfOrganVo> currentOrganList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
            if (CollectionUtils.isNotEmpty(currentOrganList)) {
                for (PfOrganVo pfOrganVo : currentOrganList) {
                    if (controlOrgan.contains(pfOrganVo.getOrganId())) {
                        mapParam2.put("ORGAN", pfOrganVo.getOrganId());

                    }
                }
            }
        }
        splitParam3.setQueryParam(mapParam2);
        model.addAttribute("overTimeTaskList", ByteObjectAccess.objectToString(splitParam3));

        //个人项目列表
        SplitParamImpl splitParam4 = new SplitParamImpl();
        boolean performerProjectEnable = AppConfig.getBooleanProperty("personalProjectList.view.performer.project.enable", false);
        if (performerProjectEnable) {
            HashMap mapParam4 = Maps.newHashMap();
            mapParam4.put("USER_ID", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserId());

            splitParam4.setQueryString("getProjectListByPerformer");
            //行政代码过滤
            if (AppConfig.getBooleanProperty("projectlist.filter.xzqdm", true)) {
                String userDwdm = SessionUtil.getCurrentUser().getRegionCode();
                if (StringUtils.isNotBlank(userDwdm)) {
                    while (StringUtils.isNotBlank(userDwdm) && userDwdm.endsWith("0")) {
                        userDwdm = userDwdm.substring(0, userDwdm.length() - 1);
                    }
                    mapParam4.put("regionCode", userDwdm + "%");
                }
            }
            if (StringUtils.isNotBlank(controlOrgan)) {
                //获取当前人员所在部门
                List<PfOrganVo> currentOrganList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
                if (CollectionUtils.isNotEmpty(currentOrganList)) {
                    for (PfOrganVo pfOrganVo : currentOrganList) {
                        if (controlOrgan.contains(pfOrganVo.getOrganId())) {
                            mapParam4.put("ORGAN", pfOrganVo.getOrganId());

                        }
                    }
                }
            }
            splitParam4.setQueryParam(mapParam4);
        } else {

            HashMap mapParam4 = Maps.newHashMap();
            mapParam4.put("userIds", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());

            splitParam4.setQueryString("getProjectList");
            //行政代码过滤
            if (AppConfig.getBooleanProperty("projectlist.filter.xzqdm", true)) {
                String userDwdm = SessionUtil.getCurrentUser().getRegionCode();
                if (StringUtils.isNotBlank(userDwdm)) {
                    while (StringUtils.isNotBlank(userDwdm) && userDwdm.endsWith("0")) {
                        userDwdm = userDwdm.substring(0, userDwdm.length() - 1);
                    }
                    mapParam4.put("regionCode", userDwdm + "%");
                }
            }
            if (StringUtils.isNotBlank(controlOrgan)) {
                //获取当前人员所在部门
                List<PfOrganVo> currentOrganList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
                if (CollectionUtils.isNotEmpty(currentOrganList)) {
                    for (PfOrganVo pfOrganVo : currentOrganList) {
                        if (controlOrgan.contains(pfOrganVo.getOrganId())) {
                            mapParam4.put("ORGAN", pfOrganVo.getOrganId());

                        }
                    }
                }
            }
            splitParam4.setQueryParam(mapParam4);
        }

        model.addAttribute("personalProjectList", ByteObjectAccess.objectToString(splitParam4));
        //项目转发列表
        SplitParamImpl splitParam5 = new SplitParamImpl();
        splitParam5.setQueryString("getTaskList");
        HashMap mapParam5 = Maps.newHashMap();
        mapParam5.put("userIds", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());
        if (StringUtils.isNotBlank(controlOrgan)) {
            //获取当前人员所在部门
            List<PfOrganVo> currentOrganList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
            if (CollectionUtils.isNotEmpty(currentOrganList)) {
                for (PfOrganVo pfOrganVo : currentOrganList) {
                    if (controlOrgan.contains(pfOrganVo.getOrganId())) {
                        mapParam5.put("ORGAN", pfOrganVo.getOrganId());

                    }
                }
            }
        }
        splitParam5.setQueryParam(mapParam5);
        model.addAttribute("turnTaskList", ByteObjectAccess.objectToString(splitParam5));
        //显示挂起任务
        SplitParamImpl splitParam6 = new SplitParamImpl();
        splitParam6.setQueryString("getTaskList");
        HashMap mapParam6 = Maps.newHashMap();
        mapParam6.put("userIds", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());
        mapParam6.put("STATE", "3");
        if (StringUtils.isNotBlank(controlOrgan)) {
            //获取当前人员所在部门
            List<PfOrganVo> currentOrganList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
            if (CollectionUtils.isNotEmpty(currentOrganList)) {
                for (PfOrganVo pfOrganVo : currentOrganList) {
                    if (controlOrgan.contains(pfOrganVo.getOrganId())) {
                        mapParam6.put("ORGAN", pfOrganVo.getOrganId());

                    }
                }
            }
        }
        splitParam6.setQueryParam(mapParam6);
        model.addAttribute("postTaskList", ByteObjectAccess.objectToString(splitParam6));

        boolean hasDel = false;
        boolean hasProjectDel = false;
        boolean hasTaskDel = false;
        boolean hasTurnBack = false;
        boolean hasRestart = false;
        boolean hasPriority = false;
        boolean hasPost = false;
        boolean hasUnpost = false;
        boolean hasTurnTask = false;
        boolean hasUsed = false;
        boolean hasNoUsed = false;
        boolean hasDutyPaid = false;
        boolean hasPublic = false;
        boolean hasLocked = false;
        boolean hasUnlocked = false;
        if (SessionUtil.getCurrentUser().isAdmin()) {
            hasDel = true;
            hasRestart = true;
            hasTurnBack = true;
            hasPriority = true;
            hasPost = true;
            hasUnpost = true;
            hasTurnTask = true;
            hasUsed = true;
            hasNoUsed = true;
            hasDutyPaid = true;
            hasPublic = true;
            hasLocked = true;
            hasUnlocked = true;
        } else {
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List<PfPartitionInfoVo> lstfPartitions = sysAuthorService.getSystemResrouceFunAuthorList(roles, rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().equals("删除")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("del")) {
                        hasDel = true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("重办")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("restart")) {
                        hasRestart = true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("退回")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("resTurnBack")) {
                        hasTurnBack = true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("优先")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("priority")) {
                        hasPriority = true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("公告")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("priority")) {
                        hasPublic = true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().equals("待办任务删除")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("taskDel")) {
                        hasTaskDel = true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().equals("项目列表删除")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("projectDel")) {
                        hasProjectDel = true;
                        break;
                    }
                }
                boolean hasPostAndTurn = true;
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().equals("挂起")
                    ) {
                        hasPost = true;
                        hasPostAndTurn = false;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().equals("解挂")
                    ) {
                        hasUnpost = true;
                        hasPostAndTurn = false;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().equals("转发")
                    ) {
                        hasTurnTask = true;
                        hasPostAndTurn = false;
                        break;
                    }
                }
                if (hasPostAndTurn) {
                    hasPost = true;
                    hasUnpost = true;
                    hasTurnTask = true;
                }

                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().equals("占用")
                    ) {
                        hasUsed = true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().equals("取消占用")
                    ) {
                        hasNoUsed = true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().equals("一键完税")
                    ) {
                        hasDutyPaid = true;
                        break;
                    }
                }

                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("锁定")
                    ) {
                        hasLocked = true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (partitionInfoVo.getElementName().endsWith("解锁")
                    ) {
                        hasUnlocked = true;

                        break;
                    }
                }
            }

            List<String> listWdids = sysMenuService.getProjectWorkFlowDefineIds(roles);
            StringBuffer bufferWdids = new StringBuffer();
            if (listWdids != null) {
                for (int index = 0; index < listWdids.size(); index++) {
                    if (index > 0)
                        bufferWdids.append(",");
                    bufferWdids.append("'" + listWdids.get(index) + "'");
                }
            }
            model.addAttribute("excludeWdids", bufferWdids.toString());
        }

        //如果配置删除权限按照删除权限控制，如果没有配置按照之前逻辑
        String delTaskBtnDisplayRole = AppConfig.getProperty("task.list.del.role");
        if (StringUtils.isNotBlank(delTaskBtnDisplayRole)) {
            hasDel = taskCenterService.delTaskBtnDisplay(SessionUtil.getCurrentUser());
            hasTaskDel = false;
            hasProjectDel = false;
        }
        List<PfOrganVo> pfOrganVoList = sysUserService.getAllOrganList();
        List<PfUserVo> pfUserVoList = sysUserService.getAllUsers();
        //获取过滤按钮信息
        List<Map> tasklistFilterList = ReadXmlProps.getTasklistFilterList();
        model.addAttribute("taskOverListDisplayed", taskCenterService.handleTaskOverListDisplay(SessionUtil.getCurrentUser()));
        model.addAttribute("projectListDisplayed", taskCenterService.handleProjectListDisplay(SessionUtil.getCurrentUser()));
        model.addAttribute("overTimeListDisplayed", taskCenterService.handleOverTimeTaskListDisplay(SessionUtil.getCurrentUser()));
        model.addAttribute("personalProjectListDisplayed", taskCenterService.handlePersonalProjectListDisplay(SessionUtil.getCurrentUser()));
        model.addAttribute("batchTurnBtnDListDisplayed", taskCenterService.batchTurnTaskBtnDisplay(SessionUtil.getCurrentUser()));
        model.addAttribute("turnTaskListDisplayed", taskCenterService.handleTurnTaskListDisplay(SessionUtil.getCurrentUser()));
        model.addAttribute("postTaskListDisplayed", taskCenterService.handlePostTaskListDisplay(SessionUtil.getCurrentUser()));
        model.addAttribute("hasDel", hasDel);
        model.addAttribute("hasTurnBack", hasTurnBack);
        model.addAttribute("hasRestart", hasRestart);
        model.addAttribute("hasPriority", hasPriority);
        model.addAttribute("hasPublic", hasPublic);
        model.addAttribute("splitStr", Constants.SPLIT_STR);
        model.addAttribute("portalVersion", AppConfig.getProperty("portal.version"));
        model.addAttribute("showBusinessName", AppConfig.getBooleanProperty("workflowName.show.businessName", false));
        model.addAttribute("showUploadFile", AppConfig.getBooleanProperty("task.taskList.showUploadFile", true));
        model.addAttribute("wrapEnable", AppConfig.getBooleanProperty("task.list.wrap.enable", true));
        model.addAttribute("stateShowBegin", AppConfig.getBooleanProperty("task.state.showBegin.enable", false));
        model.addAttribute("showFilterBut", AppConfig.getBooleanProperty("show.tasklist.filter.button.enable", false));
        model.addAttribute("pfOrganVoList", pfOrganVoList);
        model.addAttribute("pfUserVoList", pfUserVoList);
        model.addAttribute("hasTaskDel", hasTaskDel);
        model.addAttribute("hasProjectDel", hasProjectDel);
        model.addAttribute("overTimeEnble", AppConfig.getProperty("task.overTime.enable"));
        model.addAttribute("showSsxzEnable", AppConfig.getProperty("task.list.show.ssxz.enable"));
        model.addAttribute("noComputeActivityNames", noComputeActivityNames);
        model.addAttribute("hasPost", hasPost);
        model.addAttribute("hasUnpost", hasUnpost);
        model.addAttribute("hasTurnTask", hasTurnTask);
        model.addAttribute("hasUsed", hasUsed);
        model.addAttribute("hasNoUsed", hasNoUsed);
        model.addAttribute("hasLocked", hasLocked);
        model.addAttribute("hasUnlocked", hasUnlocked);
        model.addAttribute("tasklistFilterList", tasklistFilterList);
        model.addAttribute("userid", SessionUtil.getCurrentUserId());
        model.addAttribute("hasDutyPaid", hasDutyPaid);
        model.addAttribute("projectlistPostEnable", AppConfig.getProperty("projectlist.post.enable"));
        model.addAttribute("bdcdjUrl", AppConfig.getProperty("bdcdj.url"));
        model.addAttribute("remindSupport", remindSupport);
        model.addAttribute("shztShowEnable", AppConfig.getProperty("shzt.show.enable"));
        model.addAttribute("cjSettingConfirm",AppConfig.getBooleanProperty("cj.setting.confirm"));
        model.addAttribute("userName",SessionUtil.getCurrentUser().getUsername());

        //哈尔滨特殊版本使用,方法内有版本号验证
        gjsqlxService.subjoinHrbModel(model, lstWorkFlowDefine);

        return "task-center";
    }

    /**
     * 获取所有工作流定义信息
     *
     * @param wdid
     * @return
     */
    @RequestMapping("workflowDefinition")
    @ResponseBody
    public Object getWorkflowDefinition(@RequestParam String wdid) {
        Map workflowDefinitionMap = Maps.newHashMap();
        PfWorkFlowDefineVo pfWorkFlowDefineVo = null;
        if (StringUtils.isNotBlank(wdid)) {
            pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        }
        workflowDefinitionMap.put("workflowDefine", pfWorkFlowDefineVo);
        workflowDefinitionMap.put("username", SessionUtil.getCurrentUser().getUsername());
        workflowDefinitionMap.put("createTime", CommonUtil.getCurrStrDate());
        return workflowDefinitionMap;
    }

    /**
     * 创建任务
     *
     * @param wdid
     * @return
     * @throws Exception
     */
    @RequestMapping("createTask")
    @ResponseBody
    public Object createTask(HttpServletRequest request, String wdid) throws Exception {
        Map result = Maps.newHashMap();
        result.put("success", false);
        if (StringUtils.isNotBlank(wdid)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
            String userId = SessionUtil.getCurrentUserId();
            UserInfo userInfo = SessionUtil.getCurrentUser();
            String proId = UUIDGenerator.generate();
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = new PfWorkFlowInstanceVo();

            //zdd 2016-07-14  统一调用common包获取编号 防止重复
            String xmbh = "";
            if (AppConfig.getBooleanProperty("xmbh.useMode.order", false)) {
                BdcXm bdcXm = new BdcXm();
                bdcXm.setWiid(proId);
                bdcXm.setProid(proId);
                bdcXm.setCjsj(new Date());
                if (userInfo != null)
                    bdcXm.setDwdm(userInfo.getRegionCode());
                xmbh = bdcSlbhService.generateBdcXmSlbh(bdcXm);
            } else
                xmbh = cn.gtmap.estateplat.utils.CommonUtil.getCurrentTimeMillisId();
            StringBuilder workflowInstanceName = new StringBuilder("");
            workflowInstanceName.append(xmbh);
            pfWorkFlowInstanceVo.setWorkflowIntanceName(workflowInstanceName.toString());
            pfWorkFlowInstanceVo.setWorkflowDefinitionId(wdid);
            pfWorkFlowInstanceVo.setCreateTime(Calendar.getInstance().getTime());
            pfWorkFlowInstanceVo.setTimeLimit(pfWorkFlowDefineVo.getTimeLimit());
            pfWorkFlowInstanceVo.setPriority("1");
            pfWorkFlowInstanceVo.setCreateUser(SessionUtil.getCurrentUserId());
            pfWorkFlowInstanceVo.setWorkflowIntanceId(proId);
            pfWorkFlowInstanceVo.setProId(proId);
            pfWorkFlowInstanceVo.setRemark(xmbh + Constants.SPLIT_STR + Constants.SPLIT_STR + Constants.SPLIT_STR + Constants.SPLIT_STR + Constants.SPLIT_STR);
            WorkFlowInfo infoObj = workFlowCoreService.createWorkFlowInstance(
                    pfWorkFlowInstanceVo, userId);
            String taskId = null;
            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                if (taskVo.getUserVo().getUserId().equals(userId)) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            if (StringUtils.isBlank(taskId)) {
                for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            //保存日志
            logService.saveCreateTaskLog(pfWorkFlowInstanceVo.getWorkflowIntanceId(), taskId, pfWorkFlowInstanceVo.getCreateUser(), pfWorkFlowInstanceVo, request);
            result.put("success", true);
            result.put("taskId", taskId);
            result.put("wfid", proId);
            result.put("proid", pfWorkFlowInstanceVo.getProId());
            result.put("userid", pfWorkFlowInstanceVo.getCreateUser());
        }

        return result;
    }

    @RequestMapping("getWorkflowDefinitions")
    @ResponseBody
    public Object getWorkflowDefinitions(String businessId) {
        List<PfWorkFlowDefineVo> workFlowDefineVoList = null;
        if (StringUtils.isBlank(businessId))
            workFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();
        else
            workFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineByBusiness(businessId);
        return workFlowDefineVoList;
    }

    @RequestMapping("taskhandle")
    public String taskhandle(Model model, @RequestParam String taskid) throws Exception {
        if (StringUtils.isNotBlank(taskid)) {
        }
        return "";
    }

    @RequestMapping("getLockReason")
    @ResponseBody
    public String getLockReason(@RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "wiid", required = false) String wiid) {
        String reason = "";
        String userId = "";
        String postDate = "";
        if (StringUtils.isNotBlank(taskid)) {
            PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
            if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = sysTaskService.getActivity(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId())) {
                    wiid = pfActivityVo.getWorkflowInstanceId();
                }
            }
        }
        if (StringUtils.isNotBlank(wiid)) {
            List<PfWorkFlowPostVo> pfWorkFlowPostVoList = sysWorkFlowPostService.getPostByInstance(wiid);
            if (pfWorkFlowPostVoList != null && pfWorkFlowPostVoList.size() > 0) {
                for (PfWorkFlowPostVo pfWorkFlowPostVo : pfWorkFlowPostVoList) {
                    if (pfWorkFlowPostVo.getUnPostDate() == null) {
                        reason = pfWorkFlowPostVo.getPostReason();
                        userId = pfWorkFlowPostVo.getPostUser();
                        if (pfWorkFlowPostVo.getPostDate() != null)
                            postDate = CalendarUtil.formateToStrChinaYMDDate(pfWorkFlowPostVo.getPostDate());
                        break;
                    }
                }
            }
        }
        if (StringUtils.isNotBlank(reason)) {
            try {
                if (StringUtils.isNotBlank(userId))
                    reason += "，挂起人：" + sysUserService.getUserVo(userId).getUserName();
                if (StringUtils.isNotBlank(postDate))
                    reason += "，挂起时间：" + postDate;
                reason = URLEncoder.encode(reason, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return reason;
    }

    @RequestMapping("checkUploadFile")
    @ResponseBody
    public Object checkUploadFile(@RequestParam(value = "wiids", required = false) String wiids) {
        String fileNumStr = AppConfig.getProperty("task.taskList.showUploadFile.num");
        int fileNum = 0;
        if (org.apache.commons.lang3.StringUtils.isNotBlank(fileNumStr)) {
            try {
                fileNum = Integer.parseInt(fileNumStr);
            } catch (Exception e) {

            }
        }
        List<Map> mapList = new ArrayList<Map>();
        if (StringUtils.isNotBlank(wiids)) {
            for (String wiid : wiids.split(",")) {
                String uploadFile = "0";
                PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
                if (pfWorkFlowInstanceVo != null && StringUtils.isNotBlank(pfWorkFlowInstanceVo.getProId())) {
                    FcNode node = fcNodeService.getNodeByNodeName(pfWorkFlowInstanceVo.getProId());
                    if (node != null) {
                        List<String> nodeIds = Lists.newArrayList();
                        nodeIds.add(node.getId() + "");
                        List<FcNode> childNodeList = fcNodeService.getChildNodesInParentIds(nodeIds);
                        if (CollectionUtils.isNotEmpty(childNodeList)) {

                            if (fileNum == 0) {
                                List<String> childrensParentIds = Lists.newArrayList();
                                //未配置默认数目
                                for (FcNode childNode : childNodeList) {
                                    if (org.apache.commons.lang3.StringUtils.equals(childNode.getNodeType(), "1")) {
                                        uploadFile = "1";
                                        break;
                                    } else {
                                        if (!childrensParentIds.contains(childNode.getId()))
                                            childrensParentIds.add(childNode.getId());
                                    }
                                }
                                //假设只嵌套一层文件夹
                                if (CollectionUtils.isNotEmpty(childrensParentIds)) {
                                    List<FcNode> childChildNodeList = fcNodeService.getChildNodesInParentIds(childrensParentIds);
                                    if (CollectionUtils.isNotEmpty(childChildNodeList)) {
                                        for (FcNode childChildNode : childChildNodeList) {
                                            if (org.apache.commons.lang3.StringUtils.equals(childChildNode.getNodeType(), "1")) {
                                                uploadFile = "1";
                                                break;
                                            }
                                        }
                                    }
                                }
                            } else {
                                List<String> childrensParentIds = Lists.newArrayList();
                                //大于默认上传数目才显示上传文件图标
                                int uploadFileNum = 0;
                                for (FcNode childNode : childNodeList) {
                                    if (org.apache.commons.lang3.StringUtils.equals(childNode.getNodeType(), "1")) {
                                        uploadFileNum++;
                                    } else {
                                        if (!childrensParentIds.contains(childNode.getId()))
                                            childrensParentIds.add(childNode.getId());
                                    }
                                }
                                //假设只嵌套一层文件夹
                                if (CollectionUtils.isNotEmpty(childrensParentIds)) {
                                    List<FcNode> childChildNodeList = fcNodeService.getChildNodesInParentIds(childrensParentIds);
                                    if (CollectionUtils.isNotEmpty(childChildNodeList)) {
                                        for (FcNode childChildNode : childChildNodeList) {
                                            if (org.apache.commons.lang3.StringUtils.equals(childChildNode.getNodeType(), "1")) {
                                                uploadFileNum++;
                                            }
                                        }
                                    }
                                }
                                if (uploadFileNum > fileNum)
                                    uploadFile = "1";
                            }
                        }
                    }
                }
                HashMap map = Maps.newHashMap();
                map.put("wiid", wiid);
                map.put("UPLOADFILE", uploadFile);
                mapList.add(map);
            }

        }

        return mapList;
    }

    @RequestMapping("getBusinessName")
    @ResponseBody
    public Object getBusinessName(String businessId) {
        PfBusinessVo pfBusinessVo = null;
        if (StringUtils.isNotBlank(businessId))
            pfBusinessVo = sysWorkFlowDefineService.getBusiness(businessId);
        return pfBusinessVo;
    }

    @RequestMapping("getWorkflowActivitys")
    @ResponseBody
    public Object getWorkflowActivitys(String wfDefintionId) {
        List<PfActivityVo> pfActivityVoList = null;
        if (StringUtils.isNotBlank(wfDefintionId)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wfDefintionId);
            if (pfWorkFlowDefineVo != null) {
                WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(pfWorkFlowDefineVo);
                if (xmlDao != null)
                    pfActivityVoList = xmlDao.getPfActivityVoList();
            }
        }
        return pfActivityVoList;
    }


    @RequestMapping("updatePriority")
    @ResponseBody
    public Object updatePriority(@RequestParam(value = "wiids", required = false) String wiids, @RequestParam(value = "priority", required = false) String priority) throws Exception {
        String msg = "ok";
        if (StringUtils.isNotBlank(wiids) && StringUtils.isNotBlank(priority)) {
            try {
                for (String wiid : wiids.split(",")) {
                    sysWorkFlowInstanceService.updateWorkFlowIntancePriority(wiid, priority);
                }
            } catch (Exception e) {
                msg = "error";
            }
        }

        return msg;
    }

    @RequestMapping("checkUpPostUser")
    @ResponseBody
    public String checkUpPostUser(@RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "wiid", required = false) String wiid) {
        String checkMsg = "error";
        String userid = SessionUtil.getCurrentUserId();
        String unPostByUser = AppConfig.getProperty("unpost.user.enable");
        if (StringUtils.equals(unPostByUser, "true")) {
            if (StringUtils.isNotBlank(taskid)) {
                List<PfWorkFlowPostVo> pfWorkFlowPostVoList = sysWorkFlowPostService.getPostByTask(taskid);
                if (pfWorkFlowPostVoList != null && pfWorkFlowPostVoList.size() > 0) {
                    for (PfWorkFlowPostVo pfWorkFlowPostVo : pfWorkFlowPostVoList) {
                        if (pfWorkFlowPostVo.getUnPostDate() == null) {
                            if (org.apache.commons.lang3.StringUtils.equals(pfWorkFlowPostVo.getPostUser(), userid)) {
                                checkMsg = "ok";
                                break;
                            }
                        }
                    }
                }
            }
            if (StringUtils.isNotBlank(wiid)) {
                List<PfWorkFlowPostVo> pfWorkFlowPostVoList = sysWorkFlowPostService.getPostByInstance(wiid);
                if (pfWorkFlowPostVoList != null && pfWorkFlowPostVoList.size() > 0) {
                    for (PfWorkFlowPostVo pfWorkFlowPostVo : pfWorkFlowPostVoList) {
                        if (pfWorkFlowPostVo.getUnPostDate() == null) {
                            if (org.apache.commons.lang3.StringUtils.equals(pfWorkFlowPostVo.getPostUser(), userid)) {
                                checkMsg = "ok";
                                break;
                            }
                        }
                    }
                }
            }
        } else
            checkMsg = "ok";

        return checkMsg;
    }

    @RequestMapping("getUsersByOrganId")
    @ResponseBody
    public Object getUsersByOrganId(String organId) {
        List<PfUserVo> pfUserVoList = null;
        if (StringUtils.isNotBlank(organId))
            pfUserVoList = sysUserService.getUserListByOragn(organId);

        return pfUserVoList;
    }

    /**
     * 获取待办任务、已办任务、项目列表显示房产、国土、不动产超期情况
     *
     * @param wiids
     * @return
     */
    @RequestMapping("getTaskOverTimeState")
    @ResponseBody
    public Object getTaskOverTimeState(String wiids) {
        List<Map> mapList = new ArrayList<Map>();
        if (StringUtils.isNotBlank(wiids)) {
            for (String wiid : wiids.split(",")) {
                Map map = taskCenterService.getTaskOverTimeState(wiid);
                if (map != null)
                    mapList.add(map);
            }
        }
        return mapList;
    }

    /**
     * 获取待办任务、已办任务、项目列表显示项目来源
     *
     * @param wiids
     * @return
     */
    @RequestMapping("getXmly")
    @ResponseBody
    public Object getXmly(String wiids) {
        List<Map> mapList = new ArrayList<Map>();
        if (StringUtils.isNotBlank(wiids)) {
            for (String wiid : wiids.split(",")) {
                Map map = taskCenterService.getXmly(wiid);
                if (map != null)
                    mapList.add(map);
            }
        }
        return mapList;
    }

    /**
     * 获取退回状态
     *
     * @param wiid
     * @return
     */
    @RequestMapping("getBackState")
    @ResponseBody
    public Object getBackState(String wiid) {
        Map map = Maps.newHashMap();
        String isBack = "0";
        if (StringUtils.isNotBlank(wiid)) {
            if (StringUtils.isNotBlank(wiid)) {
                List<PfActivityVo> activityList = sysTaskService.getWorkFlowInstanceAllActivityList(wiid);
                if (CollectionUtils.isNotEmpty(activityList)) {
                    for (int i = activityList.size() - 1; i > -1; i--) {
                        PfActivityVo pfActivityVo = activityList.get(i);
                        if (pfActivityVo.isBackState()) {
                            isBack = "1";
                            break;
                        }
                    }
                }
            }

        }
        map.put("ISBACK", isBack);
        return map;
    }
//    /**
//     * 获取地税完税状态
//     * @param wiid
//     * @return
//     */
//    @RequestMapping("getTaxState")
//    @ResponseBody
//    public String getTaxState(String wiid) {
//        String taxState="";
//        List<PfUserVo> pfUserVoList = null;
//        if (StringUtils.isNotBlank(organId))
//            pfUserVoList = sysUserService.getUserListByOragn(organId);
//
//        return pfUserVoList;
//    }


    @RequestMapping("checkDoTask")
    @ResponseBody
    public String checkDoTask(@RequestParam(value = "wiid", required = false) String wiid) {
        String taskid = "";
        if (StringUtils.isNotBlank(wiid)) {
            String userId = SessionUtil.getCurrentUserId();
            List<PfActivityVo> pfActivityVoList = sysTaskService.getWorkFlowInstanceActivityList(wiid);
            if (CollectionUtils.isNotEmpty(pfActivityVoList)) {

                for (PfActivityVo pfActivityVo : pfActivityVoList) {
                    List<PfTaskVo> taskVoList = sysTaskService.getTaskListByActivity(pfActivityVo.getActivityId());
                    if (CollectionUtils.isNotEmpty(taskVoList)) {
                        for (PfTaskVo pfTaskVo : taskVoList) {
                            if (StringUtils.equals(pfTaskVo.getUserVo().getUserId(), userId)) {
                                taskid = pfTaskVo.getTaskId();
                                break;
                            }
                        }
                    }
                    if (StringUtils.isNotBlank(taskid))
                        break;
                }
            }
        }
        return taskid;
    }

    /**
     * 获取登记信息（东北）
     *
     * @param wiid
     * @return
     */
    @RequestMapping("getDjxx")
    @ResponseBody
    public Object getDjxx(String wiid) {
        Map map = Maps.newHashMap();
        String isSf = "否";
        String fcshzt = "未知";
        String fclzrq = "";
        String islz = "";
        String isWs = "";
        String dyzt = "";
        if (StringUtils.isNotBlank(wiid)) {
            if (StringUtils.isNotBlank(wiid)) {
                List<DbBdcXm> dbBdcXmList = bdcXmService.getDbBdcXmList(wiid);
                //根据编号查询bdc_zs表的dzjdzzt字段，
                List<DbBdcZs> dbBdcZsList = bdcZsService.getDbBdcZsList(dbBdcXmList);
                if (CollectionUtils.isNotEmpty(dbBdcZsList)) {
                    for (DbBdcZs dbBdcZs : dbBdcZsList) {
                        if ("1".equals(dbBdcZs.getDzjdzzt())) {
                            dyzt = "已打证";
                        } else if ("0".equals(dbBdcZs.getDzjdzzt())) {
                            dyzt = "正在打证";
                        } else {
                            dyzt = "未打证";
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(dbBdcXmList)) {
                    for (DbBdcXm dbBdcXm : dbBdcXmList) {
                        if (dbBdcXm != null) {
                            if (StringUtils.isNotBlank(dbBdcXm.getCharge()) && StringUtils.equals(dbBdcXm.getCharge(), "1")) {
                                isSf = "是";
                            }
                            if (StringUtils.isNotBlank(dbBdcXm.getFczt())) {
                                if (StringUtils.equals(dbBdcXm.getFczt(), "2"))
                                    fcshzt = "审核完毕";
                                else if (StringUtils.equals(dbBdcXm.getFczt(), "3"))
                                    fcshzt = "删除";
                                else if (StringUtils.equals(dbBdcXm.getFczt(), "4"))
                                    fcshzt = "附件推送";
                                else if (StringUtils.equals(dbBdcXm.getFczt(), "5"))
                                    fcshzt = "已返卷";
                                else if (StringUtils.equals(dbBdcXm.getFczt(), "6"))
                                    fcshzt = "已入库";
                                else if (StringUtils.equals(dbBdcXm.getFczt(), "1"))
                                    fcshzt = "审核中";
                                else
                                    fcshzt = "未知";
                            }
                            if (StringUtils.isNotBlank(dbBdcXm.getWszt()) && StringUtils.equals(dbBdcXm.getWszt(), "1")) {
                                isWs = "完税";
                            }


                        }
                    }
                }
                islz = bdcZsService.getLzztByWiid(dbBdcXmList);
            }

        }
        map.put("isSf", isSf);
        map.put("fcshzt", fcshzt);
        map.put("fclzrq", fclzrq);
        map.put("islz", islz);
        map.put("isWs", isWs);
        map.put("dyzt", dyzt);
        return map;
    }

    /**
     * 获取所属乡镇
     *
     * @param wiid
     * @return
     */
    @RequestMapping("getSsxz")
    @ResponseBody
    public Object getSsxz(String wiid) {
        Map map = Maps.newHashMap();
        String ssxz = "";

        if (StringUtils.isNotBlank(wiid)) {
            if (StringUtils.isNotBlank(wiid)) {
                List<com.gtis.portal.entity.BdcXm> bdcXmList = bdcXmService.getBdcXmList(wiid);
                if (CollectionUtils.isNotEmpty(bdcXmList)) {
                    for (com.gtis.portal.entity.BdcXm bdcXm : bdcXmList) {
                        if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getSsxz())) {
                            ssxz = bdcXm.getSsxz();
                        }
                    }
                }
            }
        }
        map.put("SSXZ", ssxz);
        return map;
    }

    /**
     * @return java.lang.Object
     * @Param [taskid, wiid, userid]
     * @Author <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @Date 9:01 2019/5/21
     * @Description 判断当前的件是否可转发
     */
    @RequestMapping("enabledTurn")
    @ResponseBody
    public Object enabledTurn(String taskid, String wiid, String userid) {
        if (StringUtils.isNotBlank(taskid)) {
            String[] taskIds = StringUtils.split(taskid, ",");
            if (enabledTurnStatusServiceContext != null && CollectionUtils.isNotEmpty(enabledTurnStatusServiceContext.getTaskBeforeTurnValidationServices())) {
                for (String value : taskIds) {
                    for (TaskBeforeTurnValidationService taskBeforeTurnValidationService : enabledTurnStatusServiceContext.getTaskBeforeTurnValidationServices()) {
                        try {
                            taskBeforeTurnValidationService.validateTask(value, userid);
                        } catch (PortalException e) {
                            return false;
                        }
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }

    /**
     * 获取退回来源
     * @param userId
     * @param taskId
     * @return
     * @throws Exception
     */
    @RequestMapping("getBackSourceTask")
    @ResponseBody
    public Object getBackSourceTask(String userId, String taskId) throws Exception {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(userId) && StringUtils.isNotBlank(taskId)) {
            WorkFlowInfo workFlowTurnBackInfo = workFlowCoreService.getWorkFlowTurnBackInfo(userId, taskId);
            PfTaskVo sourceTask = null;//退回前一个的task
            PfTaskVo historyTask = new PfTaskVo();//历史task

            if (workFlowTurnBackInfo != null) {
                sourceTask = workFlowTurnBackInfo.getSourceTask();
            }
            if (sourceTask != null) {
                //判断当前是退回状态？是则前一个节点为退回节点，否则在historyTask中找到退回状态为true的前一个节点
                if (sourceTask.isBackState()) {
                    if (StringUtils.isNotBlank(sourceTask.getTaskBefore())) {
                        historyTask = sysTaskService.getHistoryTask(sourceTask.getTaskBefore());
                    }
                    if (historyTask != null) {
                        String activityId = historyTask.getActivityId();
                        if (StringUtils.isNotBlank(activityId)) {
                            PfActivityVo activity = sysTaskService.getActivity(activityId);
                            if (activity != null) {
                                resultMap.put("BACK_SOURCETASK", activity.getActivityName());
                                resultMap.put("msg", "success");
                                return resultMap;
                            }
                        }
                    }
                } else {
                    if (StringUtils.isNotBlank(sourceTask.getActivityId())) {
                        PfActivityVo activity = sysTaskService.getActivity(sourceTask.getActivityId());
                        if (activity != null && StringUtils.isNotBlank(activity.getWorkflowInstanceId())) {
                            List<PfTaskVo> historyTaskList = sysTaskService.getHistoryTaskListByInstance(activity.getWorkflowInstanceId());
                            if (CollectionUtils.isNotEmpty(historyTaskList)) {
                                for (int i = 0; i < historyTaskList.size(); i++) {
                                    if (sourceTask != null && StringUtils.isNotBlank(sourceTask.getTaskBefore())) {
                                        historyTask = sysTaskService.getHistoryTask(sourceTask.getTaskBefore());
                                    }
                                    if (historyTask.isBackState()) {
                                        PfTaskVo historyTask1 = sysTaskService.getHistoryTask(historyTask.getTaskBefore());
                                        if (historyTask1 != null) {
                                            String activityId = historyTask1.getActivityId();
                                            if (StringUtils.isNotBlank(activityId)) {
                                                PfActivityVo activity1 = sysTaskService.getActivity(activityId);
                                                if (activity1 != null) {
                                                    resultMap.put("BACK_SOURCETASK", activity1.getActivityName());
                                                    resultMap.put("msg", "success");
                                                    return resultMap;
                                                }
                                            }
                                        }
                                    }
                                    sourceTask = sysTaskService.getHistoryTask(sourceTask.getTaskBefore());
                                }
                            }
                        }
                    }
                }
            }
            resultMap.put("msg", "failure");
        }
        return resultMap;
    }

    /**
     * 获取待办任务、项目列表显示项目交易审核状态信息
     *
     * @param wiid
     * @return
     */
    @RequestMapping("getShzt")
    @ResponseBody
    public Object getShzt(String wiid) {
        Map resultMap = new HashMap();
        Integer shzt=0;
        String shyj="";
        if (StringUtils.isNotBlank(wiid)) {
            List<com.gtis.portal.entity.BdcXm> bdcXmList = bdcXmService.getBdcXmList(wiid);
            if(CollectionUtils.isNotEmpty(bdcXmList)){
                for (com.gtis.portal.entity.BdcXm bdcXm : bdcXmList) {
                    if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getProid())) {
                        List<BdcJyshxx> bdcJyhts = bdcJyhtService.getJyhtList(bdcXm.getProid());
                        if(CollectionUtils.isNotEmpty(bdcJyhts)){
                            for (BdcJyshxx jyht : bdcJyhts) {
                                if(StringUtils.isNotBlank(jyht.getShzt())){
                                    if(StringUtils.equals(jyht.getShzt(),"交易审核中")){
                                        shzt=1;
                                    }else if (StringUtils.equals(jyht.getShzt(),"交易审核通过")){
                                        shzt=2;
                                    }else if (StringUtils.equals(jyht.getShzt(),"交易审核不通过")){
                                        shzt=3;
                                    }
                                    shyj=jyht.getShyj();
                                }
                            }
                        }
                    }
                }
            }
        }
        resultMap.put("shzt",shzt);
        resultMap.put("shyj",shyj);
        return resultMap;
    }
}