package com.gtis.portal.web;

import com.gtis.config.AppConfig;
import com.gtis.config.PropertyPlaceholderHelper;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.model.Menu;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Properties;

/**
 * Created with IntelliJ IDEA.
 * User: jibo
 * Date: 14-4-14
 * Time: 上午10:50
 * To change this template use File | Settings | File Templates.
 */
@Controller
public class SysMenuController {
    @Autowired
    PfMenuService menuService;
    @Autowired
    PfResourceService resourceService;

    @RequestMapping("/getmenu")
    @ResponseBody
    public Menu menu(String systemId) {
        String defaultSystem = AppConfig.getProperty("portal.system.default");
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if(userInfo.isAdmin())
            return StringUtils.isBlank(systemId)?menuService.getMenusByRole("",defaultSystem):menuService.getMenusByRole("",systemId);
        else
            return StringUtils.isBlank(systemId)?menuService.getMenusByRole(userInfo.getRoleIds(),defaultSystem):menuService.getMenusByRole(userInfo.getRoleIds(),systemId);
    }

    @RequestMapping("/menu/open")
    @ResponseBody
    public PfResource openMenu(@RequestParam String link) {
        if (link.startsWith("r:")){
            return handleResourceUrl(resourceService.getResource(link.replace("r:","")));
        }else{
            return handleResourceUrl(resourceService.getResource(link));
        }
    }

    private PfResource handleResourceUrl(PfResource pfResource){
        PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${","}");
        if(StringUtils.isNotBlank(pfResource.getResourceUrl())){
            String tmpUrl = pfResource.getResourceUrl();
            Properties properties = new Properties();
            properties.putAll(System.getProperties());
            pfResource.setResourceUrl(propertyPlaceholderHelper.replacePlaceholders(tmpUrl,properties));
        }
        return pfResource;
    }

}
