package com.gtis.portal.web;

import cn.gtmap.estateplat.service.server.BdcSlbhService;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.Page;
import com.gtis.common.util.ByteObjectAccess;
import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.service.FcNodeService;
import com.gtis.portal.service.LogService;
import com.gtis.portal.service.TaskCenterService;
import com.gtis.portal.service.impl.EnabledTurnStatusServiceContext;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.service.server.BdcZsService;
import com.gtis.portal.service.server.GjsqlxService;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.ReadXmlProps;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @version 1.0 , 2019/11/25
 * @description
 **/
@Controller
@RequestMapping("/indexOneMap")
public class IndexOneMapController {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysAuthorService sysAuthorService;
    @Autowired
    SysMenuService sysMenuService;
    @Autowired
    SysWorkFlowPostService sysWorkFlowPostService;
    @Autowired
    NodeService nodeService;
    @Autowired
    BdcSlbhService bdcSlbhService;
    @Autowired
    TaskCenterService taskCenterService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    FcNodeService fcNodeService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    LogService logService;
    @Autowired
    GjsqlxService gjsqlxService;
    @Autowired
    EnabledTurnStatusServiceContext enabledTurnStatusServiceContext;
    @Autowired
    SysWorkFlowDefineService oneMapWorkFlowDefineService;
    @Autowired
    @Qualifier("oneMapPlatformSplitDataService")
    SplitDataService oneMapPlatformSplitDataService;
    @Autowired
    @Qualifier("oneMapCalendarService")
    SysCalendarService oneMapCalendarService;
    @Autowired
    @Qualifier("oneMapTaskService")
    SysTaskService oneMapTaskService;
    @Autowired
    @Qualifier("oneMapWorkFlowCoreService")
    WorkFlowCoreService oneMapWorkFlowCoreService;


    @RequestMapping("")
    public Object indexOneMap(Model model, @RequestParam(value = "rid", required = false) String rid) throws Exception {
        String controlOrgan = AppConfig.getProperty("control.organ.list");
        if (StringUtils.isBlank(rid)){
            rid = "";
        }
        model.addAttribute("rid", rid);
        if (StringUtils.isNotBlank(rid) && rid.startsWith("r:")) {
            rid = rid.replace("r:", "");
        }
        UserInfo userInfo = SessionUtil.getCurrentUser();

        List<PfWorkFlowDefineVo> lstWorkFlowDefine;

        List<PfWorkFlowDefineVo> workFlowDefineList = oneMapWorkFlowDefineService.getWorkFlowDefineList();
        Map<String, List<PfWorkFlowDefineVo>> oneMapWorkFlowDefine = Maps.newLinkedHashMap();
        for (PfWorkFlowDefineVo pfWorkFlowDefineVo : workFlowDefineList) {
            String businessName = pfWorkFlowDefineVo.getBusinessVo().getBusinessName();
            String groupId = pfWorkFlowDefineVo.getGroupId();
            String categoryName = businessName;
            String createUrl = pfWorkFlowDefineVo.getCreateUrl() == null ? "" : pfWorkFlowDefineVo.getCreateUrl();
            pfWorkFlowDefineVo.setCreateUrl(AppConfig.getPlaceholderValue(createUrl));
            if (StringUtils.isNotBlank(groupId))
                categoryName = pfWorkFlowDefineVo.getResourceGroupVo().getGroupName();
            if (oneMapWorkFlowDefine.get(categoryName) != null) {
                oneMapWorkFlowDefine.get(categoryName).add(pfWorkFlowDefineVo);
            } else {
                List<PfWorkFlowDefineVo> wfdList = Lists.newArrayList();
                wfdList.add(pfWorkFlowDefineVo);
                oneMapWorkFlowDefine.put(categoryName, wfdList);
            }
        }
        model.addAttribute("oneMapWorkFlowDefineMap",oneMapWorkFlowDefine);
        if (userInfo.isAdmin() || StringUtils.isBlank(rid))
            lstWorkFlowDefine = sysWorkFlowDefineService.getWorkFlowDefineList();
        else
            lstWorkFlowDefine = sysWorkFlowDefineService.getWorkFlowDefineListByRole(userInfo.getRoleIds(), rid, null);
        Map<String, List<PfWorkFlowDefineVo>> mapWorkFlowDefine = Maps.newLinkedHashMap();
        for (PfWorkFlowDefineVo wfd : lstWorkFlowDefine) {
            String businessName = wfd.getBusinessVo().getBusinessName();
            String groupId = wfd.getGroupId();
            String categoryName = businessName;
            String createUrl = wfd.getCreateUrl() == null ? "" : wfd.getCreateUrl();
            wfd.setCreateUrl(AppConfig.getPlaceholderValue(createUrl));
            if (StringUtils.isNotBlank(groupId))
                categoryName = wfd.getResourceGroupVo().getGroupName();
            if (mapWorkFlowDefine.get(categoryName) != null) {
                mapWorkFlowDefine.get(categoryName).add(wfd);
            } else {
                List<PfWorkFlowDefineVo> wfdList = Lists.newArrayList();
                wfdList.add(wfd);
                mapWorkFlowDefine.put(categoryName, wfdList);
            }
        }
        model.addAttribute("workFlowDefineMap", mapWorkFlowDefine);
        model.addAttribute("workFlowDefineJson", JSON.toJSONString(lstWorkFlowDefine));
        SplitParamImpl splitParam1 = new SplitParamImpl();
        splitParam1.setQueryString("getTaskList");
        HashMap mapParam = Maps.newHashMap();
        mapParam.put("userIds", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());
        if (StringUtils.isNotBlank(controlOrgan)) {
            //获取当前人员所在部门
            List<PfOrganVo> currentOrganList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
            if (CollectionUtils.isNotEmpty(currentOrganList)) {
                for (PfOrganVo pfOrganVo : currentOrganList) {
                    if (controlOrgan.contains(pfOrganVo.getOrganId())) {
                        mapParam.put("ORGAN", pfOrganVo.getOrganId());
                        mapParam.put("CREATE_ORGAN",pfOrganVo.getOrganId());//创建人也要为当前人员所在的部门
                    }
                }
            }
        }

        splitParam1.setQueryParam(mapParam);
        model.addAttribute("taskList", ByteObjectAccess.objectToString(splitParam1));
        model.addAttribute("currentDate", CommonUtil.getCurrStrDate());
        List<PfBusinessVo> businessVoList = sysWorkFlowDefineService.getBusinessList();
        model.addAttribute("businessList", businessVoList != null ? businessVoList : Lists.newArrayList());
        List<PfOrganVo> pfOrganVoList = sysUserService.getAllOrganList();
        List<PfUserVo> pfUserVoList = sysUserService.getAllUsers();
        //获取过滤按钮信息
        List<Map> tasklistFilterList = ReadXmlProps.getTasklistFilterList();
        PfUserVo pfUserVo = sysUserService.getUserVo(SessionUtil.getCurrentUserId());
        String oneMapUrl = AppConfig.getProperty("oneMap.system.href");
        if (StringUtils.isNotBlank(oneMapUrl))
            oneMapUrl = StringUtils.substring(oneMapUrl, 0, oneMapUrl.indexOf("${")) + pfUserVo.getLoginName() + StringUtils.substring(oneMapUrl, oneMapUrl.indexOf("}") + 1, oneMapUrl.length());

        model.addAttribute("splitStr", Constants.SPLIT_STR);
        model.addAttribute("portalVersion", AppConfig.getProperty("portal.version"));
        model.addAttribute("showBusinessName", AppConfig.getBooleanProperty("workflowName.show.businessName", false));
        model.addAttribute("showUploadFile", AppConfig.getBooleanProperty("task.taskList.showUploadFile", true));
        model.addAttribute("wrapEnable", AppConfig.getBooleanProperty("task.list.wrap.enable", true));
        model.addAttribute("stateShowBegin", AppConfig.getBooleanProperty("task.state.showBegin.enable", false));
        model.addAttribute("showFilterBut", AppConfig.getBooleanProperty("show.tasklist.filter.button.enable", false));
        model.addAttribute("pfOrganVoList", pfOrganVoList);
        model.addAttribute("pfUserVoList", pfUserVoList);
        model.addAttribute("overTimeEnble", AppConfig.getProperty("task.overTime.enable"));
        model.addAttribute("showSsxzEnable", AppConfig.getProperty("task.list.show.ssxz.enable"));
        model.addAttribute("tasklistFilterList", tasklistFilterList);
        model.addAttribute("userid", SessionUtil.getCurrentUserId());
        model.addAttribute("projectlistPostEnable", AppConfig.getProperty("projectlist.post.enable"));
        model.addAttribute("bdcdjUrl", AppConfig.getProperty("bdcdj.url"));
        model.addAttribute("oneMapUrl",oneMapUrl);

        return "index-oneMap";
    }

    /**
     * 一张图查询待办任务
     * @param splitInfo
     * @param param
     * @param start
     * @param limit
     * @return
     */
    @RequestMapping("splitData")
    @ResponseBody
    public Object splitOneMapData(@RequestParam(value = "splitInfo") String splitInfo,@RequestParam(value = "param")String param,@RequestParam(value = "start") int start,@RequestParam(value = "limit") int limit){
        Map parameter = new HashMap<String,String>();
        parameter.put("userId", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());
        if(StringUtils.isNotBlank(param) && param.contains(":")){
            String[] split = param.split(":");
            if(StringUtils.isNotBlank(split[0]) && StringUtils.isNotBlank(split[1]))
                parameter.put(split[0], split[1]);
        }
        Page query = oneMapPlatformSplitDataService.query(splitInfo, parameter, start, limit);
        return query;
    }


    /**
     * 一张图查询待办任务数量
     * @param splitInfo
     * @param param
     * @return
     */
    @RequestMapping("splitDataCount")
    @ResponseBody
    public Integer spltOneMapDataCount(@RequestParam(value = "splitInfo") String splitInfo,@RequestParam(value = "param")String param){
        Map parameter = new HashMap<String,String>();
        parameter.put("userId", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds() );
        if(StringUtils.isNotBlank(param) && param.contains(":")){
            String[] split = param.split(":");
            if(StringUtils.isNotBlank(split[0])&& StringUtils.isNotBlank(split[1]))
                parameter.put(split[0], split[1]);
        }
        int count = oneMapPlatformSplitDataService.getCount(splitInfo, parameter);
        return count;
    }

    @RequestMapping("oneMapWorkflowDefinition")
    @ResponseBody
    public Object getOneMapWorkflowDefinition(@RequestParam String wdid){
        Map workflowDefinitionMap = Maps.newHashMap();
        PfWorkFlowDefineVo pfWorkFlowDefineVo = null;
        if(StringUtils.isNotBlank(wdid)){
            pfWorkFlowDefineVo = oneMapWorkFlowDefineService.getWorkFlowDefine(wdid);
        }
        if (pfWorkFlowDefineVo != null){
            workflowDefinitionMap.put("createTaskAlertSave","");//默认情况
        }
        workflowDefinitionMap.put("workflowDefine",pfWorkFlowDefineVo);
        workflowDefinitionMap.put("username",SessionUtil.getCurrentUser().getUsername());
        workflowDefinitionMap.put("createTime", CommonUtil.getCurrStrDate());
        return workflowDefinitionMap;
    }

    @RequestMapping("calMoreSendUsers")
    @ResponseBody
    public Object calMoreSendUsers(String paramString){
        HashMap taskMap = new HashMap();
        if(StringUtils.isNotBlank(paramString)){
            List<HashMap> mapList = JSON.parseArray(paramString,HashMap.class);
            if (mapList != null && mapList.size() > 0){
                for (int i = 0; i < mapList.size(); i++) {
                    HashMap map = mapList.get(i);
                    String tmpTaskId= MapUtils.getString(map,"TASKID");
                    map.put("FORWARDER",initSendUsers(tmpTaskId));
                    if (StringUtils.equals(MapUtils.getString(map,"WORKFLOW_STATE"),"3") ||
                            StringUtils.equals("-1",MapUtils.getString(map,"TIME_LIMIT")) ||
                            StringUtils.equals("-1",MapUtils.getString(map,"WFD_TIME_LIMIT")) ||
                            StringUtils.equals(MapUtils.getString(map,"TASK_OVER_TIME"),"2999-12-31") ||
                            StringUtils.equals(MapUtils.getString(map,"OVER_TIME"),"2999-12-31")){
                        map.put("TIME_LEFT",9999);
                        map.put("WF_TIME_LEFT",9999);
                    }else{
                        map.put("TIME_LEFT",initTimeLeft(MapUtils.getString(map,"TASK_OVER_TIME")));
                        map.put("WF_TIME_LEFT",initTimeLeft(MapUtils.getString(map,"OVER_TIME")));
                    }
                    taskMap.put(tmpTaskId,map);
                }
            }
        }
        //Struts2Utils.renderJson(JSON.toJSONString(taskMap));
        return taskMap;//Action.NONE;
    }

    private String initSendUsers(String tmpTaskId){
        StringBuffer userNameBuffer=new StringBuffer();
        PfTaskVo taskVo = oneMapTaskService.getTask(tmpTaskId);
        if (taskVo==null){
            taskVo = oneMapTaskService.getHistoryTask(tmpTaskId);
        }
        List<PfTaskVo> beforeTasks=oneMapTaskService.getHistoryTaskByBefore(taskVo);
        if (beforeTasks!=null && beforeTasks.size()>0) {
            int size=0;
            for (PfTaskVo task:beforeTasks) {
                size++;
                userNameBuffer.append(task.getUserVo().getUserName() + " ");
            }
        }else{
            userNameBuffer.append("");
        }
        return userNameBuffer.toString();
    }


    private int initTimeLeft(String taskOverTime){
        Date overDate = CommonUtil.formateDateToStr(taskOverTime);
        return oneMapCalendarService.getTimeLeft(overDate);
    }

    /**
     * 创建一张图任务
     * 弹出工作流新建页面
     * @param pfWorkFlowInstanceVo
     * @return
     * @throws Exception
     */
    @RequestMapping("createDefaultTask")
    @ResponseBody
    public Object createTask(PfWorkFlowInstanceVo pfWorkFlowInstanceVo) throws Exception{
        Map result = Maps.newHashMap();
        result.put("success",false);
        String userId = SessionUtil.getCurrentUserId();
        String proId = UUIDGenerator.generate();
        pfWorkFlowInstanceVo.setWorkflowIntanceId(proId);
        pfWorkFlowInstanceVo.setProId(proId);
        String taskId=null;
        try {
            WorkFlowInfo infoObj = oneMapWorkFlowCoreService.createWorkFlowInstance(pfWorkFlowInstanceVo, userId);

            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                if (taskVo.getUserVo().getUserId().equals(userId)) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            if (StringUtils.isBlank(taskId)) {
                for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            result.put("createTaskAlertSave","");
        }catch (Exception e){
            e.printStackTrace();
        }

        result.put("success",true);
        result.put("taskId",taskId);
        return result;
    }
}
