package com.gtis.portal.support.rss;

import com.gtis.portal.model.RssContent;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Content;
import com.sun.syndication.feed.rss.Description;
import com.sun.syndication.feed.rss.Item;
import org.springframework.web.servlet.view.feed.AbstractRssFeedView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * rss配置
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2015/1/8
 */
public class RssViewer extends AbstractRssFeedView {

    @Override
    protected void buildFeedMetadata(Map<String, Object> model, Channel feed,
                                     HttpServletRequest request) {

        feed.setTitle("");
        feed.setDescription("");
        feed.setLink("");

        super.buildFeedMetadata(model, feed, request);
    }


    @Override
    protected List<Item> buildFeedItems(Map<String, Object> model,
                                        HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        @SuppressWarnings("unchecked")
        List<RssContent> listContent = (List<RssContent>) model.get("feedContent");
        List<Item> items = new ArrayList<Item>(listContent.size());

        for(RssContent tempContent : listContent ){

            Item item = new Item();

            Content content = new Content();
            content.setValue(tempContent.getDescription());
            item.setContent(content);

            item.setTitle(tempContent.getTitle());
            item.setLink(tempContent.getUrl());
            Description description=new Description();
            description.setValue(tempContent.getDescription());
            item.setDescription(description);
            item.setLink(tempContent.getUrl());
            item.setPubDate(tempContent.getPubDate());

            items.add(item);
        }

        return items;
    }

}
