package com.gtis.portal.service.server.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.BdcXm;
import com.gtis.portal.entity.BdcZdSqlxDzb;
import com.gtis.portal.entity.DbBdcXm;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.util.QueryCondition;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 不动产项目接口实现
 */
@Service
public class BdcXmServiceImpl implements BdcXmService {
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;

    @Override
    public List<BdcXm> getBdcXmList(String wiid) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("wiid", QueryCondition.EQ, wiid);
        queryConditions.add(queryCondition);

        List<BdcXm> result = baseDao.get(BdcXm.class, queryConditions);
        return result;
    }

    @Override
    public List<DbBdcXm> getDbBdcXmList(String wiid) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("wiid", QueryCondition.EQ, wiid);
        queryConditions.add(queryCondition);
        List<DbBdcXm> result = baseDao.get(DbBdcXm.class, queryConditions);
        return result;
    }

    @Override
    public List<BdcZdSqlxDzb> getBdcZdSqlxDzbList() {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        String orderBy = " order by gjfl1,gjfl3,ordernum ";
        List<BdcZdSqlxDzb> result = baseDao.get(BdcZdSqlxDzb.class, queryConditions,orderBy);
        return result;
    }
}
