package com.gtis.portal.service.server;

import com.gtis.portal.entity.BdcGzlsx;
import com.gtis.portal.entity.BdcZdpjjl;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;


public interface WorkFlowTimeLimitService {
    /**
     * 获取工作流时限列表信息
     * @param wdid 工作流id
     * @param jdmc 节点名称
     * @param page 分页
     * @return 工作流时限列表信息
     */
    public Page<BdcGzlsx> queryGzlsxList(String wdid, String jdmc, Pageable page);

    /**
     * 通过所填表格中的信息获取数据库中的记录
     * @param wdid 工作流id
     * @param jdid 节点id
     * @param gzlsx 工作流时限
     *  @param  jdsx 节点 时限
     * @return 记录
     */
    public BdcGzlsx getBdcGzlsxByWdidAndJdid(String wdid,String jdid ,Integer gzlsx ,Integer jdsx);

    /**
     * 保存配置
     * @param bdcGzlsx 工作流时限表
     */
    public void save(BdcGzlsx bdcGzlsx);

    /**
     * 获取工作流时限配置信息
     * @param id
     * @return
     */
    public BdcGzlsx getBdcGzlsxjl(String id);

    /**
     * 删除工作流时限配置信息
     * @param id
     */
    public void delBdcGzlsxjl(String id);

    /**
     * 根据工作流id和节点id查询信息
     * @param wdid 工作流id
     * @param jdmc 节点id
     * @return List
     */
    public List<BdcGzlsx> queryGzlsxList(String wdid, String jdmc);

    /**
     * 通过所填表格中的信息获取数据库中的记录(根据工作流id，节点id，和单位代码查询数据)
     * @param workflow_id 工作流id
     * @param activity_id 节点id
     * @param dwdm 单位代码
     * @return BdcGzlsx
     */
    public BdcGzlsx getBdcGzlsxByWdidAndJdidAndDwdm(String workflow_id, String activity_id, String dwdm);
}
