package com.gtis.portal.service.server;

import com.gtis.portal.entity.BdcCqtxjl;
import org.springframework.data.domain.Page;
import org.springframework.data.querydsl.QPageRequest;

/**
 * @author <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @version 1.0 , 2019/11/7
 * @description
 **/
public interface OverTimeRemindService {
    /**
     * 获取记录分页
     * @param wdid 工作流id
     * @param jdmc 节点名称
     * @param pageable page
     * @return Page<BdcCqtxjl>
     */
    Page<BdcCqtxjl> queryBdcCqtxjlList(String wdid, String jdmc, QPageRequest pageable);

    /**
     * 通过工作流id和节点id获取不动产超期提醒记录
     * @param gzlid 工作流id
     * @param jdid 节点id
     * @return BdcCqtxjl
     */
    BdcCqtxjl getBdcCqtxjlByWdidAndJdid(String gzlid, String jdid);

    /**
     * 保存
     * @param bdcCqtxjl 不动产超期提醒记录
     */
    void save(BdcCqtxjl bdcCqtxjl);

    /**
     * 根据id删除
     * @param id
     */
    void delBdcCqtxjl(String id);
}
