package com.gtis.portal.service.server;


import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.entity.BdcZdpjjlAll;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

public interface AutoTurnAllTaskService {
    /**
     * 获取自动派件分页信息
     *
     * @param userid
     * @param page
     * @param kqzt
     * @return
     */
    public Page<BdcZdpjjlAll> queryBdcZdpjjlallList(String userid, String kqzt, Pageable page);

    /**
     * 获取自动派件信息
     *
     * @param id
     * @return
     */
    public BdcZdpjjlAll getBdcZdpjjl(String id);


    /**
     * 根据用户id获取自动派件的信息
     *
     * @param yhid
     * @return
     */
    public BdcZdpjjlAll getBdcZdpjjlByWdidAndJdidAndYhid(String yhid);

    /**
     * 保存自动派件信息
     *
     * @param bdcZdpjjl
     */
    public void save(BdcZdpjjlAll bdcZdpjjl);

    /**
     * 删除自动派件信息
     *
     * @param id
     */
    public void delBdcZdpjjl(String id);

    /**
     * 查询用户id考勤状态自动派件的信息
     *
     * @param userid
     * @param kqzt
     * @return
     */
    public List<BdcZdpjjlAll> queryBdcZdpjjlList(String userid, String kqzt);

    /**
     * 更新全局自动派件表
     *
     * @param bdcZdpjjl
     * @return void
     * @author <a href="mailto:shenfei@gtmap.cn">shenfei</a>
     * @date 2019/6/23
     */
    public void updateBdcZdpjjl(BdcZdpjjlAll bdcZdpjjl);

    /**
     *  @param userVoList 用户列表
     * 获取全局自动派件下，转发的下一个用户id
     */
    public String getBdczdpjAllYhid(List<PfUserVo> userVoList);
}
