package com.gtis.portal.service.impl.quartz;

import cn.gtmap.estateplat.model.server.core.BdcGg;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.portal.entity.BDCGG;
import com.gtis.portal.service.TaskActionService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
 * @date : 2019-05-27 10:46
 * @Description : 当公告结束时间到期后自动解挂
 */
@Service
public class AutoUnPublicTaskService {
    protected final Logger logger = Logger.getLogger(getClass());
    @Autowired
    TaskActionService taskActionService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;

    @Scheduled(cron = "${autoUnPublicTask.quartz.config}")
    public void autoPostTask() {
        try {
            //将bdc_gg数据逻辑删除
            List<BDCGG> listgg = taskActionService.getbdcggListByCondition("", "1");
            for (int i = 0; i < listgg.size(); i++) {
                Date jssj = listgg.get(i).getJssj();
                String wiid = listgg.get(i).getWiid();
                if (new Date().after(jssj)) {
                    BDCGG bdcgg = new BDCGG();
                    bdcgg.setWiid(listgg.get(i).getWiid());
                    bdcgg.setProid(listgg.get(i).getProid());
                    bdcgg.setGgid(listgg.get(i).getGgid());
                    bdcgg.setSffb("0");
                    bdcgg.setKssj(listgg.get(i).getKssj());
                    bdcgg.setJssj(listgg.get(i).getJssj());
                    taskActionService.update(bdcgg);
                    workFlowCoreService.unLockWorkFlowInstance(wiid);
                }
            }
        } catch (Exception e) {
            logger.error("取消公告 异常，异常原因：" + e.getMessage());
        }
    }
}
