package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.service.portal.TaskPerformerFilterService;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.List;
import java.util.Random;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/9/21
 * @description
 */
public class TaskPerformerRandomFilterServiceImpl implements TaskPerformerFilterService {
    @Override
    public List<PfUserVo> getTaskPerformers(String wiid,String targetActivityDefinitionId,PfTaskVo sourceTask, List<PfUserVo> sourceUsers,String wdid) {
        Random random = new Random();
        int randomInt = random.nextInt(sourceUsers.size());
        String hideUsername=AppConfig.getProperty("turnTask.hide.random.username.enable");
        List<PfUserVo> userVoList=Lists.newArrayList(sourceUsers.get(randomInt));
        if(StringUtils.isNotBlank(hideUsername) && CollectionUtils.isNotEmpty(userVoList)){
            for(PfUserVo pfUserVo:userVoList){
                if(StringUtils.equals(hideUsername,"true"))
                    pfUserVo.setUserName("全部");
            }
        }
        return userVoList;
    }

    @Override
    public WorkFlowInfo createWorkFlowInstance(PfWorkFlowInstanceVo intanceVo, String userId) throws Exception {
        return null;
    }
}
