package com.gtis.portal.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.BdcXm;
import com.gtis.portal.service.TaskCenterService;
import com.gtis.portal.service.server.BdcXmService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/9/30
 * @description
 */
@Service
public class TaskCenterServiceImpl implements TaskCenterService {
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    BdcXmService bdcXmService;

    @Override
    @Cacheable(value = "taskCenterCache", key = "#userInfo.id+'handleTaskOverListDisplay'")
    public boolean handleTaskOverListDisplay(UserInfo userInfo) {
        String taskOverListDisplay = AppConfig.getProperty("taskOverList.display.role");
        boolean taskOverListDisplayed = false;
        if (StringUtils.isBlank(taskOverListDisplay) || userInfo.isAdmin()) {
            taskOverListDisplayed = true;
        } else {
            List roles = Lists.newArrayList(taskOverListDisplay.split(","));
            List<PfRoleVo> roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (roles.contains(pfRoleVo.getRoleId())) {
                        taskOverListDisplayed = true;
                        break;
                    }
                }
            }
        }
        return taskOverListDisplayed;
    }

    @Override
    @Cacheable(value = "taskCenterCache", key = "#userInfo.id+'handleProjectListDisplay'")
    public boolean handleProjectListDisplay(UserInfo userInfo) {
        String projectListDisplay = AppConfig.getProperty("projectList.display.role");
        boolean projectListDisplayed = false;
        if (StringUtils.isBlank(projectListDisplay) || userInfo.isAdmin()) {
            projectListDisplayed = true;
        } else {
            List roles = Lists.newArrayList(projectListDisplay.split(","));
            List<PfRoleVo> roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (roles.contains(pfRoleVo.getRoleId())) {
                        projectListDisplayed = true;
                        break;
                    }
                }
            }
        }
        return projectListDisplayed;
    }

    @Override
    @Cacheable(value = "taskCenterCache", key = "#userInfo.id+'handleProjectListFilterUserid'")
    public boolean handleProjectListFilterUserid(UserInfo userInfo) {
        String projectListFilterUserid = AppConfig.getProperty("projectList.filter.userid.role");
        boolean projectListFilter = false;
        if (StringUtils.isBlank(projectListFilterUserid) || userInfo.isAdmin()) {
            projectListFilter = false;
        } else {
            List roles = Lists.newArrayList(projectListFilterUserid.split(","));
            List<PfRoleVo> roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (roles.contains(pfRoleVo.getRoleId())) {
                        projectListFilter = true;
                        break;
                    }
                }
            }
        }
        return projectListFilter;
    }

    @Override
    @Cacheable(value = "taskCenterCache", key = "#userInfo.id+'handleOverTimeTaskListDisplay'")
    public boolean handleOverTimeTaskListDisplay(UserInfo userInfo) {
        String overTimeTaskListDisplay = AppConfig.getProperty("overTimeList.display.role");
        boolean overTimeTaskListDisplayed = false;
        if (StringUtils.isBlank(overTimeTaskListDisplay) || userInfo.isAdmin()) {
            overTimeTaskListDisplayed = true;
        } else {
            List roles = Lists.newArrayList(overTimeTaskListDisplay.split(","));
            List<PfRoleVo> roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (roles.contains(pfRoleVo.getRoleId())) {
                        overTimeTaskListDisplayed = true;
                        break;
                    }
                }
            }
        }
        return overTimeTaskListDisplayed;
    }

    @Override
    @Cacheable(value = "taskCenterCache", key = "#userInfo.id+'handlePersonalProjectListDisplay'")
    public boolean handlePersonalProjectListDisplay(UserInfo userInfo) {
        String personalProjectListDisplay = AppConfig.getProperty("personalProjectList.display.role");
        boolean personalProjectListDisplayed = false;
        if (StringUtils.isBlank(personalProjectListDisplay) || userInfo.isAdmin()) {
            personalProjectListDisplayed = true;
        } else {
            List roles = Lists.newArrayList(personalProjectListDisplay.split(","));
            List<PfRoleVo> roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (roles.contains(pfRoleVo.getRoleId())) {
                        personalProjectListDisplayed = true;
                        break;
                    }
                }
            }
        }
        return personalProjectListDisplayed;
    }

    @Override
    @Cacheable(value = "taskCenterCache", key = "#userInfo.id+'delTaskBtnDisplay'")
    public boolean delTaskBtnDisplay(UserInfo userInfo) {
        String delTaskBtnDisplayRole = AppConfig.getProperty("task.list.del.role");
        boolean delTaskBtnListDisplayed = false;
        if (StringUtils.isBlank(delTaskBtnDisplayRole) || userInfo.isAdmin()) {
            delTaskBtnListDisplayed = true;
        } else {
            List roles = Lists.newArrayList(delTaskBtnDisplayRole.split(","));
            List<PfRoleVo> roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (roles.contains(pfRoleVo.getRoleId())) {
                        delTaskBtnListDisplayed = true;
                        break;
                    }
                }
            }
        }
        return delTaskBtnListDisplayed;
    }

    @Override
    public boolean batchTurnTaskBtnDisplay(UserInfo userInfo) {
        String batchTurnBtnDisplayRole = AppConfig.getProperty("taskList.batchTurn.display.role");
        boolean batchTurnBtnDListDisplayed = false;
        if (StringUtils.isBlank(batchTurnBtnDisplayRole)) {
            batchTurnBtnDListDisplayed = false;
        } else {
            List roles = Lists.newArrayList(batchTurnBtnDisplayRole.split(","));
            List<PfRoleVo> roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (roles.contains(pfRoleVo.getRoleId())) {
                        batchTurnBtnDListDisplayed = true;
                        break;
                    }
                }
            }
        }
        return batchTurnBtnDListDisplayed;
    }

    @Override
    @Cacheable(value = "taskCenterCache", key = "#userInfo.id+'handleTurnTaskListDisplay'")
    public boolean handleTurnTaskListDisplay(UserInfo userInfo) {
        String turnTaskListDisplay = AppConfig.getProperty("turnTaskList.display.role");
        boolean turnTaskListDisplayed = false;
        if (StringUtils.isBlank(turnTaskListDisplay) || userInfo.isAdmin()) {
            turnTaskListDisplayed = true;
        } else {
            List roles = Lists.newArrayList(turnTaskListDisplay.split(","));
            List<PfRoleVo> roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (roles.contains(pfRoleVo.getRoleId())) {
                        turnTaskListDisplayed = true;
                        break;
                    }
                }
            }
        }
        return turnTaskListDisplayed;
    }

    @Override
    @Cacheable(value = "taskCenterCache", key = "#wiid+'overTimeState'")
    public Map getTaskOverTimeState(String wiid) {
        Map overTimeMap = Maps.newHashMap();
        String getOverTimeUrl = AppConfig.getProperty("task.show.overTimeState.url");
        if (StringUtils.isNotBlank(getOverTimeUrl)) {
            try {
                Map param = Maps.newHashMap();
                param.put("wiid", wiid);
                Object obj = restTemplate.getForObject(getOverTimeUrl, String.class, param);
                if (obj != null) {
                    overTimeMap = (Map) JSONObject.parse(obj.toString());
                }
            } catch (Exception e) {
            }
        }
        overTimeMap.put("wiid", wiid);
        return overTimeMap;
    }

    @Override
    @Cacheable(value = "taskCenterCache", key = "#wiid+'xmly'")
    public Map getXmly(String wiid) {
        Map xmlyMap = Maps.newHashMap();

        if (StringUtils.isNotBlank(wiid)) {
            try {
                List<BdcXm> bdcXmList = bdcXmService.getBdcXmList(wiid);
                if (CollectionUtils.isNotEmpty(bdcXmList)) {
                    if (AppConfig.getBooleanProperty("xmly.show.modify.confirm",false)) {
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(bdcXmList.get(0).getYhsqywh()))
                            xmlyMap.put("xmly", "银行");
                        else  if (org.apache.commons.lang3.StringUtils.isNotBlank(bdcXmList.get(0).getWwslbh()))
                            xmlyMap.put("xmly", "外网");
                        else
                            xmlyMap.put("xmly", "不动产");
                    } else {
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(bdcXmList.get(0).getYhsqywh()))
                            xmlyMap.put("xmly", "银行");
                        else  if (org.apache.commons.lang3.StringUtils.isNotBlank(bdcXmList.get(0).getWwslbh()))
                            xmlyMap.put("xmly", "一窗受理");
                        else
                            xmlyMap.put("xmly", "不动产");
                    }


                }
            } catch (Exception e) {
            }
        }
        xmlyMap.put("wiid", wiid);
        return xmlyMap;
    }

    @Override
    @Cacheable(value = "taskCenterCache", key = "#userInfo.id+'handlePostTaskListDisplay'")
    public boolean handlePostTaskListDisplay(UserInfo userInfo) {
        String postTaskListDisplay = AppConfig.getProperty("postTaskList.display.role");
        boolean postTaskListDisplayed = false;
        if (StringUtils.isBlank(postTaskListDisplay) || userInfo.isAdmin()) {
            postTaskListDisplayed = true;
        } else {
            List roles = Lists.newArrayList(postTaskListDisplay.split(","));
            List<PfRoleVo> roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (roles.contains(pfRoleVo.getRoleId())) {
                        postTaskListDisplayed = true;
                        break;
                    }
                }
            }
        }
        return postTaskListDisplayed;
    }

    @Override
    @Cacheable(value = "taskCenterCache", key = "#userInfo.id+'handleTaskDeleteOtherTask'")
    public boolean handleTaskDeleteOtherTask(UserInfo userInfo) {
        String deleteOtherTaskRoles = AppConfig.getProperty("task.taskHandle.deleteOtherTask.role");
        boolean deleteOtherTaskEnable = false;

            List roles = Lists.newArrayList(deleteOtherTaskRoles.split(","));
            List<PfRoleVo> roleVoList = userInfo.getLstRole();
            if (roleVoList != null) {
                for (PfRoleVo pfRoleVo : roleVoList) {
                    if (roles.contains(pfRoleVo.getRoleId())) {
                        deleteOtherTaskEnable = true;
                        break;
                    }
                }
            }
        return deleteOtherTaskEnable;
    }
}
