/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.gtis.portal.entity.PfBusiness;
import com.gtis.portal.entity.PfWorkflowDefinition;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfResourceGroupService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.PfWorkflowDefinitionService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import java.io.InputStream;
import java.sql.Blob;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/workflow"})
public class WorkflowController
extends BaseController {
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfResourceGroupService groupService;
    @Autowired
    PfWorkflowDefinitionService workflowDefinitionService;
    @Autowired
    PfBusinessService businessService;
    @Resource
    @Qualifier(value="boolListNumber")
    List<PublicVo> boolListNumber;
    @Resource
    @Qualifier(value="priorityList")
    List<PublicVo> priorityList;
    @Resource
    @Qualifier(value="databaseList")
    List<PublicVo> databaseList;

    @RequestMapping(value={""})
    public String manage(Model model) {
        model.addAttribute("boolListNumber", (Object)this.boolListNumber);
        model.addAttribute("priorityList", (Object)this.priorityList);
        model.addAttribute("databaseList", (Object)this.databaseList);
        return "/config/workflow/manage";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object resourcejson(Model model) {
        if (SessionUtil.getCurrentUser().isAdmin()) {
            Ztree ztree = this.workflowDefinitionService.getAllWfdTree();
            return ztree;
        }
        return null;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public PfWorkflowDefinition getWorkflowDefinition(@RequestParam(value="keyId", required=false) String keyId) {
        PfWorkflowDefinition wfd = this.workflowDefinitionService.findById(keyId);
        return wfd == null ? new PfWorkflowDefinition() : wfd;
    }

    @RequestMapping(value={"image"})
    @ResponseBody
    public void image(@RequestParam(value="keyId", required=false) String keyId, HttpServletResponse response) {
        PfWorkflowDefinition wfd = this.workflowDefinitionService.findById(keyId);
        if (wfd != null && wfd.getWorkflowImage() != null) {
            Blob blob = wfd.getWorkflowImage();
            InputStream in = null;
            try {
                in = blob.getBinaryStream();
                ServletOutputStream out = response.getOutputStream();
                byte[] data = new byte[(int)blob.length()];
                int i = 0;
                while ((i = in.read(data)) != -1) {
                    out.write(data);
                }
                out.close();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="wfd") PfWorkflowDefinition wfd, Model model) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)wfd.getWorkflowDefinitionId())) {
                this.workflowDefinitionService.update(wfd);
            }
            wfd = this.workflowDefinitionService.findById(wfd.getWorkflowDefinitionId());
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", true);
            result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            result.put("wfd", wfd);
            return result;
        }
        return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
    }

    @RequestMapping(value={"infoBs"})
    @ResponseBody
    public PfBusiness getBusiness(@RequestParam(value="keyId", required=false) String keyId) {
        PfBusiness bs = this.businessService.findById(keyId);
        return bs == null ? new PfBusiness() : bs;
    }

    @RequestMapping(value={"saveBs"})
    @ResponseBody
    public Object saveBusiness(HttpServletRequest req, PfBusiness business, Model model) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)business.getBusinessId())) {
                this.businessService.update(business);
            }
            business = this.businessService.findById(business.getBusinessId());
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", true);
            result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            result.put("business", business);
            return result;
        }
        return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
    }
}

