/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.gtis.common.util.Md5Util;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.entity.PfUserOrganRel;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfOrganService;
import com.gtis.portal.service.PfUserOrganService;
import com.gtis.portal.service.PfUserRoleService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.util.BlobHelper;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"config/user"})
public class UserController
extends BaseController {
    @Autowired
    private PfOrganService organService;
    @Autowired
    private PfUserOrganService userOrganService;
    @Autowired
    private PfUserService userService;
    @Autowired
    private PfUserRoleService userRoleService;
    @Resource
    @Qualifier(value="degreeList")
    List<PublicVo> degreeList;
    @Resource
    @Qualifier(value="sexList")
    List<PublicVo> sexList;
    @Resource
    @Qualifier(value="boolListNumber")
    List<PublicVo> boolListNumber;

    @RequestMapping(value={""})
    public String manage(Model model) {
        model.addAttribute("degreeList", (Object)this.degreeList);
        model.addAttribute("sexList", (Object)this.sexList);
        model.addAttribute("boolListNumber", (Object)this.boolListNumber);
        return "/config/user/manager";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object organuserjson(Model model) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if (userInfo.isAdmin()) {
            regionCode = null;
        }
        Ztree ztree = this.organService.getAllOrganUserTree(regionCode);
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        treeList.add(ztree);
        if (userInfo.isAdmin()) {
            Ztree othertree = this.organService.getOtherTree(2);
            othertree.setNoR(true);
            treeList.add(othertree);
        }
        return treeList;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public Object getUserinfo(@RequestParam(value="userId", required=true) String userId, HttpServletResponse response) throws Exception {
        PfUser user = (PfUser)this.userService.findById((Object)userId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("user", user);
        return result;
    }

    @RequestMapping(value={"select"})
    public String select(Model model, @RequestParam(value="foreignId", required=true) String foreignId, String paramString) {
        model.addAttribute("foreignId", (Object)foreignId);
        model.addAttribute("paramString", (Object)paramString);
        return "/config/user/user-select";
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object saveUserinfo(HttpServletRequest req, @ModelAttribute(value="user") PfUser user, Model model) throws Exception {
        PfUser usertmp;
        if (StringUtils.isBlank((String)user.getUserId())) {
            user.setUserId(UUIDGenerator.generate18());
        }
        if ((usertmp = (PfUser)this.userService.findById((Object)user.getUserId())) != null) {
            user.setOrganId(usertmp.getOrganId());
            this.userService.updateUserinfo(user);
        } else {
            user.setLoginPassword(Md5Util.Build((String)""));
            this.userService.insert((Object)user);
            PfUserOrganRel userOrganRel = new PfUserOrganRel();
            userOrganRel.setUserId(user.getUserId());
            userOrganRel.setOrganId(user.getOrganId());
            userOrganRel.setUdrId(UUIDGenerator.generate18());
            this.userOrganService.insert((Object)userOrganRel);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("user", user);
        return result;
    }

    @RequestMapping(value={"delUser"})
    @ResponseBody
    public Object del(String organ_id, String del_mark, String user_id) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)organ_id) && StringUtils.isNotBlank((String)del_mark) && StringUtils.isNotBlank((String)user_id)) {
                if ("3".equals(del_mark)) {
                    this.userOrganService.deleteUserOrganRelByUserIdAndOrganId(user_id, organ_id);
                    return this.handlerSuccessJson();
                }
                if ("4".equals(del_mark)) {
                    this.userService.deleteById(user_id);
                    return this.handlerSuccessJson();
                }
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerErrorJson();
    }

    @RequestMapping(value={"userSign"})
    @ResponseBody
    public void getUserSign(@RequestParam(value="userId", required=true) String userId, HttpServletResponse response) throws Exception {
        PfUser user = (PfUser)this.userService.findById((Object)userId);
        if (user != null && user.getUserSign() != null && user.getUserSign().length() != 0L) {
            this.outputImg(user.getUserSign(), response);
        }
    }

    @RequestMapping(value={"userPhoto"})
    @ResponseBody
    public void getUserPhoto(@RequestParam(value="userId", required=true) String userId, HttpServletResponse response) throws Exception {
        PfUser user = (PfUser)this.userService.findById((Object)userId);
        if (user != null && user.getUserPhoto() != null && user.getUserPhoto().length() != 0L) {
            this.outputImg(user.getUserPhoto(), response);
        }
    }

    @RequestMapping(value={"saveUserLogin"})
    @ResponseBody
    public Object saveUserLogin(@ModelAttribute(value="user") PfUser userlogin) throws Exception {
        PfUser usertmp = (PfUser)this.userService.findById((Object)userlogin.getUserId());
        if (usertmp != null) {
            PfUser user = new PfUser();
            user.setUserId(userlogin.getUserId());
            user.setLoginName(userlogin.getLoginName());
            user.setLoginPassword(Md5Util.Build((String)userlogin.getLoginPassword()));
            this.userService.updateUserLogin(user);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", true);
            result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            return result;
        }
        return this.handlerErrorJson();
    }

    @RequestMapping(value={"saveUserPhoto"})
    @ResponseBody
    public void saveUserPhoto(@RequestParam(value="userId", required=true) String userId, @RequestParam MultipartFile user_Photo, HttpServletResponse response) throws Exception {
        PfUser user = (PfUser)this.userService.findById((Object)userId);
        response.setContentType("text/html;charset=GBK");
        PrintWriter out = response.getWriter();
        String msg = "";
        if (user != null) {
            HashMap result = new HashMap();
            if (user_Photo.getSize() != 0L) {
                if (user_Photo.getSize() > 102400L) {
                    msg = "\u64cd\u4f5c\u5931\u8d25\uff01\u4e0a\u4f20\u56fe\u7247\u4e0d\u80fd\u5927\u4e8e100Kb!";
                } else {
                    Blob user_Photoblob = BlobHelper.createBlob((byte[])user_Photo.getBytes());
                    user.setUserPhoto(user_Photoblob);
                    this.userService.updateUserBlob(user, 0);
                    msg = "\u64cd\u4f5c\u6210\u529f\uff01";
                }
            } else {
                msg = "\u64cd\u4f5c\u5931\u8d25\uff01\u6ca1\u6709\u4e0a\u4f20\u7684\u56fe\u7247\uff01";
            }
        }
        out.print("<script type='text/javascript'>alert('" + msg + "');</script>");
    }

    @RequestMapping(value={"saveUserSign"})
    @ResponseBody
    public void saveUserSign(@RequestParam(value="userId", required=true) String userId, @RequestParam MultipartFile user_Sign, HttpServletResponse response) throws Exception {
        PfUser user = (PfUser)this.userService.findById((Object)userId);
        response.setContentType("text/html;charset=GBK");
        PrintWriter out = response.getWriter();
        String msg = "";
        if (user != null) {
            HashMap result = new HashMap();
            if (user_Sign.getSize() != 0L) {
                if (user_Sign.getSize() > 102400L) {
                    msg = "\u64cd\u4f5c\u5931\u8d25\uff01\u4e0a\u4f20\u56fe\u7247\u4e0d\u80fd\u5927\u4e8e100Kb!";
                } else {
                    Blob user_Signblob = BlobHelper.createBlob((byte[])user_Sign.getBytes());
                    user.setUserSign(user_Signblob);
                    this.userService.updateUserBlob(user, 1);
                    msg = "\u64cd\u4f5c\u6210\u529f\uff01";
                }
            } else {
                msg = "\u64cd\u4f5c\u5931\u8d25\uff01\u6ca1\u6709\u4e0a\u4f20\u7684\u56fe\u7247\uff01";
            }
        }
        out.print("<script type='text/javascript'>alert('" + msg + "');</script>");
    }

    private void outputImg(Blob blob, HttpServletResponse response) throws Exception {
        InputStream insm = blob.getBinaryStream();
        byte[] buf = new byte[1024];
        ServletOutputStream out = response.getOutputStream();
        int len = 0;
        while ((len = insm.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        out.flush();
        out.close();
        insm.close();
    }
}

