/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.alibaba.fastjson.JSON;
import com.gtis.portal.entity.PfSubsystem;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfAuthorizeService;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.PfRoleService;
import com.gtis.portal.service.PfSubsystemService;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/sub"})
public class SubsystemController
extends BaseController {
    @Autowired
    PfMenuService menuService;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfSubsystemService subsystemService;
    @Autowired
    PfRoleService roleService;
    @Autowired
    PfAuthorizeService authorizeService;
    @Resource
    @Qualifier(value="boolListNumber")
    List<PublicVo> boolListNumber;
    @Resource
    @Qualifier(value="subTypeList")
    List<PublicVo> subTypeList;
    @Resource
    @Qualifier(value="subMenuTypeList")
    List<PublicVo> subMenuTypeList;

    @RequestMapping(value={""})
    public String manage(Model model) {
        if (SessionUtil.getCurrentUser().isAdmin()) {
            model.addAttribute("boolListNumber", (Object)this.boolListNumber);
            model.addAttribute("subTypeList", (Object)this.subTypeList);
            model.addAttribute("subMenuTypeList", (Object)this.subMenuTypeList);
            List subList = this.subsystemService.getAllSubsystemList(false);
            String curSubId = "";
            if (subList != null && subList.size() > 0) {
                curSubId = ((PfSubsystem)subList.get(0)).getSubsystemId();
            }
            model.addAttribute("curSubId", (Object)curSubId);
        }
        return "/config/menu/submenu";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object subjson(Model model) {
        List ztreeList = this.subsystemService.getSubsystemTree();
        return ztreeList;
    }

    @RequestMapping(value={"all"})
    @ResponseBody
    public Object allSub(Model model) {
        List subList = this.subsystemService.getSubsystemAuthorList(SessionUtil.getCurrentUserId());
        if (subList != null && subList.size() > 0) {
            for (int i = 0; i < subList.size(); ++i) {
                String url = ((PfSubsystem)subList.get(i)).getSubUrl();
                if (!StringUtils.isNotBlank((String)url)) continue;
                ((PfSubsystem)subList.get(i)).setSubUrl(RequestUtils.initOptProperties((String)url));
            }
        }
        return subList;
    }

    @RequestMapping(value={"checkjson"})
    @ResponseBody
    public Object menuCheckjson(Model model, @RequestParam(value="subId", required=false) String subId) {
        Ztree ztree = this.menuService.getSubMenuCheckTree(subId);
        return ztree;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public PfSubsystem getSubsystem(@RequestParam(value="subsystemId", required=false) String subsystemId) {
        PfSubsystem subsystem = (PfSubsystem)this.subsystemService.findById((Object)subsystemId);
        if (subsystem == null) {
            subsystem = new PfSubsystem();
            subsystem.setSubsystemId(subsystemId);
        }
        Ztree ztree = this.menuService.getSubMenuTree(subsystem.getSubsystemId());
        subsystem.setSubmenuTree(ztree);
        return subsystem;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="subsystem") PfSubsystem subsystem, Model model) {
        PfSubsystem tmpSub;
        if (StringUtils.isBlank((String)subsystem.getSubsystemId())) {
            subsystem.setSubsystemId(this.subsystemService.getMaxSubsystemId().toString());
        }
        if ((tmpSub = (PfSubsystem)this.subsystemService.findById((Object)subsystem.getSubsystemId())) != null) {
            this.subsystemService.update((Object)subsystem);
        } else {
            this.subsystemService.insert((Object)subsystem);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("sub", subsystem);
        return result;
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public Object del(@RequestParam(value="keyId", required=false) String keyId) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)keyId)) {
                this.subsystemService.deleteSubAndRelById(keyId);
                return this.handlerSuccessJson();
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"menujson"})
    @ResponseBody
    public Object subMenuJson(Model model, @RequestParam(value="subId", required=false) String subId) {
        Ztree ztree = this.menuService.getSubMenuTree(subId);
        return ztree;
    }

    @RequestMapping(value={"saveRel"})
    @ResponseBody
    public Object saveSubMenuRel(HttpServletRequest req, String paramString, @RequestParam(value="subId", required=true) String subId, Model model) {
        if (paramString != null && StringUtils.isNotBlank((String)subId)) {
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.subsystemService.updateSubMenuRel(changeList, subId);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        return result;
    }

    @RequestMapping(value={"delRel"})
    @ResponseBody
    public Object delSubMenuRel(@RequestParam(value="subId", required=true) String subId, @RequestParam(value="menuId", required=true) String menuId) {
        if (StringUtils.isNotBlank((String)subId) && StringUtils.isNotBlank((String)menuId)) {
            this.subsystemService.deleteSubMenuRel(menuId, subId);
            return this.handlerSuccessJson();
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"author"})
    public String author(Model model, @RequestParam(value="subId", required=false) String subId) {
        if (SessionUtil.getCurrentUser().isAdmin()) {
            model.addAttribute("boolListNumber", (Object)this.boolListNumber);
            model.addAttribute("subTypeList", (Object)this.subTypeList);
            model.addAttribute("subMenuTypeList", (Object)this.subMenuTypeList);
            List subList = this.subsystemService.getAllSubsystemList(false);
            String curSubId = subId;
            if (StringUtils.isBlank((String)curSubId) && subList != null && subList.size() > 0) {
                curSubId = ((PfSubsystem)subList.get(0)).getSubsystemId();
            }
            model.addAttribute("curSubId", (Object)curSubId);
        }
        return "/config/menu/submenu-author";
    }

    @RequestMapping(value={"authManage"})
    public String authManage(Model model, @RequestParam(value="subId", required=false) String subId) {
        this.author(model, subId);
        return "/config/menu/submenu-author-manage";
    }

    @RequestMapping(value={"roleRelList"})
    @ResponseBody
    public Object roleCheckjson(Model model, @RequestParam(value="subId", required=false) String subId) {
        List treeList = this.roleService.getRoleRelListBySubId(subId);
        return treeList;
    }

    @RequestMapping(value={"roleReljson"})
    @ResponseBody
    public Object roleReljson(Model model, @RequestParam(value="subId", required=false) String subId) {
        Ztree ztree = this.roleService.getRoleTreeBySubId(subId, null);
        return ztree;
    }

    @RequestMapping(value={"saveRoleRel"})
    @ResponseBody
    public Object saveRoleRel(String paramString, @RequestParam(value="subId", required=true) String subId) {
        if (paramString != null && StringUtils.isNotBlank((String)subId)) {
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.subsystemService.updateSubRoleRel(subId, changeList);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        return result;
    }

    @RequestMapping(value={"delRoleRel"})
    @ResponseBody
    public Object delRoleRel(@RequestParam(value="subId", required=true) String subId, @RequestParam(value="roleId", required=true) String roleId) {
        if (StringUtils.isNotBlank((String)subId) && StringUtils.isNotBlank((String)roleId)) {
            this.authorizeService.delAuthByRoleAndObjId(roleId, subId, Constants.AuthorizeObjType.SUB.getBm());
            return this.handlerSuccessJson();
        }
        return this.handlerSuccessJson();
    }
}

