/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfRole;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfDistrictService;
import com.gtis.portal.service.PfRoleService;
import com.gtis.portal.service.PfUserRoleService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/role"})
public class RoleController
extends BaseController {
    @Autowired
    private PfUserRoleService userRoleServer;
    @Autowired
    private PfUserService userService;
    @Autowired
    private PfRoleService roleService;
    @Autowired
    PfDistrictService districtService;

    @RequestMapping(value={"select"})
    public String select(Model model, @RequestParam(value="foreignId", required=true) String foreignId, String paramString) {
        model.addAttribute("foreignId", (Object)foreignId);
        model.addAttribute("paramString", (Object)paramString);
        return "/config/role/role-select";
    }

    @RequestMapping(value={""})
    public String manage(Model model) {
        return "/config/role/manager";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object rolejson(Model model) {
        Ztree tree = this.roleService.getRoleRegionTree(null);
        return tree;
    }

    @RequestMapping(value={"userjson"})
    @ResponseBody
    public Object userJson(Model model, @RequestParam(value="roleId", required=true) String roleId) {
        List treeList = this.userService.getTreeByRoleId(roleId);
        return treeList;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public Object getRole(@RequestParam(value="roleId", required=false) String roleId) {
        PfRole role = (PfRole)this.roleService.findById((Object)roleId);
        List userList = this.userService.getTreeByRoleId(roleId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("role", role);
        result.put("userList", userList);
        return result;
    }

    @RequestMapping(value={"saveUserRole"})
    @ResponseBody
    public Object saveUserRole(HttpServletRequest req, @RequestParam(value="roleId", required=true) String roleId, String paramString) {
        if (StringUtils.isNotBlank((String)paramString) && StringUtils.isNotBlank((String)roleId)) {
            System.out.println(paramString);
            List changeList = JSON.parseArray((String)StringUtils.trim((String)paramString), ZtreeChanged.class);
            this.userRoleServer.addRoleUserRel(roleId, changeList);
        }
        return super.handlerSuccessJson();
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="role") PfRole role, Model model) {
        PfRole roletmp;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)role.getRoleId())) {
            role.setRoleId(UUIDGenerator.generate18());
            List roletmp2 = this.roleService.getRoleByName(role.getRoleName());
            if (roletmp2 != null && roletmp2.size() > 0) {
                result.put("success", false);
                result.put("msg", "\u8981\u6dfb\u52a0\u7684\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
                return result;
            }
        }
        if ((roletmp = (PfRole)this.roleService.findById((Object)role.getRoleId())) != null) {
            this.roleService.update((Object)role);
        } else {
            this.roleService.insert((Object)role);
        }
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("role", role);
        return result;
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public Object del(@ModelAttribute(value="role") PfRole role) {
        if (RequestUtils.checkIsAdmin()) {
            if (role != null) {
                this.roleService.deleteById(role.getRoleId());
                return this.handlerSuccessJson();
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlererrorJson();
    }

    @RequestMapping(value={"delUserRoleRel"})
    @ResponseBody
    public Object delUserRoleRel(String roleId, String userId) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)userId)) {
                this.userRoleServer.deleteUserRoleByUseridAndRoleId(roleId, userId);
                return this.handlerSuccessJson();
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlererrorJson();
    }

    private Object handlererrorJson() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        return result;
    }

    private Set datahandle(String data) {
        HashSet<String> s = new HashSet<String>();
        String[] datas = data.split("@");
        if (datas != null) {
            for (int i = 0; i < datas.length; ++i) {
                s.add(datas[i]);
            }
        }
        return s;
    }

    @RequestMapping(value={"userRoleList"})
    @ResponseBody
    public Object userRoleList(@RequestParam(value="userId", required=false) String userId) {
        List treeList = this.userRoleServer.findRolebyUserId(userId);
        return treeList;
    }

    @RequestMapping(value={"saveUserRoleRel"})
    @ResponseBody
    public Object saveUserRoleRel(HttpServletRequest req, @RequestParam(value="userId", required=true) String userId, String paramString) {
        if (StringUtils.isNotBlank((String)paramString) && StringUtils.isNotBlank((String)userId)) {
            System.out.println(paramString);
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.userRoleServer.addRoleRel(userId, changeList);
        }
        return this.handlerSuccessJson();
    }
}

