/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.gtis.config.AppConfig;
import java.io.File;
import java.io.FileInputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/reloadProp"})
public class ReloadPropertiesController {
    @RequestMapping(value={""})
    @ResponseBody
    public Object execute(Model model) throws Exception {
        String[] projects = new String[]{"egov", "platform", "portal"};
        Properties properties = new Properties();
        Map appProperties = AppConfig.getProperties();
        for (int i = 0; i < projects.length; ++i) {
            String project = projects[i];
            if (!StringUtils.isNotBlank((String)project)) continue;
            try {
                String filePath = this.getEgovhomeConfigFilePath(project);
                File file = new File(filePath);
                if (!file.exists() || !file.isFile()) continue;
                FileInputStream inputStream = new FileInputStream(file);
                Properties prop = new Properties();
                prop.load(inputStream);
                properties.putAll((Map<?, ?>)prop);
                inputStream.close();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            String oldValue;
            String key = (String)en.nextElement();
            String newValue = this.initOptProperties(properties.getProperty(key), properties);
            if (StringUtils.equals((String)newValue, (String)(oldValue = this.initOptProperties(AppConfig.getProperty((String)key), properties)))) continue;
            System.setProperty(key, newValue);
            appProperties.put(key, newValue);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        return result;
    }

    private String getEgovhomeConfigFilePath(String project) throws Exception {
        String path = AppConfig.getProperty((String)"egov.conf");
        path = URLDecoder.decode(path, "UTF-8");
        String filePath = path = path.replace("file:/", "");
        filePath = StringUtils.equalsIgnoreCase((String)"egov", (String)project) ? filePath + "egov.properties" : (StringUtils.equalsIgnoreCase((String)"gis", (String)project) ? filePath + "gis.properties" : filePath + project + "/application.properties");
        return filePath;
    }

    private String initOptProperties(String url, Properties properties) {
        if (url != null) {
            PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
            url = propertyPlaceholderHelper.replacePlaceholders(url, properties);
        }
        return url;
    }
}

