/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.gtis.config.AppConfig;
import com.gtis.portal.properties.PropertyEntry;
import com.gtis.portal.properties.SafeProperties;
import com.gtis.portal.util.CommonUtils;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/pro"})
public class PropertiesController
extends BaseController {
    @RequestMapping(value={""})
    public String manage(Model model, String paramString, String project) throws Exception {
        List fileList = CommonUtils.getEgovhomeConfigFileList();
        if (StringUtils.isBlank((String)project)) {
            project = (String)fileList.get(0);
        }
        LinkedHashMap propMap = new LinkedHashMap();
        for (int i = 0; i < fileList.size(); ++i) {
            String value = AppConfig.getProperty((String)("config.reload." + (String)fileList.get(i) + ".url"));
            if (!StringUtils.isBlank((String)value)) {
                value = RequestUtils.initOptProperties((String)value);
            }
            propMap.put(fileList.get(i), value);
        }
        List proList = new ArrayList();
        LinkedHashMap entryMap = new LinkedHashMap();
        if (SessionUtil.getCurrentUser().isAdmin() && StringUtils.isNotBlank((String)project)) {
            try {
                String filePath = CommonUtils.getEgovhomeConfigFilePath((String)project);
                File file = new File(filePath);
                if (file.exists() && file.isFile()) {
                    FileInputStream inputStream = new FileInputStream(file);
                    SafeProperties prop = new SafeProperties();
                    prop.load((InputStream)inputStream);
                    prop.initConfigCommentList();
                    proList = prop.getProList();
                    entryMap = prop.getEntryMap();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        model.addAttribute("project", (Object)project);
        model.addAttribute("entryMap", entryMap);
        model.addAttribute("propMap", propMap);
        model.addAttribute("fileList", (Object)fileList);
        return "/config/properties/manage";
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, PropertyEntry propertyEntry, String project, String lastKey) {
        if (SessionUtil.getCurrentUser().isAdmin() && propertyEntry != null && StringUtils.isNotBlank((String)propertyEntry.getKey()) && StringUtils.isNotBlank((String)project)) {
            try {
                String comment = this.initComment(propertyEntry.getComment());
                propertyEntry.setComment(comment);
                String filePath = CommonUtils.getEgovhomeConfigFilePath((String)project);
                File file = new File(filePath);
                if (file.exists() && file.isFile()) {
                    FileInputStream inputStream = new FileInputStream(file);
                    SafeProperties prop = new SafeProperties();
                    prop.load((InputStream)inputStream);
                    prop.initConfigCommentList();
                    LinkedHashMap entryMap = prop.getEntryMap();
                    if (StringUtils.isNotBlank((String)lastKey)) {
                        if (entryMap.containsKey(propertyEntry.getKey())) {
                            return this.handlerErrorJson("\u5df2\u7ecf\u5b58\u5728\u8be5\u914d\u7f6e\u9879\uff1a" + propertyEntry.getKey() + "\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5");
                        }
                        if (entryMap.containsKey(lastKey)) {
                            PropertyEntry lastEntry = (PropertyEntry)entryMap.get(lastKey);
                            PropertyEntry entry = new PropertyEntry(propertyEntry.getKey(), propertyEntry.getValue(), null, propertyEntry.getComment());
                            prop.getContext().getCommentOrEntrys().add(lastEntry.getIndex() + 1, entry);
                            if (StringUtils.isNotBlank((String)propertyEntry.getComment())) {
                                prop.getContext().getCommentOrEntrys().add(lastEntry.getIndex() + 1, "");
                                prop.getContext().getCommentOrEntrys().add(lastEntry.getIndex() + 2, propertyEntry.getComment());
                            }
                            FileOutputStream output = new FileOutputStream(filePath);
                            prop.store((OutputStream)output, null);
                            output.close();
                        }
                    } else if (entryMap.containsKey(propertyEntry.getKey())) {
                        PropertyEntry entry = (PropertyEntry)entryMap.get(propertyEntry.getKey());
                        entry.setValue(propertyEntry.getValue());
                        entry.setComment(propertyEntry.getComment());
                        int length = entry.getLineNum();
                        if (length > 0) {
                            prop.getContext().getCommentOrEntrys().add(entry.getLastIndex(), "");
                            prop.getContext().getCommentOrEntrys().add(entry.getIndex() + 1, entry.getComment());
                        } else if (StringUtils.isNotBlank((String)entry.getComment())) {
                            prop.getContext().getCommentOrEntrys().add(entry.getLastIndex(), "");
                            prop.getContext().getCommentOrEntrys().add(entry.getIndex() + 1, entry.getComment());
                        }
                        for (int i = 0; i < length; ++i) {
                            prop.getContext().getCommentOrEntrys().remove(entry.getLastIndex() + 1);
                        }
                        prop.put((Object)entry.getKey(), (Object)entry.getValue());
                        FileOutputStream output = new FileOutputStream(filePath);
                        prop.store((OutputStream)output, null);
                        output.close();
                    }
                    Map appProperties = AppConfig.getProperties();
                    appProperties.put(propertyEntry.getKey(), propertyEntry.getValue());
                    AppConfig.setConfiguration((Map)appProperties);
                    System.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"refresh"})
    @ResponseBody
    public Object refresh(HttpServletRequest req, String project) {
        if (StringUtils.isNotBlank((String)project)) {
            String projectUrl = RequestUtils.initOptProperties((String)AppConfig.getProperty((String)("config.reload." + project + ".url")));
            System.out.println(projectUrl);
            if (StringUtils.isNotBlank((String)projectUrl)) {
                try {
                    URL url = new URL(projectUrl);
                    HttpURLConnection urlcon = (HttpURLConnection)url.openConnection();
                    urlcon.connect();
                    InputStream is = urlcon.getInputStream();
                    BufferedReader buffer = new BufferedReader(new InputStreamReader(is));
                    StringBuffer bs = new StringBuffer();
                    String l = null;
                    while ((l = buffer.readLine()) != null) {
                        bs.append(l).append("/n");
                    }
                    System.out.println(bs.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                return this.handlerErrorJson("\u8bf7\u914d\u7f6e\u8be5\u4e1a\u52a1\u7cfb\u7edf\u3010" + project + "\u3011\u5bf9\u5e94\u7684\u914d\u7f6e\u52a0\u8f7d\u5730\u5740\uff1aconfig.reload." + project + ".url\uff01");
            }
        }
        return this.handlerSuccessJson();
    }

    private String initComment(String oldCom) {
        String comment = "";
        if (StringUtils.isNotBlank((String)oldCom)) {
            oldCom = StringUtils.removeEnd((String)oldCom, (String)"\n");
            oldCom = StringUtils.replace((String)oldCom, (String)" ", (String)"");
            oldCom = StringUtils.replace((String)oldCom, (String)"\u3000", (String)"");
            String[] coms = StringUtils.split((String)oldCom, (String)"\n");
            for (int i = 0; i < coms.length; ++i) {
                if (!StringUtils.isNotBlank((String)coms[i])) continue;
                comment = !StringUtils.startsWith((String)coms[i], (String)"#") ? comment + "#" + coms[i] : comment + coms[i];
                comment = comment + "\r\n";
            }
        }
        comment = StringUtils.removeEnd((String)comment, (String)"\r\n");
        comment = StringUtils.removeStart((String)comment, (String)"\r\n");
        return comment;
    }
}

