/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfOrgan;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfOrganService;
import com.gtis.portal.service.PfUserOrganService;
import com.gtis.portal.service.PfUserRoleService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/organ"})
public class OrganController
extends BaseController {
    @Autowired
    private PfOrganService organService;
    @Autowired
    private PfUserOrganService userOrganService;
    @Autowired
    private PfUserService userService;
    @Autowired
    private PfUserRoleService userRoleService;
    @Resource
    @Qualifier(value="degreeList")
    List<PublicVo> degreeList;
    @Resource
    @Qualifier(value="sexList")
    List<PublicVo> sexList;

    @RequestMapping(value={""})
    public String manage(Model model) {
        model.addAttribute("degreeList", (Object)this.degreeList);
        model.addAttribute("sexList", (Object)this.sexList);
        return "/config/organ/manager";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object organjson(Model model) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        Ztree ztree = null;
        ztree = userInfo.isAdmin() ? this.organService.getAllOrganTree(null) : this.organService.getOrganTreeByUserId(userInfo.getId());
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        treeList.add(ztree);
        if (userInfo.isAdmin()) {
            Ztree othertree = this.organService.getOtherTree(1);
            othertree.setNoR(true);
            treeList.add(othertree);
        }
        return treeList;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public Object getroganList(@RequestParam(value="organ_id", required=false) String organ_id) {
        PfOrgan organ = (PfOrgan)this.organService.findById((Object)organ_id);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("organ", organ);
        return result;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="organ") PfOrgan organ, Model model) {
        boolean isok;
        if (StringUtils.isBlank((String)organ.getOrganId())) {
            organ.setOrganId(UUIDGenerator.generate18());
        }
        if (!(isok = this.organService.checkValidRegionCode(organ.getRegionCode(), organ.getSuperOrganId()))) {
            return this.handlerErrorJson("\u5f53\u524d\u90e8\u95e8\u884c\u653f\u533a\u4ee3\u7801\u548c\u4e0a\u7ea7\u90e8\u95e8\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
        PfOrgan organtmp = (PfOrgan)this.organService.findById((Object)organ.getOrganId());
        if (organtmp != null) {
            this.organService.update((Object)organ);
        } else {
            this.organService.insert((Object)organ);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("organ", organ);
        return result;
    }

    @RequestMapping(value={"delOrgan"})
    @ResponseBody
    public Object del(String organ_id, String del_mark, String user_id) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)organ_id) && StringUtils.isNotBlank((String)del_mark)) {
                List organIdList = this.organService.findAllOrgan(organ_id);
                if ("1".equals(del_mark)) {
                    for (String tmpId : organIdList) {
                        this.organService.deleteById(tmpId);
                    }
                    return this.handlerSuccessJson();
                }
                if ("2".equals(del_mark)) {
                    this.organService.deleteOrganAndUserById(organ_id);
                    return this.handlerSuccessJson();
                }
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerErrorJson();
    }

    @RequestMapping(value={"select"})
    public String select(Model model, @RequestParam(value="foreignId", required=true) String foreignId, String paramString) {
        model.addAttribute("foreignId", (Object)foreignId);
        model.addAttribute("paramString", (Object)paramString);
        return "/config/organ/organ-select";
    }

    @RequestMapping(value={"userjson"})
    @ResponseBody
    public Object userJson(Model model, @RequestParam(value="organId", required=true) String organId) {
        List treeList = this.userService.getTreeByOrganId(organId);
        return treeList;
    }

    @RequestMapping(value={"userOrganList"})
    @ResponseBody
    public Object userOrganList(@RequestParam(value="userId", required=false) String userId) {
        List treeList = this.userOrganService.findOrganbyUserId(userId);
        return treeList;
    }

    @RequestMapping(value={"findOtherUser"})
    @ResponseBody
    public Object findOtherUser() {
        List userList = this.organService.findOtherUser();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("userList", userList);
        return result;
    }

    @RequestMapping(value={"saveUserOrganRel"})
    @ResponseBody
    public Object saveUserOrganRel(HttpServletRequest req, @RequestParam(value="userId", required=true) String userId, String paramString) {
        if (StringUtils.isNotBlank((String)paramString) && StringUtils.isNotBlank((String)userId)) {
            System.out.println(paramString);
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.userOrganService.addOrganRelByUserId(userId, changeList);
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"saveOrganUserRel"})
    @ResponseBody
    public Object saveOrganUserRel(HttpServletRequest req, @RequestParam(value="organId", required=true) String organId, String paramString) {
        if (StringUtils.isNotBlank((String)paramString) && StringUtils.isNotBlank((String)organId)) {
            System.out.println(paramString);
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.userOrganService.addUserRelByOrganId(organId, changeList);
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"delUserOrganRel"})
    @ResponseBody
    public Object delUserOrganRel(String userId, String organId) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)userId) && StringUtils.isNotBlank((String)organId)) {
                this.userOrganService.deleteUserOrganRelByUserIdAndOrganId(userId, organId);
                return this.handlerSuccessJson();
            }
            return this.handlerErrorJson();
        }
        return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
    }
}

