/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.alibaba.fastjson.JSON;
import com.gtis.portal.entity.PfResourcePartition;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfInstanceAuthorizeService;
import com.gtis.portal.service.PfResourcePartitionService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/instAuth"})
public class InstanceAuthController
extends BaseController {
    @Autowired
    PfInstanceAuthorizeService instanceAuthorizeService;
    @Autowired
    PfResourcePartitionService resourcePartitionService;
    @Resource
    @Qualifier(value="partitionTypeList")
    List<PublicVo> partitionTypeList;
    @Resource
    @Qualifier(value="partitionOperatType")
    List<PublicVo> partitionOperatType;

    @RequestMapping(value={""})
    public String manage(Model model, String wdid) {
        model.addAttribute("wdid", (Object)wdid);
        model.addAttribute("partitionTypeJson", (Object)JSON.toJSONString((Object)this.partitionTypeList));
        model.addAttribute("partitionOperatTypeJson", (Object)JSON.toJSONString((Object)this.partitionOperatType));
        return "/config/workflow/wfd-inst-auth";
    }

    @RequestMapping(value={"rolejson"})
    @ResponseBody
    public Object rolejson(Model model, String wdid) {
        List treeList = this.instanceAuthorizeService.getAuthorizeRoleTreeListByWdId(wdid);
        return treeList;
    }

    @RequestMapping(value={"resourcejson"})
    @ResponseBody
    public Object resourcejson(Model model, String wdid, String roleId, boolean ischeck) {
        List treeList = this.instanceAuthorizeService.getAuthorizeResourceTreeListByWdId(wdid, roleId, ischeck);
        return treeList;
    }

    @RequestMapping(value={"partiInfo"})
    @ResponseBody
    public List<PfResourcePartition> getPartiInfo(@RequestParam(value="wdid", required=true) String wdid, @RequestParam(value="roleId", required=true) String roleId, @RequestParam(value="resourceId", required=true) String resourceId) {
        List<PfResourcePartition> rpList = null;
        if (StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)resourceId)) {
            HashMap partMap = this.instanceAuthorizeService.getInstancePartMap(wdid, roleId, resourceId);
            rpList = this.resourcePartitionService.getListByRid(resourceId);
            if (rpList != null && rpList.size() > 0) {
                for (int i = 0; i < rpList.size(); ++i) {
                    PfResourcePartition rp = (PfResourcePartition)rpList.get(i);
                    if (!partMap.containsKey(rp.getPartitionId())) continue;
                    rp.setOperType(((PfResourcePartition)partMap.get(rp.getPartitionId())).getOperType());
                    rpList.set(i, rp);
                }
            }
        }
        return rpList == null ? new ArrayList() : rpList;
    }

    @RequestMapping(value={"saveRel"})
    @ResponseBody
    public Object saveRel(HttpServletRequest req, @RequestParam(value="wdid", required=true) String wdid, String paramString) {
        if (StringUtils.isNotBlank((String)paramString) && StringUtils.isNotBlank((String)wdid)) {
            System.out.println(paramString);
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.instanceAuthorizeService.addRoleRel(wdid, changeList);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        return result;
    }

    @RequestMapping(value={"delRel"})
    @ResponseBody
    public Object delRel(@RequestParam(value="wdid", required=true) String wdid, @RequestParam(value="roleId", required=true) String roleId) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId)) {
                this.instanceAuthorizeService.deleteAuthorizeListByWdIdAndRole(wdid, roleId);
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"saveResourceRel"})
    @ResponseBody
    public Object saveResourceRel(HttpServletRequest req, @RequestParam(value="wdid", required=true) String wdid, String paramString) {
        if (StringUtils.isNotBlank((String)paramString) && StringUtils.isNotBlank((String)wdid)) {
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.instanceAuthorizeService.addResourceRel(wdid, changeList);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        return result;
    }

    @RequestMapping(value={"updateResourceVisible"})
    @ResponseBody
    public Object updateResourceVisible(HttpServletRequest req, @RequestParam(value="wdid", required=true) String wdid, @RequestParam(value="roleId", required=true) String roleId, String paramString) {
        if (StringUtils.isNotBlank((String)paramString) && StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId)) {
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.instanceAuthorizeService.updateResourceRel(wdid, roleId, changeList);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        return result;
    }

    @RequestMapping(value={"delResourceRel"})
    @ResponseBody
    public Object delResourceRel(@RequestParam(value="wdid", required=true) String wdid, @RequestParam(value="roleId", required=true) String roleId, @RequestParam(value="resourceId", required=true) String resourceId) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)resourceId)) {
                this.instanceAuthorizeService.deleteAuthorizeListByWdIdAndResource(wdid, resourceId);
                return this.handlerSuccessJson();
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"updatePartOperType"})
    @ResponseBody
    public Object updatePartOperType(HttpServletRequest req, @RequestParam(value="wdid", required=true) String wdid, @RequestParam(value="roleId", required=true) String roleId, @RequestParam(value="resourceId", required=true) String resourceId, String paramString) {
        if (StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)resourceId) && StringUtils.isNotBlank((String)paramString)) {
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.instanceAuthorizeService.updatePartOperType(wdid, roleId, resourceId, changeList);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        return result;
    }
}

