/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfCalendar;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.service.PfCalendarService;
import com.gtis.portal.util.CalendarUtil;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/cal"})
public class CalendarController
extends BaseController {
    @Autowired
    PfCalendarService pfCalendarService;
    @Resource
    @Qualifier(value="calTypeList")
    List<PublicVo> calTypeList;
    @Resource
    @Qualifier(value="calWeekList")
    List<PublicVo> calWeekList;
    List<PublicVo> yearList;
    @Resource
    @Qualifier(value="monthList")
    List<PublicVo> monthList;

    @RequestMapping(value={""})
    public String manage(Model model, Pageable page, String paramString) {
        Integer year = CalendarUtil.getYear();
        Integer month = CalendarUtil.getMonth();
        if (StringUtils.isNotBlank((String)paramString)) {
            HashMap param = (HashMap)JSON.parseObject((String)paramString, HashMap.class);
            if (param.containsKey("year") && MapUtils.getInteger((Map)param, (Object)"year") != null) {
                year = MapUtils.getInteger((Map)param, (Object)"year");
            }
            if (param.containsKey("month") && MapUtils.getInteger((Map)param, (Object)"month") != null) {
                month = MapUtils.getInteger((Map)param, (Object)"month");
            }
        }
        List calendarList = this.pfCalendarService.getCalendarListByYM(year, month);
        model.addAttribute("year", (Object)year);
        model.addAttribute("month", (Object)month);
        model.addAttribute("calendarList", (Object)calendarList);
        model.addAttribute("calendar", (Object)new PfCalendar());
        model.addAttribute("calTypeList", (Object)this.calTypeList);
        model.addAttribute("calWeekList", (Object)this.calWeekList);
        this.yearList = new ArrayList();
        PublicVo publicVo = new PublicVo("", "---\u5e74\u4efd---");
        this.yearList.add(publicVo);
        for (int i = year - 10; i < year + 10; ++i) {
            publicVo = new PublicVo(String.valueOf(i), String.valueOf(i) + "\u5e74");
            this.yearList.add(publicVo);
        }
        model.addAttribute("yearList", (Object)this.yearList);
        model.addAttribute("monthList", (Object)this.monthList);
        return "/config/cal/manage";
    }

    @RequestMapping(value={"open"})
    @ResponseBody
    public PfCalendar open1(@RequestParam(value="calId", required=false) String calId) {
        PfCalendar calendar = this.pfCalendarService.findInitCalendar(calId);
        return calendar == null ? new PfCalendar() : calendar;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="calendar") PfCalendar calendar, Model model) {
        PfCalendar tmpCalendar;
        if (StringUtils.isBlank((String)calendar.getCalId())) {
            calendar.setCalId(UUIDGenerator.generate18());
        }
        if ((tmpCalendar = (PfCalendar)this.pfCalendarService.findById((Object)calendar.getCalId())) != null) {
            calendar.setAmBegin(CalendarUtil.formateDateByHMDate((String)(CalendarUtil.formateDatetoStr((Date)calendar.getCalDate()) + " " + calendar.getAmBeginStr())));
            calendar.setAmEnd(CalendarUtil.formateDateByHMDate((String)(CalendarUtil.formateDatetoStr((Date)calendar.getCalDate()) + " " + calendar.getAmEndStr())));
            calendar.setPmBegin(CalendarUtil.formateDateByHMDate((String)(CalendarUtil.formateDatetoStr((Date)calendar.getCalDate()) + " " + calendar.getPmBeginStr())));
            calendar.setPmEnd(CalendarUtil.formateDateByHMDate((String)(CalendarUtil.formateDatetoStr((Date)calendar.getCalDate()) + " " + calendar.getPmEndStr())));
            this.pfCalendarService.update(calendar);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("calendar", calendar);
        return result;
    }

    @RequestMapping(value={"create"})
    @ResponseBody
    public Object createCal(@RequestParam(value="year", required=true) Integer year, @RequestParam(value="month", required=false) Integer month) {
        String msg = "";
        msg = RequestUtils.checkIsAdmin() ? this.pfCalendarService.createCalByYear(year) : this.exceptionService.getExceptionMsg("9003");
        if (StringUtils.isBlank((String)msg)) {
            return this.handlerSuccessJson();
        }
        return this.handlerErrorJson(msg);
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public Object del(@RequestParam(value="year", required=true) Integer year, @RequestParam(value="month", required=false) Integer month) {
        if (!RequestUtils.checkIsAdmin()) {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        this.pfCalendarService.deleteCalByYearMonth(year);
        return this.handlerSuccessJson();
    }
}

